/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.datastructures;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Vector;
import se.sjobeck.datastructures.Drawing;
import se.sjobeck.datastructures.DrawingLine;
import se.sjobeck.datastructures.VertexDrawing;
import se.sjobeck.parser2.Function;

public class Point2DDrawing
extends VertexDrawing {
    private GeneralPath path;
    private Vector<Function> variables;
    private List<Point2D> vertices;

    public Point2DDrawing() {
    }

    public Point2DDrawing(List<Point2D> vertices, String desc) {
        this.description = desc;
        this.vertices = vertices;
        this.variables = new Vector();
        this.path = new GeneralPath();
        this.path.moveTo((float)vertices.get(0).getX(), (float)vertices.get(0).getY());
        for (int i = 1; i < vertices.size(); ++i) {
            this.path.lineTo((float)vertices.get(i).getX(), (float)vertices.get(i).getY());
        }
        this.makeVariables(this.variables, this.vertices, this.path);
        double area = Point2DDrawing.computeArea(vertices);
        if (area < 0.0) {
            area *= -1.0;
        }
        this.variables.add(new Function("T", "" + area, "Takyta"));
        this.variables.add(new Function("G", "" + area, "Golvyta"));
        this.path.closePath();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    private static double computeArea(List<Point2D> vertices) {
        double area = 0.0;
        for (int i = 0; i < vertices.size() - 1; ++i) {
            area += vertices.get(i).getX() * vertices.get(i + 1).getY() - vertices.get(i + 1).getX() * vertices.get(i).getY();
        }
        return (area += vertices.get(vertices.size() - 1).getX() * vertices.get(0).getY() - vertices.get(0).getX() * vertices.get(vertices.size() - 1).getY()) / 2.0;
    }

    @Override
    public Shape getShape() {
        return this.path;
    }

    @Override
    public Rectangle2D getBounds() {
        return this.path.getBounds2D();
    }

    @Override
    public Vector<Function> getVariables() {
        return this.variables;
    }

    @Override
    public int getLabelCount() {
        return this.vertices.size();
    }

    @Override
    public String getLabel(int which) {
        return "V" + (which + 1);
    }

    @Override
    public Point2D getLabelPosition(int which) {
        Point2D p1 = this.vertices.get(which);
        Point2D p2 = this.vertices.get((which + 1) % this.vertices.size());
        return new Point2D.Double(p1.getX() + (p2.getX() - p1.getX()) / 2.0, p1.getY() + (p2.getY() - p1.getY()) / 2.0);
    }

    @Override
    public Drawing copy() {
        Point2DDrawing p2d = new Point2DDrawing(this.vertices, this.description);
        Vector<Function> var = new Vector<Function>();
        for (Function fu : this.variables) {
            var.add(new Function(fu.getIdentifier(), fu.getValueStr(), fu.getDescription()));
        }
        p2d.variables = var;
        return p2d;
    }

    @Override
    public DrawingLine getLine(Point2D p, AffineTransform transform) {
        DrawingLine line = new DrawingLine();
        Point2D.Double p1 = new Point2D.Double();
        Point2D.Double p2 = new Point2D.Double();
        if (transform != null) {
            for (int i = 0; i < this.vertices.size(); ++i) {
                p1.setLocation(this.vertices.get(i));
                transform.transform(p1, p1);
                p2.setLocation(this.vertices.get((i + 1) % this.vertices.size()));
                transform.transform(p2, p2);
                line.setLine(p1, p2);
                if (!(line.ptSegDist(p) < 5.0)) continue;
                line.variable = "V" + (i + 1);
                return line;
            }
        }
        return null;
    }
}

