/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.gui.panels.export;

import org.icepdf.ri.common.views.painting.drawings.GeometraDrawing;
import se.sjobeck.geometra.datastructures.drawings.GeometraDrawingImpl;
import se.sjobeck.geometra.export.StructuredExport;
import se.sjobeck.geometra.gui.panels.export.Node;
import se.sjobeck.geometra.gui.panels.export.TextExporter;

public class VardeRadNode
extends Node {
    private String namn;
    private GeometraDrawing gd;
    private final StructuredExport exp;

    public VardeRadNode(String name, GeometraDrawing gd) {
        this.namn = name;
        this.gd = gd;
        this.exp = new StructuredExport(true, true, true, true, true, true);
    }

    VardeRadNode(String description, GeometraDrawing drawing, StructuredExport export) {
        this.namn = description;
        this.gd = drawing;
        this.exp = export;
    }

    @Override
    public int getNbrOfSemiColon() {
        return TextExporter.getInstance().nbrOfSemiColon(this.namn);
    }

    @Override
    public String toString(int nbrOfExtraSemiColon) {
        String temp = this.namn;
        nbrOfExtraSemiColon -= this.getNbrOfSemiColon();
        for (int i = 0; i < nbrOfExtraSemiColon; ++i) {
            temp = temp + ";";
        }
        if (this.exp.shouldExportArea()) {
            temp = temp + ";=" + this.gd.getArea() + this.gd.getAreaMod();
        }
        if (this.exp.shouldExportLength()) {
            temp = temp + ";=" + this.gd.getDistance() + this.gd.getDistanceMod();
        }
        if (this.exp.shouldExportVolume()) {
            temp = temp + ";=" + this.gd.getVolume() + this.gd.getVolumeMod();
        }
        if (this.exp.shouldExportWallArea()) {
            temp = temp + ";=" + this.gd.getWallSurface() + this.gd.getWallSurfaceMod();
        }
        if (this.exp.shouldExportNumberOfDrawing()) {
            temp = this.gd instanceof GeometraDrawingImpl ? temp + ";=" + ((GeometraDrawingImpl)this.gd).numberOfDrawings() : temp + ";=" + 1;
        }
        if (this.exp.shouldExportHeight()) {
            temp = temp + ";=" + this.gd.getHeight();
        }
        temp = temp.replace(".", ",");
        return temp + " \n";
    }
}

