/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.gui.panels;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.File;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import se.sjobeck.geometra.gui.panels.ButtonPane;

public class InfoPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final JLabel descriptionLabel = new JLabel("");
    private final JLabel animationLabel = new JLabel("");
    private final ImageIcon animation = ButtonPane.createIcon("anim.gif");

    public InfoPanel() {
        this.setLayout(new FlowLayout(3));
        this.animationLabel.setPreferredSize(new Dimension(17, 17));
        this.add(this.animationLabel);
        this.add(this.descriptionLabel);
    }

    public void showInfo(File currentProjectFile, Info info) {
        this.animationLabel.setIcon(this.animation);
        if (currentProjectFile != null) {
            if (info.equals((Object)Info.LOAD)) {
                this.descriptionLabel.setText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("STR_OPENING") + " " + currentProjectFile.getAbsolutePath());
            } else if (info.equals((Object)Info.SAVE)) {
                this.descriptionLabel.setText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("STR_SAVING") + " " + currentProjectFile.getAbsolutePath());
            }
        }
    }

    public void hideInfo() {
        Timer t = new Timer();
        t.schedule(new TimerTask(){

            @Override
            public void run() {
                InfoPanel.this.animationLabel.setIcon(null);
                InfoPanel.this.descriptionLabel.setText("");
            }
        }, 2000L);
    }

    public void showInfo(String filepath, Info info) {
        this.animationLabel.setIcon(this.animation);
        if (filepath != null) {
            if (info.equals((Object)Info.LOAD)) {
                this.descriptionLabel.setText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("STR_OPENING") + " " + filepath);
            } else if (info.equals((Object)Info.SAVE)) {
                this.descriptionLabel.setText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("STR_SAVING") + " " + filepath);
            }
        }
    }

    public static enum Info {
        LOAD,
        SAVE;

    }
}

