/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.gui.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.icepdf.ri.common.views.painting.core.Blueprint;
import org.icepdf.ri.common.views.painting.core.BlueprintPage;
import org.icepdf.ri.common.views.painting.core.GeometraCollection;
import org.icepdf.ri.common.views.painting.drawings.ScaleDrawing;
import se.sjobeck.geometra.datastructures.blueprint.GeometraManager;
import se.sjobeck.geometra.gui.main.Geometra;
import se.sjobeck.images.IconLoader;

public class ExportScaleDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final ScaleDrawing scaleDrawing;
    private final JLabel exportLabel;
    private final JList list;
    private final JScrollPane pane;
    private JPanel buttonPanel;
    private final GeometraManager geoManager = GeometraManager.getInstance();
    final MouseListener mouselistener = new MouseListener(){

        @Override
        public void mouseClicked(MouseEvent arg0) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (e.getSource() instanceof JButton) {
                ((JButton)e.getSource()).setBorderPainted(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (e.getSource() instanceof JButton) {
                ((JButton)e.getSource()).setBorderPainted(false);
            }
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }
    };

    public ExportScaleDialog(ScaleDrawing sd, GeometraCollection<BlueprintPage> collection) {
        collection.remove(sd.getParent());
        this.setModal(true);
        this.setAlwaysOnTop(true);
        this.setLocationRelativeTo(Geometra.GEOMETRA_FRAME);
        this.scaleDrawing = sd;
        this.createButtonPanel();
        HashSet<Blueprint> set = new HashSet<Blueprint>();
        for (BlueprintPage page : collection) {
            set.add(page.getParent());
        }
        ArrayList<Object> tempList = new ArrayList<Object>();
        for (Blueprint bp : set) {
            tempList.add(bp);
            for (BlueprintPage page : collection) {
                if (!page.getParent().equals(bp)) continue;
                tempList.add(page);
            }
        }
        this.exportLabel = new JLabel(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("STR_EXPORT") + " " + sd.getDescription());
        this.list = new JList<Object>(tempList.toArray());
        this.list.setCellRenderer(new ExportCellRenderer());
        this.pane = new JScrollPane(this.list);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        mainPanel.add((Component)this.pane, "Center");
        mainPanel.add((Component)this.exportLabel, "North");
        mainPanel.add((Component)this.buttonPanel, "South");
        this.add(mainPanel);
        this.pack();
        this.setVisible(true);
    }

    private void createButtonPanel() {
        this.buttonPanel = new JPanel();
        JButton export = new JButton(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("STR_EXPORT"));
        export.addMouseListener(this.mouselistener);
        export.setBorderPainted(false);
        export.setContentAreaFilled(false);
        export.setRolloverEnabled(true);
        export.setFocusPainted(false);
        export.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Object[] pages = ExportScaleDialog.this.list.getSelectedValues();
                ExportScaleDialog.this.geoManager.exportScaleDrawing(ExportScaleDialog.this.scaleDrawing, pages);
            }
        });
        JButton cancel = new JButton(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("BUTTON_CANCEL"));
        cancel.addMouseListener(this.mouselistener);
        cancel.setBorderPainted(false);
        cancel.setContentAreaFilled(false);
        cancel.setRolloverEnabled(true);
        cancel.setFocusPainted(false);
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportScaleDialog.this.setVisible(false);
                ExportScaleDialog.this.dispose();
            }
        });
        this.buttonPanel.add(export);
        this.buttonPanel.add(cancel);
    }

    private class ExportCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;
        private final String ABSOLUTEPATHSTR = "/se/sjobeck/geometra/gui/panels/jtreeicons/";
        private final Icon pageIcon = IconLoader.getIcon("/se/sjobeck/geometra/gui/panels/jtreeicons/page.png");
        private JLabel currentCell = new JLabel();

        private ExportCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            this.currentCell = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
            if (value instanceof BlueprintPage) {
                this.currentCell.setIcon(this.pageIcon);
            }
            return this.currentCell;
        }
    }
}

