/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.gui.panels;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.icepdf.ri.common.views.painting.core.GeometraCollection;
import org.icepdf.ri.common.views.painting.drawings.GeometraDrawing;
import se.sjobeck.geometra.datastructures.GeometraProperties;
import se.sjobeck.geometra.datastructures.blueprint.observer.GeometraSubject;
import se.sjobeck.geometra.datastructures.drawings.SmartDrawing;
import se.sjobeck.geometra.gui.main.Geometra;
import se.sjobeck.geometra.gui.panels.GeometraColorChooser;

public class ColorDialog
implements ActionListener {
    private static GeometraColorChooser gcc = GeometraColorChooser.getInstance();
    private JDialog colorDialog = new JDialog((Frame)Geometra.GEOMETRA_FRAME, ResourceBundle.getBundle("se/sjobeck/Geometra").getString("POPUP_PICK_COLOR"));
    private JPanel buttonPanel = new JPanel();
    private JButton okButton = new JButton();
    private JButton cancelButton = new JButton();
    private GeometraCollection<GeometraDrawing> currentDrawings = null;
    private GeometraDrawing currentDrawing = null;

    public ColorDialog() {
        this.setupButtonPanel();
        this.colorDialog.setModal(true);
        this.colorDialog.setLayout(new BorderLayout());
        this.colorDialog.add("Center", gcc);
        this.colorDialog.add("South", this.buttonPanel);
        this.colorDialog.pack();
        this.colorDialog.setLocationRelativeTo(Geometra.GEOMETRA_FRAME);
        this.okButton.setText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("BUTTON_OK"));
        this.cancelButton.setText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("BUTTON_CANCEL"));
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
    }

    public ColorDialog(GeometraCollection<GeometraDrawing> currentDrawings) {
        this();
        this.currentDrawings = currentDrawings;
    }

    public ColorDialog(GeometraDrawing currentDrawing) {
        this();
        this.currentDrawing = currentDrawing;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object ob = e.getSource();
        if (ob instanceof JButton) {
            JButton button = (JButton)ob;
            if (button.equals(this.cancelButton)) {
                this.setVisible(false);
                return;
            }
            if (button.equals(this.okButton)) {
                if (this.currentDrawings == null && this.currentDrawing == null) {
                    GeometraProperties.setColor(gcc.getColor());
                } else if (this.currentDrawings == null && this.currentDrawing != null) {
                    this.currentDrawing.setColor(gcc.getColor());
                } else if (this.currentDrawings != null) {
                    for (GeometraDrawing gd : this.currentDrawings) {
                        if (!(gd instanceof SmartDrawing)) {
                            gd.setColor(gcc.getColor());
                            continue;
                        }
                        if (!(gd instanceof SmartDrawing)) continue;
                        gd.setSmartDrawingColor(gcc.getColor());
                    }
                }
            }
        }
        if (this.currentDrawing instanceof SmartDrawing) {
            GeometraProperties.setSmartColor(gcc.getColor());
        } else {
            GeometraProperties.setColor(gcc.getColor());
        }
        GeometraSubject.getInstance().update((GeometraDrawing)null, (Object)this);
        this.currentDrawings = null;
        this.currentDrawing = null;
        this.setVisible(false);
    }

    private void setupButtonPanel() {
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
    }

    public void setVisible(boolean b) {
        this.colorDialog.setVisible(b);
    }

    public Color getDrawingColor() {
        return gcc.getDrawingColor();
    }
}

