/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.datastructures.blueprint;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Robot;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.PlainDocument;
import se.sjobeck.GeometraConfiguration;
import se.sjobeck.geometra.datastructures.ClipboardSender;
import se.sjobeck.geometra.gui.main.Geometra;
import se.sjobeck.geometra.gui.panels.GeometraButton;
import se.sjobeck.geometra.gui.panels.JTreePDFPane;
import se.sjobeck.geometra.gui.panels.datastructures.ToolBarDocument;
import se.sjobeck.images.IconLoader;

public final class ToolBarField
extends JPanel {
    private String labelName;
    private static final long serialVersionUID = 1L;
    private final ClipboardSender clipboardSender = new ClipboardSender();
    private final JTextField inputTextField = new JTextField(6);
    private JTextField resultTextField = new JTextField(GeometraConfiguration.getNDecimals() + 7);
    private final JLabel outputLabel = new JLabel();
    private final JCheckBox panelNameCheckBox;
    private final ImageIcon icon = IconLoader.getIcon("/se/sjobeck/geometra/gui/panels/toolbar/icons/export.png");
    private final JButton sendButton = new GeometraButton(this.icon);
    private final PlainDocument singleDoc = new ToolBarDocument();
    private JTreePDFPane treePane;
    MouseListener sendListener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getSource() == ToolBarField.this.sendButton) {
                String text = ToolBarField.this.resultTextField.getText();
                ToolBarField.this.clipboardSender.sendToSystemClipboard(text);
                try {
                    Robot robot = new Robot();
                    robot.keyPress(18);
                    robot.delay(5);
                    robot.keyPress(9);
                    robot.delay(5);
                    robot.keyRelease(9);
                    robot.delay(5);
                    robot.keyRelease(18);
                    robot.delay(5);
                    robot.keyPress(17);
                    robot.delay(5);
                    robot.keyPress(86);
                    robot.delay(5);
                    robot.keyRelease(86);
                    robot.delay(5);
                    robot.keyRelease(17);
                    robot.delay(5);
                }
                catch (AWTException ex) {
                    ex.printStackTrace();
                }
            }
        }
    };

    public void updateDecimalSettings() {
        this.resultTextField.setColumns(GeometraConfiguration.getNDecimals() + 7);
    }

    public void addInputListener(KeyListener listener) {
        this.inputTextField.addKeyListener(listener);
    }

    public ToolBarField(String name, JTreePDFPane treePane) {
        super(new GridLayout(2, 0));
        this.treePane = treePane;
        this.labelName = name;
        this.setPreferredSize(new Dimension(170, 57));
        this.panelNameCheckBox = new JCheckBox(this.labelName);
        this.panelNameCheckBox.setSelected(true);
        this.inputTextField.setDocument(this.singleDoc);
        this.resultTextField.setEditable(false);
        this.sendButton.setToolTipText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("STR_EXPORT") + " " + this.labelName);
        this.sendButton.setPreferredSize(new Dimension(24, 24));
        this.sendButton.addMouseListener(this.sendListener);
        JPanel checkBoxPanel = new JPanel(new FlowLayout(0));
        checkBoxPanel.add(this.panelNameCheckBox);
        checkBoxPanel.add(this.outputLabel);
        JPanel resultPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.weightx = 1.0;
        resultPanel.add((Component)this.inputTextField, c);
        c.gridx = 1;
        c.weightx = 1.0;
        resultPanel.add((Component)this.resultTextField, c);
        c.gridx = 2;
        c.weightx = 0.0;
        resultPanel.add((Component)this.sendButton, c);
        this.add(checkBoxPanel);
        this.add(resultPanel);
    }

    protected final JTextField getModField() {
        return this.inputTextField;
    }

    protected JTextField getResultField() {
        return this.resultTextField;
    }

    public String getResultFieldText() {
        return this.resultTextField.getText();
    }

    public boolean isSelected() {
        return this.panelNameCheckBox.isSelected();
    }

    protected void setModText(String str) {
        this.inputTextField.setText(str);
    }

    public void setOriginalText(String string) {
        this.outputLabel.setText(string);
    }

    public void setResult(String s) {
        this.resultTextField.setText(s);
    }

    public void updateResult(Double result, String resultMod) {
        if (result == null) {
            this.resultTextField.setText("");
        } else {
            String formattedResult = Geometra.standardFormat.format(result);
            this.resultTextField.setText(formattedResult);
        }
        if (resultMod == null) {
            this.inputTextField.setText("");
        } else {
            this.inputTextField.setText(resultMod);
        }
    }
}

