/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.datastructures.blueprint;

import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.icepdf.ri.common.views.painting.drawings.GeometraDrawing;
import org.icepdf.ri.common.views.painting.drawings.ScaleDrawing;
import se.sjobeck.GeometraConfiguration;
import se.sjobeck.geometra.datastructures.blueprint.observer.BlueprintSubject;
import se.sjobeck.geometra.datastructures.blueprint.observer.Observer;
import se.sjobeck.geometra.datastructures.drawings.DotDrawingContainer;
import se.sjobeck.geometra.datastructures.drawings.ZoomDrawing;

public class SoundManager
implements Observer {
    private final Clip soundClip;
    private boolean loadFailure = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SoundManager(URL soundUrl) {
        Clip tempClip = null;
        AudioInputStream inputStream = null;
        boolean exceptionHappened = false;
        try {
            inputStream = AudioSystem.getAudioInputStream(soundUrl);
            DataLine.Info info = new DataLine.Info(Clip.class, inputStream.getFormat());
            tempClip = (Clip)AudioSystem.getLine(info);
            tempClip.open(inputStream);
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
            tempClip = null;
            exceptionHappened = true;
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
            tempClip = null;
            exceptionHappened = true;
        }
        catch (IOException e) {
            e.printStackTrace();
            tempClip = null;
            exceptionHappened = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            tempClip = null;
            exceptionHappened = true;
        }
        finally {
            if (exceptionHappened) {
                this.loadFailure = true;
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(SoundManager.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        this.soundClip = tempClip;
    }

    public void playClip() {
        if (!this.loadFailure && GeometraConfiguration.isSoundEnabled() && this.soundClip != null) {
            if (this.soundClip.isActive()) {
                this.soundClip.stop();
            }
            this.soundClip.setFramePosition(0);
            this.soundClip.start();
        }
    }

    @Override
    public void update(BlueprintSubject.Action action, Object ob, Object source) {
        if ((action.equals((Object)BlueprintSubject.Action.ADD_POINT) || action.equals((Object)BlueprintSubject.Action.ADD)) && ob instanceof GeometraDrawing && !(ob instanceof ScaleDrawing) && !(ob instanceof DotDrawingContainer) && !(ob instanceof ZoomDrawing)) {
            this.playClip();
        }
    }
}

