/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.datastructures.blueprint;

import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.icepdf.core.SecurityCallback;
import org.icepdf.core.pobjects.Destination;
import org.icepdf.core.pobjects.Document;
import org.icepdf.ri.common.views.AnnotationCallback;
import org.icepdf.ri.common.views.AnnotationComponent;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.DocumentViewModelImpl;
import org.icepdf.ri.common.views.PageViewComponent;
import org.icepdf.ri.common.views.painting.core.Blueprint;
import org.icepdf.ri.images.Images;
import se.sjobeck.geometra.datastructures.blueprint.GeometraManager;
import se.sjobeck.geometra.datastructures.blueprint.OnePagePDFView;
import se.sjobeck.geometra.datastructures.blueprint.PDFController;

public class PDFViewController
implements DocumentViewController {
    public static final float ZOOM_FACTOR_IN = 1.25f;
    public static final float ZOOM_FACTOR_OUT = 0.8f;
    public static final int CURSOR_CROSS = 1929;
    public static final int WAIT_CURSOR = 3;
    public static final float ZOOM_ROOF = 64.0f;
    private final PropertyChangeSupport changes = new PropertyChangeSupport(this);
    private final Blueprint blueprint;
    private PageViewComponent comp;
    private OnePagePDFView pageView;
    private final PDFController parentController;
    private Document pdfDocument;
    private DocumentViewModelImpl viewModelImpl;
    private final JScrollPane viewScrollPane;
    protected int viewportFitMode;
    protected int oldViewportFitMode;
    private int pageIndex;
    private final GeometraManager geometraManager = GeometraManager.getInstance();
    private Cursor openHand;
    private Cursor handClosed;
    private Cursor zoomIn;
    private Cursor zoomOut;

    public PDFViewController(PDFController parentController) {
        this.parentController = parentController;
        this.blueprint = parentController.getBlueprint();
        this.viewScrollPane = new JScrollPane();
        this.initCustomCursors();
    }

    private void initCustomCursors() {
        String imageName = "hand_open.gif";
        this.openHand = this.loadCustomCursor(imageName);
        imageName = "hand_closed.gif";
        this.handClosed = this.loadCustomCursor(imageName);
        imageName = "zoom_in.gif";
        this.zoomIn = this.loadCustomCursor(imageName);
        imageName = "zoom_out.gif";
        this.zoomOut = this.loadCustomCursor(imageName);
    }

    private Cursor loadCustomCursor(String customCursor) {
        Cursor c;
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension bestsize = tk.getBestCursorSize(24, 24);
        if (bestsize.width != 0) {
            Point cursorHotSpot = new Point(12, 12);
            ImageIcon cursorImage = new ImageIcon(Images.get((String)customCursor));
            c = tk.createCustomCursor(cursorImage.getImage(), cursorHotSpot, customCursor);
        } else {
            c = Cursor.getDefaultCursor();
            System.err.println("System does not support custom cursors");
        }
        return c;
    }

    public Cursor getViewCursor(int currsorType) {
        if (currsorType == 8) {
            return Cursor.getPredefinedCursor(0);
        }
        if (currsorType == 1929) {
            return Cursor.getPredefinedCursor(1);
        }
        if (currsorType == 6) {
            return Cursor.getPredefinedCursor(3);
        }
        if (currsorType == 7) {
            return Cursor.getPredefinedCursor(2);
        }
        if (currsorType == 1) {
            return this.openHand;
        }
        if (currsorType == 2) {
            return this.handClosed;
        }
        if (currsorType == 3) {
            return this.zoomIn;
        }
        if (currsorType == 4) {
            return this.zoomOut;
        }
        if (currsorType == 9) {
            return Cursor.getPredefinedCursor(12);
        }
        return Cursor.getPredefinedCursor(0);
    }

    public synchronized boolean setCurrentPageIndex(int pageIndex) {
        if (this.viewModelImpl == null) {
            return false;
        }
        if (pageIndex < 0) {
            pageIndex = 0;
        } else if (pageIndex > this.pdfDocument.getNumberOfPages() - 1) {
            pageIndex = this.pdfDocument.getNumberOfPages() - 1;
        }
        int oldPageIndex = this.viewModelImpl.getViewCurrentPageIndex();
        boolean changed = this.viewModelImpl.setViewCurrentPageIndex(pageIndex);
        if (this.pageView != null) {
            this.pageView.updateDocumentView();
        }
        if (changed) {
            this.comp = this.pageView.getComp();
        }
        this.firePropertyChange("documentCurrentPage", oldPageIndex, pageIndex);
        this.viewScrollPane.revalidate();
        return changed;
    }

    public synchronized void closeDocument() {
        if (this.pageView != null) {
            this.viewScrollPane.remove((Component)((Object)this.pageView));
            this.pageView.dispose();
            this.pageView = null;
        }
        if (this.viewModelImpl != null) {
            this.viewModelImpl.dispose();
            this.viewModelImpl = null;
        }
        if (this.pdfDocument != null) {
            this.pdfDocument.dispose();
            this.pdfDocument = null;
        }
    }

    public AnnotationCallback getAnnotationCallback() {
        return null;
    }

    public Blueprint getBlueprint() {
        return this.blueprint;
    }

    private Point getCenteringPoint() {
        Point centeringPoint = null;
        if (this.viewScrollPane != null) {
            int x = this.viewScrollPane.getViewport().getViewPosition().x + this.viewScrollPane.getViewport().getWidth() / 2;
            int y = this.viewScrollPane.getViewport().getViewPosition().y + this.viewScrollPane.getViewport().getHeight() / 2;
            centeringPoint = new Point(x, y);
        }
        return centeringPoint;
    }

    PageViewComponent getComp() {
        return this.comp;
    }

    public int getCurrentPageDisplayValue() {
        return 0;
    }

    public int getCurrentPageIndex() {
        return this.pageIndex;
    }

    public Document getDocument() {
        return this.pdfDocument;
    }

    public int getFitMode() {
        return 0;
    }

    public Adjustable getHorizontalScrollBar() {
        return this.viewScrollPane.getHorizontalScrollBar();
    }

    public Controller getParentController() {
        return this.parentController;
    }

    public float getRotation() {
        return this.viewModelImpl.getViewRotation();
    }

    public int getToolMode() {
        return 0;
    }

    public Adjustable getVerticalScrollBar() {
        return this.viewScrollPane.getVerticalScrollBar();
    }

    public Container getViewContainer() {
        return this.viewScrollPane;
    }

    public int getViewMode() {
        return 0;
    }

    public float getZoom() {
        if (this.viewModelImpl != null) {
            return this.viewModelImpl.getViewZoom();
        }
        return 0.0f;
    }

    public float[] getZoomLevels() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isToolModeSelected(int arg0) {
        return false;
    }

    public void requestViewFocusInWindow() {
    }

    public void setAnnotationCallback(AnnotationCallback arg0) {
    }

    public int setCurrentPageNext() {
        return 0;
    }

    public int setCurrentPagePrevious() {
        return 0;
    }

    public void setDestinationTarget(Destination arg0) {
    }

    public synchronized void setDocument(Document pdfDocument) {
        this.pdfDocument = pdfDocument;
        this.viewModelImpl = new DocumentViewModelImpl(pdfDocument, this.viewScrollPane, this.blueprint);
        this.pageView = new OnePagePDFView(this, this.viewScrollPane, this.viewModelImpl);
        this.viewScrollPane.setViewportView((Component)((Object)this.pageView));
        this.comp = this.pageView.getComp();
    }

    public void setDocumentViewType(int arg0, int arg1) {
    }

    public synchronized boolean setFitMode(int fitMode) {
        if (this.viewModelImpl == null) {
            return false;
        }
        this.viewportFitMode = fitMode;
        float newZoom = 1.0f;
        if (this.pdfDocument != null) {
            newZoom = this.viewModelImpl.getViewZoom();
            if (this.viewportFitMode == 2) {
                newZoom = 1.0f;
            } else if (this.viewportFitMode == 3) {
                int cw = this.viewScrollPane == null ? 0 : (int)this.viewScrollPane.getViewport().getViewRect().getWidth() - 5;
                int ch = this.viewScrollPane == null ? 0 : (int)this.viewScrollPane.getViewport().getViewRect().getHeight() - 5;
                Dimension d = this.pageView.getDocumentSize();
                double pw = d.getWidth();
                double ph = d.getHeight();
                float currentZoom = this.viewModelImpl.getViewZoom();
                pw = Math.abs(pw / (double)currentZoom);
                ph = Math.abs(ph / (double)currentZoom);
                if (cw > 0 && ch > 0 && pw > 0.0 && ph > 0.0) {
                    double zw = (double)cw / (pw * 1.02);
                    double zh = (double)ch / (ph * 1.02);
                    newZoom = (float)Math.min(zw, zh);
                } else {
                    newZoom = 1.0f;
                }
            } else if (this.viewportFitMode == 4 && this.pageView != null && this.viewScrollPane != null) {
                int viewportWidth = this.viewScrollPane.getViewport().getViewRect().width;
                float pageViewWidth = this.pageView.getDocumentSize().width;
                float currentZoom = this.viewModelImpl.getViewZoom();
                pageViewWidth = Math.abs(pageViewWidth / currentZoom);
                newZoom = viewportWidth > 0 ? (float)viewportWidth / (pageViewWidth * 1.008f) : 1.0f;
            }
            this.geometraManager.setBlueprintScale(this.parentController.getBlueprint(), newZoom);
            this.setZoom(newZoom, null, true);
        }
        return true;
    }

    public float setRotateLeft() {
        if (this.getRotation() == -360.0f) {
            this.setRotation(0.0f);
        }
        float rotation = this.viewModelImpl.getViewRotation() - 90.0f;
        this.viewModelImpl.setViewRotation(rotation);
        this.viewScrollPane.revalidate();
        return rotation;
    }

    public float setRotateRight() {
        if (this.getRotation() == 360.0f) {
            this.setRotation(0.0f);
        }
        float rotation = this.viewModelImpl.getViewRotation() + 90.0f;
        this.viewModelImpl.setViewRotation(rotation);
        this.viewScrollPane.revalidate();
        return rotation;
    }

    public boolean setRotation(float rotation) {
        if (this.viewModelImpl != null) {
            return this.viewModelImpl.setViewRotation(rotation);
        }
        return false;
    }

    public boolean setToolMode(int arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setViewCursor(int type) {
        Cursor cursor = this.getViewCursor(type);
        if (this.viewScrollPane != null && this.viewScrollPane.getViewport() != null) {
            this.viewScrollPane.getViewport().setCursor(cursor);
        }
    }

    public void setViewKeyListener(KeyListener arg0) {
    }

    public void setViewType(int arg0) {
    }

    public boolean setZoom(float zoom) {
        return this.setZoom(zoom, null, false);
    }

    public synchronized boolean setZoom(float userZoom, Point centeringPoint, boolean becauseOfValidFitMode) {
        float zoom = userZoom > 64.0f ? 64.0f : userZoom;
        if (this.pageView == null) {
            return false;
        }
        if (centeringPoint == null) {
            centeringPoint = this.getCenteringPoint();
        }
        float previousZoom = this.getZoom();
        boolean changed = this.viewModelImpl.setViewZoom(zoom);
        this.viewScrollPane.revalidate();
        if (changed) {
            float zoomFactor = zoom / previousZoom;
            if (centeringPoint != null) {
                centeringPoint.setLocation((float)centeringPoint.x * zoomFactor, (float)centeringPoint.y * zoomFactor);
            }
        }
        Point centeringPoint3 = centeringPoint;
        this.zoomCenter(centeringPoint3);
        return changed;
    }

    public boolean setZoomIn() {
        return this.setZoomIn(null);
    }

    public boolean setZoomIn(Point point) {
        float zoom = this.getZoom() * 1.25f;
        return this.setZoom(zoom, point, false);
    }

    public void setZoomLevels(float[] arg0) {
    }

    public boolean setZoomOut() {
        return this.setZoomOut(null);
    }

    public boolean setZoomOut(Point point) {
        float zoom = this.getZoom() * 0.8f;
        return this.setZoom(zoom, point, false);
    }

    private synchronized void zoomCenter(Point centerPoint) {
        if (centerPoint == null) {
            centerPoint = this.getCenteringPoint();
        }
        if (centerPoint == null || this.viewScrollPane == null) {
            return;
        }
        int scrollpaneWidth = this.viewScrollPane.getViewport().getWidth();
        int scrollpaneHeight = this.viewScrollPane.getViewport().getHeight();
        int scrollPaneX = this.viewScrollPane.getViewport().getViewPosition().x;
        int scrollPaneY = this.viewScrollPane.getViewport().getViewPosition().y;
        Dimension pageSize = this.pageView.getPreferredSize();
        int pageWidth = pageSize.width;
        int pageHeight = pageSize.height;
        centerPoint.setLocation(centerPoint.x - scrollpaneWidth / 2, centerPoint.y - scrollpaneHeight / 2);
        if (pageWidth < scrollpaneWidth || pageHeight < scrollpaneHeight) {
            if (centerPoint.x >= pageWidth - scrollpaneWidth || centerPoint.x < 0) {
                centerPoint.x = scrollPaneX;
            }
            if (centerPoint.y >= pageHeight - scrollpaneHeight || centerPoint.y < 0) {
                centerPoint.y = scrollPaneY;
            }
        } else {
            if (centerPoint.x + scrollpaneWidth > pageWidth) {
                centerPoint.x = pageWidth - scrollpaneWidth;
            } else if (centerPoint.x < 0) {
                centerPoint.x = 0;
            }
            if (centerPoint.y + scrollpaneHeight > pageHeight) {
                centerPoint.y = pageHeight - scrollpaneHeight;
            } else if (centerPoint.y < 0) {
                centerPoint.y = 0;
            }
        }
        this.viewScrollPane.getViewport().setViewPosition(centerPoint);
        this.viewScrollPane.getViewport().setViewPosition(centerPoint);
    }

    public void firePropertyChange(String event, int oldValue, int newValue) {
        this.changes.firePropertyChange(event, oldValue, newValue);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changes.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changes.removePropertyChangeListener(l);
    }

    public synchronized Dimension getSize() {
        return this.pageView.getSize();
    }

    public void dispose() {
    }

    public void deleteCurrentAnnotation() {
        System.out.println("action: deleteCurrentAnnotation");
    }

    public void undo() {
        System.out.println("action: undo");
    }

    public void redo() {
        System.out.println("action: redo");
    }

    public DocumentViewModel getDocumentViewModel() {
        System.out.println("action: getDocumentViewModel");
        return this.viewModelImpl;
    }

    public void clearSelectedText() {
        System.out.println("action: CLEAR_SELECTED_TEXT");
    }

    public void clearHighlightedText() {
        System.out.println("action: clearHighlightedText");
    }

    public void clearSelectedAnnotations() {
        System.out.println("action: clearSelectedAnnotations");
    }

    public void selectAllText() {
        System.out.println("action: selectAllText");
    }

    public String getSelectedText() {
        System.out.println("action: getSelectedText");
        return "";
    }

    public void firePropertyChange(String arg0, Object arg1, Object arg2) {
        System.out.println("action: firePropertyChange ");
        this.changes.firePropertyChange(arg0, arg1, arg2);
    }

    public void setSecurityCallback(SecurityCallback securityCallback) {
    }

    public SecurityCallback getSecurityCallback() {
        return null;
    }

    public boolean setZoomCentered(float zoom, Point centeringPoint, boolean becauseOfValidFitMode) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean setZoomToViewPort(float zoom, Point viewPortPosition, int pageIndex, boolean becauseOfValidFitMode) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public JViewport getViewPort() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void deleteAnnotation(AnnotationComponent annotationComponent) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void assignSelectedAnnotation(AnnotationComponent annotationComponent) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

