/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.datastructures.blueprint;

import java.awt.geom.Point2D;
import org.icepdf.ri.common.views.painting.drawings.GeometraDrawing;
import se.sjobeck.geometra.datastructures.blueprint.Command;
import se.sjobeck.geometra.datastructures.blueprint.observer.BlueprintSubject;
import se.sjobeck.geometra.datastructures.blueprint.observer.GeometraSubject;
import se.sjobeck.geometra.datastructures.drawings.HoleDrawing;
import se.sjobeck.geometra.datastructures.drawings.SquareDrawing;

public class GeometraPaintCommand
implements Command {
    private final BlueprintSubject.Action action;
    private final GeometraDrawing gd;
    private final GeometraSubject geoSubject = GeometraSubject.getInstance();
    private Point2D lastPoint = null;
    private boolean shouldBeClosed;

    public GeometraPaintCommand(GeometraDrawing gd, BlueprintSubject.Action action) {
        this.action = action;
        this.gd = gd;
        this.shouldBeClosed = gd.isClosed();
    }

    protected boolean getClosed() {
        return this.shouldBeClosed;
    }

    protected void setClosed(boolean shouldBeClosed) {
        this.shouldBeClosed = shouldBeClosed;
    }

    protected GeometraDrawing getDrawing() {
        return this.gd;
    }

    protected BlueprintSubject.Action getAction() {
        return this.action;
    }

    @Override
    public void redo() {
        if (this.action.equals((Object)BlueprintSubject.Action.ADD)) {
            if (this.gd instanceof HoleDrawing) {
                HoleDrawing hd = (HoleDrawing)this.gd;
                SquareDrawing sd = hd.getOwner();
                sd.addChild(hd);
                this.geoSubject.update(sd, (Object)this);
            } else {
                this.geoSubject.add(this.gd, this);
            }
        } else if (this.action.equals((Object)BlueprintSubject.Action.ADD_POINT)) {
            this.gd.setClosed(false);
            if (this.gd instanceof SquareDrawing) {
                SquareDrawing sd = (SquareDrawing)this.gd;
                sd.setUnfinilized();
            }
            this.gd.addPoint(this.gd.getParent().blueprintToComponent(this.lastPoint));
            this.geoSubject.addPoint(this.gd, (Object)this);
            this.gd.setClosed(this.shouldBeClosed);
        }
    }

    @Override
    public void undo() {
        if (this.action.equals((Object)BlueprintSubject.Action.ADD)) {
            this.geoSubject.remove(this.gd, this);
        } else if (this.action.equals((Object)BlueprintSubject.Action.ADD_POINT)) {
            this.lastPoint = this.gd.getPoints().get(this.gd.size() - 1);
            this.gd.removeLastPoint();
            this.geoSubject.update(this.gd, (Object)this);
        } else if (this.action.equals((Object)BlueprintSubject.Action.REMOVE)) {
            this.geoSubject.add(this.gd, this);
            this.geoSubject.update(this.gd, (Object)this);
        }
    }
}

