/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.util;

import java.awt.Graphics;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.PDimension;
import org.w3c.dom.DOMImplementation;

public class SVG {
    private static final Logger logger = Logger.getLogger(SVG.class.toString());

    public static void createSVG(Document pdfDocument, int pageNumber, Writer out) {
        try {
            if (pdfDocument != null && pageNumber >= 0 && pageNumber < pdfDocument.getNumberOfPages()) {
                DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
                org.w3c.dom.Document document = domImpl.createDocument(null, "svg", null);
                SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
                float userRotation = 0.0f;
                float userZoom = 1.0f;
                PDimension pdfDimension = pdfDocument.getPageDimension(pageNumber, userRotation, userZoom);
                svgGenerator.setSVGCanvasSize(pdfDimension.toDimension());
                pdfDocument.paintPage(pageNumber, (Graphics)svgGenerator, 2, 2, userRotation, userZoom);
                boolean useCSS = true;
                svgGenerator.stream(out, useCSS);
            }
        }
        catch (SVGGraphics2DIOException e) {
            logger.log(Level.SEVERE, "Error creating svg document.", e);
        }
    }
}

