/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views.annotations;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.MarkupAnnotation;
import org.icepdf.core.pobjects.annotations.PopupAnnotation;
import org.icepdf.core.pobjects.annotations.TextAnnotation;
import org.icepdf.ri.common.tools.TextAnnotationHandler;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.AnnotationCallback;
import org.icepdf.ri.common.views.AnnotationComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.ResizableBorder;
import org.icepdf.ri.common.views.annotations.AbstractAnnotationComponent;
import org.icepdf.ri.common.views.annotations.AnnotationComponentFactory;
import org.icepdf.ri.common.views.annotations.MarkupAnnotationComponent;

public class PopupAnnotationComponent
extends AbstractAnnotationComponent
implements TreeSelectionListener,
ActionListener,
DocumentListener {
    public static Color backgroundColor = new Color(252, 253, 227);
    public static Color borderColor = new Color(153, 153, 153);
    protected PopupAnnotation popupAnnotation;
    private GridBagConstraints constraints;
    protected JPanel commentPanel;
    protected JTextArea textArea;
    protected JLabel creationLabel;
    protected JButton minimizeButton;
    protected JTree commentTree;
    protected JScrollPane commentTreeScrollPane;
    protected MarkupAnnotation selectedMarkupAnnotation;
    protected JMenuItem replyMenuItem;
    protected JMenuItem deleteMenuItem;
    protected JMenuItem statusNoneMenuItem;
    protected JMenuItem statusAcceptedItem;
    protected JMenuItem statusCancelledMenuItem;
    protected JMenuItem statusCompletedMenuItem;
    protected JMenuItem statusRejectedMenuItem;
    protected JMenuItem openAllMenuItem;
    protected JMenuItem minimizeAllMenuItem;
    protected JPopupMenu contextMenu;

    public PopupAnnotationComponent(Annotation annotation, DocumentViewController documentViewController, AbstractPageViewComponent pageViewComponent, DocumentViewModel documentViewModel) {
        super(annotation, documentViewController, pageViewComponent, documentViewModel);
        this.isEditable = true;
        this.isRollover = false;
        this.isMovable = true;
        this.isResizable = true;
        this.isShowInvisibleBorder = false;
        if (annotation instanceof PopupAnnotation) {
            this.popupAnnotation = (PopupAnnotation)annotation;
            this.popupAnnotation.init();
        }
        boolean isVisible = this.popupAnnotation.isOpen();
        this.setVisible(isVisible);
        this.buildGUI();
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        if (!this.annotation.getFlagLocked() && !this.annotation.getFlagReadOnly()) {
            ResizableBorder border = (ResizableBorder)this.getBorder();
            this.setCursor(Cursor.getPredefinedCursor(border.getCursor(me)));
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.isMousePressed = true;
        if (isInteractiveAnnotationsEnabled && !this.annotation.getFlagReadOnly()) {
            this.initiateMouseMoved(e);
        }
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        super.mouseEntered(e);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void buildGUI() {
        List<Annotation> annotations = this.pageViewComponent.getPage().getAnnotations();
        MarkupAnnotation parentAnnotation = this.popupAnnotation.getParent();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Root");
        boolean isIRT = this.buildCommentTree(parentAnnotation, annotations, root);
        this.commentTree = new JTree(root);
        this.commentTree.setRootVisible(true);
        this.commentTree.setExpandsSelectedPaths(true);
        this.commentTree.setShowsRootHandles(true);
        this.commentTree.setScrollsOnExpand(true);
        this.commentTree.setRootVisible(false);
        this.commentTree.getSelectionModel().setSelectionMode(1);
        this.commentTree.addTreeSelectionListener(this);
        this.refreshTree(this.commentTree);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setOpenIcon(null);
        renderer.setClosedIcon(null);
        renderer.setLeafIcon(null);
        this.commentTree.setCellRenderer(renderer);
        this.commentTree.addMouseListener(new PopupTreeListener());
        this.commentTreeScrollPane = new JScrollPane(this.commentTree);
        this.commentTree.setSelectionRow(0);
        this.selectedMarkupAnnotation = parentAnnotation;
        this.minimizeButton = new JButton("  _  ");
        this.minimizeButton.addActionListener(this);
        this.minimizeButton.setBackground(backgroundColor);
        this.minimizeButton.setOpaque(true);
        this.minimizeButton.setContentAreaFilled(false);
        this.minimizeButton.setBorder(BorderFactory.createLineBorder(borderColor));
        this.minimizeButton.setBorderPainted(true);
        this.minimizeButton.addActionListener(this);
        String contents = this.popupAnnotation.getParent() != null ? this.popupAnnotation.getParent().getContents() : "";
        this.textArea = new JTextArea(contents != null ? contents : "");
        this.textArea.setFont(new JLabel().getFont());
        this.textArea.setBorder(BorderFactory.createLineBorder(borderColor));
        this.textArea.setLineWrap(true);
        this.textArea.getDocument().addDocumentListener(this);
        this.creationLabel = new JLabel();
        if (this.selectedMarkupAnnotation != null && this.selectedMarkupAnnotation.getCreationDate() != null) {
            this.creationLabel.setText(this.selectedMarkupAnnotation.getCreationDate().toString());
        }
        GridBagLayout layout = new GridBagLayout();
        this.commentPanel = new JPanel(layout);
        this.commentPanel.setBackground(backgroundColor);
        this.commentPanel.setBorder(BorderFactory.createLineBorder(borderColor));
        this.setLayout(new BorderLayout());
        this.add(this.commentPanel);
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 0;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.anchor = 11;
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(1, 5, 1, 5);
        this.constraints.fill = 13;
        this.constraints.weightx = 0.0;
        String title = this.selectedMarkupAnnotation != null ? (this.selectedMarkupAnnotation.getTitleText() != null ? this.selectedMarkupAnnotation.getTitleText() : "") : "";
        this.addGB(this.commentPanel, new JLabel(title), 0, 0, 1, 1);
        this.constraints.fill = 0;
        this.constraints.weightx = 0.0;
        this.addGB(this.commentPanel, this.minimizeButton, 2, 0, 1, 1);
        this.constraints.fill = 1;
        this.constraints.insets = new Insets(1, 5, 1, 5);
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.6;
        this.commentTreeScrollPane.setVisible(isIRT);
        this.addGB(this.commentPanel, this.commentTreeScrollPane, 0, 1, 3, 1);
        this.constraints.insets = new Insets(1, 5, 1, 5);
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.fill = 13;
        this.addGB(this.commentPanel, this.creationLabel, 0, 2, 1, 1);
        this.constraints.fill = 1;
        this.constraints.insets = new Insets(1, 5, 5, 5);
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.4;
        this.addGB(this.commentPanel, this.textArea, 0, 3, 3, 1);
        this.buildContextMenu();
    }

    private void refreshTree(JTree tree) {
        ((DefaultTreeModel)tree.getModel()).reload();
        for (int i = 0; i < tree.getRowCount(); ++i) {
            tree.expandRow(i);
        }
    }

    public void buildContextMenu() {
        ResourceBundle messages = this.documentViewController.getParentController().getMessageBundle();
        this.replyMenuItem = new JMenuItem(messages.getString("viewer.annotation.popup.reply.label"));
        this.deleteMenuItem = new JMenuItem(messages.getString("viewer.annotation.popup.delete.label"));
        this.statusNoneMenuItem = new JMenuItem(messages.getString("viewer.annotation.popup.status.none.label"));
        this.statusAcceptedItem = new JMenuItem(messages.getString("viewer.annotation.popup.status.accepted.label"));
        this.statusCancelledMenuItem = new JMenuItem(messages.getString("viewer.annotation.popup.status.cancelled.label"));
        this.statusCompletedMenuItem = new JMenuItem(messages.getString("viewer.annotation.popup.status.completed.label"));
        this.statusRejectedMenuItem = new JMenuItem(messages.getString("viewer.annotation.popup.status.rejected.label"));
        this.openAllMenuItem = new JMenuItem(messages.getString("viewer.annotation.popup.openAll.label"));
        this.minimizeAllMenuItem = new JMenuItem(messages.getString("viewer.annotation.popup.minimizeAll.label"));
        this.contextMenu = new JPopupMenu();
        this.replyMenuItem.addActionListener(this);
        this.contextMenu.add(this.replyMenuItem);
        this.deleteMenuItem.addActionListener(this);
        this.contextMenu.add(this.deleteMenuItem);
        this.contextMenu.addSeparator();
        JMenu submenu = new JMenu(messages.getString("viewer.annotation.popup.status.label"));
        this.statusNoneMenuItem.addActionListener(this);
        submenu.add(this.statusNoneMenuItem);
        this.statusAcceptedItem.addActionListener(this);
        submenu.add(this.statusAcceptedItem);
        this.statusCancelledMenuItem.addActionListener(this);
        submenu.add(this.statusCancelledMenuItem);
        this.statusCompletedMenuItem.addActionListener(this);
        submenu.add(this.statusCompletedMenuItem);
        this.statusRejectedMenuItem.addActionListener(this);
        submenu.add(this.statusRejectedMenuItem);
        this.contextMenu.add(submenu);
        this.contextMenu.addSeparator();
        this.openAllMenuItem.addActionListener(this);
        this.contextMenu.add(this.openAllMenuItem);
        this.minimizeAllMenuItem.addActionListener(this);
        this.contextMenu.add(this.minimizeAllMenuItem);
        PopupListener popupListener = new PopupListener();
        this.textArea.addMouseListener(popupListener);
        this.commentPanel.addMouseListener(popupListener);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == null) {
            return;
        }
        if (source == this.minimizeButton) {
            this.setVisible(false);
            this.popupAnnotation.setOpen(false);
        } else if (source == this.replyMenuItem) {
            Object[] argument = new Object[]{this.selectedMarkupAnnotation.getTitleText()};
            MessageFormat formatter = new MessageFormat(this.messageBundle.getString("viewer.annotation.popup.replyTo.label"));
            String annotationTitle = formatter.format(argument);
            this.createNewTextAnnotation(annotationTitle, "", "Review", "None");
        } else if (source == this.deleteMenuItem) {
            AnnotationComponent annotationComponent = this.findAnnotationComponent(this.selectedMarkupAnnotation);
            this.documentViewController.deleteAnnotation(annotationComponent);
            annotationComponent = this.findAnnotationComponent(this.selectedMarkupAnnotation.getPopupAnnotation());
            this.documentViewController.deleteAnnotation(annotationComponent);
            this.removeMarkupInReplyTo(this.selectedMarkupAnnotation.getPObjectReference());
            List<Annotation> annotations = this.pageViewComponent.getPage().getAnnotations();
            MarkupAnnotation parentAnnotation = this.popupAnnotation.getParent();
            DefaultMutableTreeNode root = new DefaultMutableTreeNode("Root");
            boolean isIRT = this.buildCommentTree(parentAnnotation, annotations, root);
            this.commentTree.removeTreeSelectionListener(this);
            ((DefaultTreeModel)this.commentTree.getModel()).setRoot(root);
            this.commentTree.addTreeSelectionListener(this);
            this.refreshTree(this.commentTree);
            if (!isIRT) {
                this.commentTreeScrollPane.setVisible(false);
            }
            this.commentPanel.revalidate();
        } else if (source == this.statusNoneMenuItem) {
            Object[] argument = new Object[]{this.selectedMarkupAnnotation.getTitleText()};
            MessageFormat formatter = new MessageFormat(this.messageBundle.getString("viewer.annotation.popup.status.none.title"));
            String title = formatter.format(argument);
            argument = new Object[]{this.selectedMarkupAnnotation.getTitleText()};
            formatter = new MessageFormat(this.messageBundle.getString("viewer.annotation.popup.status.none.msg"));
            String content = formatter.format(argument);
            this.createNewTextAnnotation(title, content, "Review", "None");
        } else if (source == this.statusAcceptedItem) {
            Object[] argument = new Object[]{this.selectedMarkupAnnotation.getTitleText()};
            MessageFormat formatter = new MessageFormat(this.messageBundle.getString("viewer.annotation.popup.status.accepted.title"));
            String title = formatter.format(argument);
            argument = new Object[]{this.selectedMarkupAnnotation.getTitleText()};
            formatter = new MessageFormat(this.messageBundle.getString("viewer.annotation.popup.status.accepted.msg"));
            String content = formatter.format(argument);
            this.createNewTextAnnotation(title, content, "Review", "None");
        } else if (source == this.statusCancelledMenuItem) {
            Object[] argument = new Object[]{this.selectedMarkupAnnotation.getTitleText()};
            MessageFormat formatter = new MessageFormat(this.messageBundle.getString("viewer.annotation.popup.status.cancelled.title"));
            String title = formatter.format(argument);
            argument = new Object[]{this.selectedMarkupAnnotation.getTitleText()};
            formatter = new MessageFormat(this.messageBundle.getString("viewer.annotation.popup.status.cancelled.msg"));
            String content = formatter.format(argument);
            this.createNewTextAnnotation(title, content, "Review", "None");
        } else if (source == this.statusCompletedMenuItem) {
            Object[] argument = new Object[]{this.selectedMarkupAnnotation.getTitleText()};
            MessageFormat formatter = new MessageFormat(this.messageBundle.getString("viewer.annotation.popup.status.completed.title"));
            String title = formatter.format(argument);
            argument = new Object[]{this.selectedMarkupAnnotation.getTitleText()};
            formatter = new MessageFormat(this.messageBundle.getString("viewer.annotation.popup.status.completed.msg"));
            String content = formatter.format(argument);
            this.createNewTextAnnotation(title, content, "Review", "None");
        } else if (source == this.statusRejectedMenuItem) {
            Object[] argument = new Object[]{this.selectedMarkupAnnotation.getTitleText()};
            MessageFormat formatter = new MessageFormat(this.messageBundle.getString("viewer.annotation.popup.status.rejected.title"));
            String title = formatter.format(argument);
            argument = new Object[]{this.selectedMarkupAnnotation.getTitleText()};
            formatter = new MessageFormat(this.messageBundle.getString("viewer.annotation.popup.status.rejected.msg"));
            String content = formatter.format(argument);
            this.createNewTextAnnotation(title, content, "Review", "None");
        } else if (source == this.openAllMenuItem) {
            this.showHidePopupAnnotations(true);
        } else if (source == this.minimizeAllMenuItem) {
            this.showHidePopupAnnotations(false);
        }
    }

    private void showHidePopupAnnotations(boolean visible) {
        ArrayList<AnnotationComponent> annotationComponents = this.pageViewComponent.getAnnotationComponents();
        for (AnnotationComponent annotationComponent : annotationComponents) {
            PopupAnnotation popupAnnotation;
            PopupAnnotationComponent popupAnnotationComponent;
            if (!(annotationComponent instanceof PopupAnnotationComponent) || (popupAnnotationComponent = (PopupAnnotationComponent)annotationComponent).getAnnotation() == null || (popupAnnotation = (PopupAnnotation)popupAnnotationComponent.getAnnotation()).getParent() == null || popupAnnotation.getParent().getInReplyToAnnotation() != null) continue;
            popupAnnotationComponent.setVisible(visible);
        }
    }

    private void createNewTextAnnotation(String title, String content, String stateModel, String state) {
        TextAnnotation markupAnnotation = TextAnnotationHandler.createTextAnnotation(this.documentViewModel.getDocument().getPageTree().getLibrary(), this.selectedMarkupAnnotation.getUserSpaceRectangle().getBounds(), this.getPageTransform());
        markupAnnotation.setTitleText(title);
        markupAnnotation.setContents(content);
        markupAnnotation.setState(state);
        markupAnnotation.setStateModel(stateModel);
        markupAnnotation.setInReplyToAnnotation(this.selectedMarkupAnnotation);
        this.addAnnotationComponent(markupAnnotation);
        PopupAnnotation popupAnnotation = TextAnnotationHandler.createPopupAnnotation(this.documentViewModel.getDocument().getPageTree().getLibrary(), this.popupAnnotation.getUserSpaceRectangle().getBounds(), markupAnnotation, this.getPageTransform());
        popupAnnotation.setOpen(false);
        this.addAnnotationComponent(popupAnnotation);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.commentTree.getLastSelectedPathComponent();
        DefaultMutableTreeNode replyToNode = new DefaultMutableTreeNode(markupAnnotation);
        if (node == null) {
            node = ((DefaultMutableTreeNode)this.commentTree.getModel().getRoot()).getFirstLeaf();
        }
        node.insert(replyToNode, node.getChildCount());
        this.commentTree.expandRow(replyToNode.getDepth() - 1);
        this.selectedMarkupAnnotation = markupAnnotation;
        this.refreshTree(this.commentTree);
        this.commentTreeScrollPane.setVisible(true);
        this.commentPanel.revalidate();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateContent(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateContent(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateContent(e);
    }

    private void updateContent(DocumentEvent e) {
        Document document = e.getDocument();
        try {
            if (document.getLength() > 0) {
                this.selectedMarkupAnnotation.setContents(document.getText(0, document.getLength()));
            }
        }
        catch (BadLocationException ex) {
            logger.log(Level.FINE, "Error updating markup annotation content", ex);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.commentTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Object userObject = node.getUserObject();
        if (userObject instanceof MarkupAnnotation) {
            this.selectedMarkupAnnotation = (MarkupAnnotation)userObject;
            if (this.textArea != null) {
                this.textArea.getDocument().removeDocumentListener(this);
                this.textArea.setText(this.selectedMarkupAnnotation.getContents());
                this.textArea.getDocument().addDocumentListener(this);
            }
            if (this.creationLabel != null) {
                this.creationLabel.setText(this.selectedMarkupAnnotation.getCreationDate().toString());
            }
        }
    }

    private void addGB(JPanel panel, Component component, int x, int y, int rowSpan, int colSpan) {
        this.constraints.gridx = x;
        this.constraints.gridy = y;
        this.constraints.gridwidth = rowSpan;
        this.constraints.gridheight = colSpan;
        panel.add(component, this.constraints);
    }

    private boolean buildCommentTree(MarkupAnnotation parentAnnotation, List<Annotation> annotations, DefaultMutableTreeNode root) {
        boolean foundIRT = this.checkForIRT(parentAnnotation, annotations);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(parentAnnotation);
        root.add(node);
        if (!foundIRT) {
            return false;
        }
        this.buildRecursiveCommentTree(node, annotations);
        return true;
    }

    private void buildRecursiveCommentTree(DefaultMutableTreeNode root, List<Annotation> annotations) {
        MarkupAnnotation currentMarkup = (MarkupAnnotation)root.getUserObject();
        Reference reference = currentMarkup.getPObjectReference();
        for (Annotation annotation : annotations) {
            MarkupAnnotation markupAnnotation;
            MarkupAnnotation inReplyToAnnotation;
            if (!(annotation instanceof MarkupAnnotation) || (inReplyToAnnotation = (markupAnnotation = (MarkupAnnotation)annotation).getInReplyToAnnotation()) == null || !inReplyToAnnotation.getPObjectReference().equals(reference)) continue;
            root.add(new DefaultMutableTreeNode(markupAnnotation));
        }
        int childCount = root.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            this.buildRecursiveCommentTree((DefaultMutableTreeNode)root.getChildAt(i), annotations);
        }
    }

    private void removeMarkupInReplyTo(Reference reference) {
        if (reference != null) {
            ArrayList<AnnotationComponent> annotationComponents = this.pageViewComponent.getAnnotationComponents();
            for (int i = 0; i < annotationComponents.size(); ++i) {
                MarkupAnnotationComponent markupAnnotationComponent;
                MarkupAnnotation markupAnnotation;
                AnnotationComponent annotationComponent = annotationComponents.get(i);
                if (!(annotationComponent instanceof MarkupAnnotationComponent) || (markupAnnotation = (MarkupAnnotation)(markupAnnotationComponent = (MarkupAnnotationComponent)annotationComponent).getAnnotation()).getInReplyToAnnotation() == null || !markupAnnotation.getInReplyToAnnotation().getPObjectReference().equals(reference)) continue;
                this.removeMarkupInReplyTo(markupAnnotation.getPObjectReference());
                this.documentViewController.deleteAnnotation(markupAnnotationComponent);
            }
        }
    }

    private boolean checkForIRT(MarkupAnnotation parentAnnotation, List<Annotation> annotations) {
        if (parentAnnotation != null) {
            Reference reference = parentAnnotation.getPObjectReference();
            for (Annotation annotation : annotations) {
                MarkupAnnotation markupAnnotation;
                MarkupAnnotation inReplyToAnnotation;
                if (!(annotation instanceof MarkupAnnotation) || (inReplyToAnnotation = (markupAnnotation = (MarkupAnnotation)annotation).getInReplyToAnnotation()) == null || !inReplyToAnnotation.getPObjectReference().equals(reference)) continue;
                return true;
            }
        }
        return false;
    }

    private void addAnnotationComponent(Annotation annotation) {
        Rectangle bBox = new Rectangle(-20, -20, 20, 20);
        AbstractAnnotationComponent comp = AnnotationComponentFactory.buildAnnotationComponent(annotation, this.documentViewController, this.pageViewComponent, this.documentViewModel);
        comp.setBounds(bBox);
        comp.refreshAnnotationRect();
        if (this.documentViewController.getAnnotationCallback() != null) {
            AnnotationCallback annotationCallback = this.documentViewController.getAnnotationCallback();
            annotationCallback.newAnnotation(this.pageViewComponent, comp);
        }
    }

    private AnnotationComponent findAnnotationComponent(Annotation annotation) {
        ArrayList<AnnotationComponent> annotationComponents = this.pageViewComponent.getAnnotationComponents();
        Reference annotationReference = annotation.getPObjectReference();
        for (AnnotationComponent annotationComponent : annotationComponents) {
            Reference compReference = annotationComponent.getAnnotation().getPObjectReference();
            if (!compReference.equals(annotationReference)) continue;
            return annotationComponent;
        }
        return null;
    }

    @Override
    public void paintComponent(Graphics g) {
    }

    @Override
    public void resetAppearanceShapes() {
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                PopupAnnotationComponent.this.contextMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    class PopupTreeListener
    extends MouseAdapter {
        PopupTreeListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                int row = PopupAnnotationComponent.this.commentTree.getClosestRowForLocation(e.getX(), e.getY());
                PopupAnnotationComponent.this.commentTree.setSelectionRow(row);
                PopupAnnotationComponent.this.contextMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

