/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.thumbs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.PDimension;
import org.icepdf.core.pobjects.PageTree;
import org.icepdf.ri.common.PageThumbnailComponent;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.util.PropertiesManager;

public class ThumbnailsPanel
extends JPanel {
    protected DocumentViewController documentViewController;
    protected Document currentDocument;
    protected PropertiesManager propertiesManager;
    protected DocumentViewModel documentViewModel;
    protected float thumbNailZoom = 0.1f;
    protected static final int MAX_PAGE_SIZE_READ_AHEAD = 10;
    private final SwingController controller;
    private double width = 0.0;
    private static final Object lock = new Object();
    private boolean setWidthInChangeListener = true;
    private JScrollPane scrollPane = null;
    private JPanel pageThumbsPanel = null;

    public ThumbnailsPanel(SwingController controller, PropertiesManager propertiesManager) {
        this.controller = controller;
        this.propertiesManager = propertiesManager;
        if (propertiesManager != null) {
            this.thumbNailZoom = propertiesManager.getFloat("application.utilitypane.thumbnail.zoom");
        }
    }

    public void setDocument(Document document) {
        this.currentDocument = document;
        this.documentViewController = this.controller.getDocumentViewController();
        if (document != null) {
            this.buildUI();
        } else {
            this.removeAll();
        }
    }

    public void dispose() {
        this.removeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildUI() {
        final ModifiedFlowLayout layout = new ModifiedFlowLayout();
        this.pageThumbsPanel = new JPanel(layout);
        this.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane(this.pageThumbsPanel, 22, 30);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(20);
        this.add((Component)this.scrollPane, "Center");
        this.scrollPane.getViewport().addChangeListener(new ChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stateChanged(ChangeEvent e) {
                Object object = lock;
                synchronized (object) {
                    JViewport tmp = (JViewport)e.getSource();
                    Dimension dim = layout.computeSize(tmp.getWidth(), ThumbnailsPanel.this.pageThumbsPanel);
                    ThumbnailsPanel.this.width = tmp.getWidth();
                    if (ThumbnailsPanel.this.width > 0.0 && ThumbnailsPanel.this.setWidthInChangeListener) {
                        ThumbnailsPanel.this.setWidthInChangeListener = false;
                        ThumbnailsPanel.this.loadThumbnails(ThumbnailsPanel.this.scrollPane);
                    }
                    ThumbnailsPanel.this.pageThumbsPanel.setPreferredSize(dim);
                }
            }
        });
        Object object = lock;
        synchronized (object) {
            if (this.width > 0.0 && !this.setWidthInChangeListener) {
                this.loadThumbnails(this.scrollPane);
            }
        }
    }

    private void loadThumbnails(JScrollPane scrollPane) {
        PageThumbnailComponent pageThumbnailComponent = null;
        PageTree pageTree = this.currentDocument.getPageTree();
        int numberOfPages = this.currentDocument.getNumberOfPages();
        int avgPageWidth = 0;
        int avgPageHeight = 0;
        PDimension pageDimension = this.currentDocument.getPageDimension(0, 0.0f);
        this.thumbNailZoom = (float)this.width / pageDimension.getWidth();
        for (int i = 0; i < numberOfPages; ++i) {
            if (i < 10) {
                pageThumbnailComponent = new PageThumbnailComponent(this.controller, scrollPane, pageTree, i, this.thumbNailZoom);
                avgPageWidth += pageThumbnailComponent.getPreferredSize().width;
                avgPageHeight += pageThumbnailComponent.getPreferredSize().height;
            } else if (i > 10) {
                pageThumbnailComponent = new PageThumbnailComponent(this.controller, scrollPane, pageTree, i, avgPageWidth, avgPageHeight, this.thumbNailZoom);
            } else if (i == 10) {
                pageThumbnailComponent = new PageThumbnailComponent(this.controller, scrollPane, pageTree, i, avgPageWidth /= 10, avgPageHeight /= 10, this.thumbNailZoom);
            }
            this.pageThumbsPanel.add(pageThumbnailComponent);
        }
        this.pageThumbsPanel.revalidate();
        scrollPane.validate();
    }

    class ModifiedFlowLayout
    extends FlowLayout {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension computeSize(int w, Container target) {
            Object object = target.getTreeLock();
            synchronized (object) {
                Insets insets;
                int hgap = this.getHgap();
                int vgap = this.getVgap();
                if (w == 0) {
                    w = Integer.MAX_VALUE;
                }
                if ((insets = target.getInsets()) == null) {
                    insets = new Insets(0, 0, 0, 0);
                }
                int reqdWidth = 0;
                int maxwidth = w - (insets.left + insets.right + hgap * 2);
                int n = target.getComponentCount();
                int x = 0;
                int y = insets.top + vgap;
                int rowHeight = 0;
                for (int i = 0; i < n; ++i) {
                    Component c = target.getComponent(i);
                    if (!c.isVisible()) continue;
                    Dimension d = c.getPreferredSize();
                    if (x == 0 || x + d.width <= maxwidth) {
                        if (x > 0) {
                            x += hgap;
                        }
                        x += d.width;
                        rowHeight = Math.max(rowHeight, d.height);
                    } else {
                        x = d.width;
                        y += vgap + rowHeight;
                        rowHeight = d.height;
                    }
                    reqdWidth = Math.max(reqdWidth, x);
                }
                y += rowHeight;
                return new Dimension(reqdWidth + insets.left + insets.right, y += insets.bottom);
            }
        }
    }
}

