/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ChoiceFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.graphics.text.LineText;
import org.icepdf.core.pobjects.graphics.text.WordText;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.images.Images;
import org.icepdf.ri.util.SearchTextTask;

public class SearchPanel
extends JPanel
implements ActionListener,
TreeSelectionListener {
    private static final String HTML_TAG_START = "<html>";
    private static final String HTML_TAG_END = "</html>";
    private static final String BOLD_TAG_START = "<b>";
    private static final String BOLD_TAG_END = "</b>";
    private GridBagConstraints constraints;
    private JTextField searchTextField;
    private Document document;
    private SwingController controller;
    private JTree tree;
    private DefaultMutableTreeNode rootTreeNode;
    private DefaultTreeModel treeModel;
    private JButton searchButton;
    private JButton clearSearchButton;
    private JCheckBox caseSensitiveCheckbox;
    private JCheckBox wholeWordCheckbox;
    private JCheckBox cumulativeCheckbox;
    private JCheckBox showPagesCheckbox;
    private int lastNodePageIndex;
    protected JProgressBar progressBar;
    protected SearchTextTask searchTextTask;
    protected JLabel findMessage;
    protected Timer timer;
    private static final int ONE_SECOND = 1000;
    private boolean isSearching = false;
    ResourceBundle messageBundle;
    MessageFormat searchResultMessageForm;

    public SearchPanel(SwingController controller) {
        super(true);
        this.setFocusable(true);
        this.controller = controller;
        this.messageBundle = this.controller.getMessageBundle();
        this.searchResultMessageForm = this.setupSearchResultMessageForm();
        this.setGui();
        this.setDocument(controller.getDocument());
    }

    public void setDocument(Document doc) {
        if (this.timer != null) {
            this.timer.stop();
        }
        if (this.searchTextTask != null) {
            this.searchTextTask.stop();
            while (this.searchTextTask.isCurrentlySearching()) {
                try {
                    Thread.sleep(50L);
                }
                catch (Exception e) {}
            }
        }
        this.document = doc;
        if (this.document != null && this.progressBar != null) {
            this.progressBar.setMaximum(this.document.getNumberOfPages());
        }
        if (this.searchTextField != null) {
            this.searchTextField.setText("");
        }
        if (this.searchButton != null) {
            this.searchButton.setText(this.messageBundle.getString("viewer.utilityPane.search.tab.title"));
        }
        if (this.rootTreeNode != null) {
            this.resetTree();
            String docTitle = this.getDocumentTitle();
            this.rootTreeNode.setUserObject(docTitle);
            this.rootTreeNode.setAllowsChildren(true);
            this.tree.setRootVisible(docTitle != null);
        }
        if (this.findMessage != null) {
            this.findMessage.setText("");
            this.findMessage.setVisible(false);
        }
        if (this.progressBar != null) {
            this.progressBar.setVisible(false);
        }
        this.isSearching = false;
    }

    private void setGui() {
        this.rootTreeNode = new DefaultMutableTreeNode();
        this.treeModel = new DefaultTreeModel(this.rootTreeNode);
        this.tree = new JTree(this.treeModel);
        this.tree.setRootVisible(true);
        this.tree.setExpandsSelectedPaths(true);
        this.tree.setShowsRootHandles(true);
        this.tree.setScrollsOnExpand(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setOpenIcon(new ImageIcon(Images.get("page.gif")));
        renderer.setClosedIcon(new ImageIcon(Images.get("page.gif")));
        renderer.setLeafIcon(new ImageIcon(Images.get("page.gif")));
        this.tree.setCellRenderer(renderer);
        JScrollPane scrollPane = new JScrollPane(this.tree);
        scrollPane.setPreferredSize(new Dimension(150, 75));
        JLabel searchLabel = new JLabel(this.messageBundle.getString("viewer.utilityPane.search.searchText.label"));
        this.searchTextField = new JTextField("", 15);
        this.searchTextField.addActionListener(this);
        this.progressBar = new JProgressBar(0, 1);
        this.progressBar.setValue(0);
        this.progressBar.setVisible(false);
        this.findMessage = new JLabel(this.messageBundle.getString("viewer.utilityPane.search.searching.msg"));
        this.findMessage.setVisible(false);
        this.timer = new Timer(1000, new TimerListener());
        this.searchButton = new JButton(this.messageBundle.getString("viewer.utilityPane.search.searchButton.label"));
        this.searchButton.addActionListener(this);
        this.clearSearchButton = new JButton(this.messageBundle.getString("viewer.utilityPane.search.clearSearchButton.label"));
        this.clearSearchButton.addActionListener(this);
        this.wholeWordCheckbox = new JCheckBox(this.messageBundle.getString("viewer.utilityPane.search.wholeWordCheckbox.label"));
        this.caseSensitiveCheckbox = new JCheckBox(this.messageBundle.getString("viewer.utilityPane.search.caseSenstiveCheckbox.label"));
        this.cumulativeCheckbox = new JCheckBox(this.messageBundle.getString("viewer.utilityPane.search.cumlitiveCheckbox.label"));
        this.showPagesCheckbox = new JCheckBox(this.messageBundle.getString("viewer.utilityPane.search.showPagesCheckbox.label"), true);
        this.showPagesCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                block7: {
                    block8: {
                        if (event.getSource() == null) break block7;
                        if (!((JCheckBox)event.getSource()).isSelected()) break block8;
                        if (SearchPanel.this.rootTreeNode == null || SearchPanel.this.rootTreeNode.getChildCount() <= 0) break block7;
                        DefaultMutableTreeNode storedChildParent = null;
                        int storedPageNumber = -1;
                        int storedResultCount = 0;
                        for (int i = 0; i < SearchPanel.this.rootTreeNode.getChildCount(); ++i) {
                            Object[] messageArguments;
                            DefaultMutableTreeNode currentChild = (DefaultMutableTreeNode)SearchPanel.this.rootTreeNode.getChildAt(i);
                            if (!(currentChild.getUserObject() instanceof FindEntry)) continue;
                            int newPageNumber = ((FindEntry)currentChild.getUserObject()).getPageNumber();
                            if (storedPageNumber == newPageNumber) {
                                ++storedResultCount;
                                if (storedChildParent == null) continue;
                                SearchPanel.this.treeModel.removeNodeFromParent(currentChild);
                                storedChildParent.add(currentChild);
                                currentChild.setParent(storedChildParent);
                                --i;
                                continue;
                            }
                            if (storedChildParent != null) {
                                messageArguments = new Object[]{String.valueOf(storedPageNumber + 1), storedResultCount, storedResultCount};
                                storedChildParent.setUserObject(new FindEntry(SearchPanel.this.searchResultMessageForm.format(messageArguments), storedPageNumber));
                            }
                            storedPageNumber = newPageNumber;
                            storedResultCount = 1;
                            SearchPanel.this.treeModel.removeNodeFromParent(currentChild);
                            messageArguments = new Object[]{String.valueOf(storedPageNumber + 1), storedResultCount, storedResultCount};
                            storedChildParent = new DefaultMutableTreeNode(new FindEntry(SearchPanel.this.searchResultMessageForm.format(messageArguments), storedPageNumber), true);
                            storedChildParent.add(currentChild);
                            currentChild.setParent(storedChildParent);
                            SearchPanel.this.treeModel.insertNodeInto(storedChildParent, SearchPanel.this.rootTreeNode, i);
                        }
                        break block7;
                    }
                    if (SearchPanel.this.rootTreeNode != null && SearchPanel.this.rootTreeNode.getChildCount() > 0) {
                        int rootChildCount = SearchPanel.this.rootTreeNode.getChildCount();
                        for (int i = 0; i < rootChildCount; ++i) {
                            DefaultMutableTreeNode currentChild = (DefaultMutableTreeNode)SearchPanel.this.rootTreeNode.getChildAt(0);
                            if (currentChild.getChildCount() > 0) {
                                for (int j = 0; j < currentChild.getChildCount(); ++j) {
                                    SearchPanel.this.treeModel.insertNodeInto(new DefaultMutableTreeNode(((DefaultMutableTreeNode)currentChild.getChildAt(j)).getUserObject(), false), SearchPanel.this.rootTreeNode, SearchPanel.this.rootTreeNode.getChildCount());
                                }
                            }
                            SearchPanel.this.treeModel.removeNodeFromParent(currentChild);
                        }
                    }
                }
            }
        });
        GridBagLayout layout = new GridBagLayout();
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 0;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.anchor = 11;
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(10, 5, 1, 5);
        JPanel searchPanel = new JPanel(layout);
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(searchPanel, 20, 30), "Center");
        this.addGB(searchPanel, searchLabel, 0, 0, 2, 1);
        this.constraints.insets = new Insets(1, 1, 1, 5);
        this.constraints.weightx = 1.0;
        this.constraints.fill = 2;
        this.addGB(searchPanel, this.searchTextField, 0, 1, 2, 1);
        this.constraints.insets = new Insets(1, 1, 1, 5);
        this.constraints.weightx = 1.0;
        this.constraints.fill = 13;
        this.addGB(searchPanel, this.searchButton, 0, 2, 1, 1);
        this.constraints.insets = new Insets(1, 1, 1, 5);
        this.constraints.weightx = 0.0;
        this.constraints.fill = 0;
        this.addGB(searchPanel, this.clearSearchButton, 1, 2, 1, 1);
        this.constraints.insets = new Insets(5, 1, 1, 5);
        this.constraints.weightx = 1.0;
        this.constraints.fill = 2;
        this.addGB(searchPanel, this.caseSensitiveCheckbox, 0, 3, 2, 1);
        this.constraints.insets = new Insets(1, 1, 1, 5);
        this.constraints.fill = 2;
        this.addGB(searchPanel, this.wholeWordCheckbox, 0, 4, 2, 1);
        this.constraints.insets = new Insets(1, 1, 1, 5);
        this.constraints.fill = 2;
        this.addGB(searchPanel, this.cumulativeCheckbox, 0, 5, 2, 1);
        this.constraints.insets = new Insets(1, 1, 1, 5);
        this.constraints.fill = 2;
        this.addGB(searchPanel, this.showPagesCheckbox, 0, 6, 2, 1);
        this.constraints.insets = new Insets(10, 5, 1, 5);
        this.constraints.fill = 0;
        this.addGB(searchPanel, new JLabel(this.messageBundle.getString("viewer.utilityPane.search.results.label")), 0, 7, 2, 1);
        this.constraints.fill = 1;
        this.constraints.insets = new Insets(1, 5, 1, 5);
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.addGB(searchPanel, scrollPane, 0, 8, 2, 1);
        this.constraints.insets = new Insets(1, 5, 1, 5);
        this.constraints.weighty = 0.0;
        this.constraints.fill = 0;
        this.constraints.anchor = 13;
        this.findMessage.setAlignmentX(1.0f);
        this.addGB(searchPanel, this.findMessage, 0, 9, 2, 1);
        this.constraints.insets = new Insets(5, 5, 1, 5);
        this.constraints.fill = 2;
        this.addGB(searchPanel, this.progressBar, 0, 10, 2, 1);
    }

    @Override
    public void setVisible(boolean flag) {
        super.setVisible(flag);
        if (this.isShowing()) {
            this.searchTextField.requestFocus(true);
        }
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        this.searchTextField.requestFocus();
    }

    public void dispose() {
        this.document = null;
        this.controller = null;
        this.searchTextTask = null;
        this.timer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode selectedNode;
        if (this.tree.getLastSelectedPathComponent() != null && (selectedNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent()).getUserObject() instanceof FindEntry) {
            FindEntry tmp = (FindEntry)selectedNode.getUserObject();
            if (this.controller != null) {
                int oldTool = this.controller.getDocumentViewToolMode();
                try {
                    this.controller.setDisplayTool(51);
                    this.controller.showPage(tmp.getPageNumber());
                }
                finally {
                    this.controller.setDisplayTool(oldTool);
                }
            }
        }
    }

    public void addFoundEntry(String title, int pageNumber, List<LineText> textResults, boolean showPages) {
        if (textResults != null && textResults.size() > 0) {
            DefaultMutableTreeNode parentNode;
            if (showPages && this.lastNodePageIndex != pageNumber) {
                parentNode = new DefaultMutableTreeNode(new FindEntry(title, pageNumber), true);
                this.treeModel.insertNodeInto(parentNode, this.rootTreeNode, this.rootTreeNode.getChildCount());
            } else {
                parentNode = this.rootTreeNode;
            }
            for (LineText currentText : textResults) {
                this.addObject(parentNode, new DefaultMutableTreeNode(new FindEntry(SearchPanel.generateResultPreview(currentText.getWords()), pageNumber), false), false);
            }
            if (this.lastNodePageIndex == -1) {
                this.tree.expandPath(new TreePath(this.rootTreeNode));
            }
            this.lastNodePageIndex = pageNumber;
        }
    }

    private void addObject(DefaultMutableTreeNode parent, DefaultMutableTreeNode childNode, boolean shouldBeVisible) {
        if (parent == null) {
            parent = this.rootTreeNode;
        }
        this.treeModel.insertNodeInto(childNode, parent, parent.getChildCount());
        if (shouldBeVisible) {
            this.tree.scrollPathToVisible(new TreePath(childNode.getPath()));
        }
    }

    private static String generateResultPreview(List<WordText> allText) {
        StringBuilder toReturn = new StringBuilder(HTML_TAG_START);
        for (WordText currentText : allText) {
            if (currentText.isHighlighted()) {
                toReturn.append(BOLD_TAG_START);
                toReturn.append(currentText.getText());
                toReturn.append(BOLD_TAG_END);
                continue;
            }
            toReturn.append(currentText.getText());
        }
        toReturn.append(HTML_TAG_END);
        return toReturn.toString();
    }

    protected void resetTree() {
        this.tree.setSelectionPath(null);
        this.rootTreeNode.removeAllChildren();
        this.treeModel.nodeStructureChanged(this.rootTreeNode);
        this.lastNodePageIndex = -1;
    }

    private String getDocumentTitle() {
        String documentTitle = null;
        if (this.document != null && this.document.getInfo() != null) {
            documentTitle = this.document.getInfo().getTitle();
        }
        if (documentTitle == null || documentTitle.trim().length() == 0) {
            return null;
        }
        return documentTitle;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (this.searchTextField.getText().length() > 0 && (source == this.searchTextField || source == this.searchButton)) {
            if (!this.timer.isRunning()) {
                this.findMessage.setVisible(true);
                this.progressBar.setVisible(true);
                this.resetTree();
                this.searchTextTask = new SearchTextTask(this, this.controller, this.searchTextField.getText(), this.wholeWordCheckbox.isSelected(), this.caseSensitiveCheckbox.isSelected(), this.cumulativeCheckbox.isSelected(), this.showPagesCheckbox.isSelected(), false, this.messageBundle);
                this.isSearching = true;
                this.searchButton.setText(this.messageBundle.getString("viewer.utilityPane.search.stopButton.label"));
                this.clearSearchButton.setEnabled(false);
                this.caseSensitiveCheckbox.setEnabled(false);
                this.wholeWordCheckbox.setEnabled(false);
                this.cumulativeCheckbox.setEnabled(false);
                this.showPagesCheckbox.setEnabled(false);
                this.searchTextTask.go();
                this.timer.start();
            } else {
                this.isSearching = false;
                this.clearSearchButton.setEnabled(true);
                this.caseSensitiveCheckbox.setEnabled(true);
                this.wholeWordCheckbox.setEnabled(true);
                this.cumulativeCheckbox.setEnabled(true);
                this.showPagesCheckbox.setEnabled(true);
            }
        } else if (source == this.clearSearchButton) {
            this.searchTextField.setText("");
            this.resetTree();
            this.controller.getDocumentSearchController().clearAllSearchHighlight();
            this.controller.getDocumentViewController().getViewContainer().repaint();
        }
    }

    private void addGB(JPanel panel, Component component, int x, int y, int rowSpan, int colSpan) {
        this.constraints.gridx = x;
        this.constraints.gridy = y;
        this.constraints.gridwidth = rowSpan;
        this.constraints.gridheight = colSpan;
        panel.add(component, this.constraints);
    }

    public MessageFormat setupSearchResultMessageForm() {
        MessageFormat messageForm = new MessageFormat(this.messageBundle.getString("viewer.utilityPane.search.result.msg"));
        double[] pageLimits = new double[]{0.0, 1.0, 2.0};
        String[] resultsStrings = new String[]{this.messageBundle.getString("viewer.utilityPane.search.result.moreFile.msg"), this.messageBundle.getString("viewer.utilityPane.search.result.oneFile.msg"), this.messageBundle.getString("viewer.utilityPane.search.result.moreFile.msg")};
        ChoiceFormat resultsChoiceForm = new ChoiceFormat(pageLimits, resultsStrings);
        Format[] formats = new Format[]{null, resultsChoiceForm};
        messageForm.setFormats(formats);
        return messageForm;
    }

    public MessageFormat setupSearchingMessageForm() {
        MessageFormat messageForm = new MessageFormat(this.messageBundle.getString("viewer.utilityPane.search.searching1.msg"));
        double[] fileLimits = new double[]{0.0, 1.0, 2.0};
        String[] fileStrings = new String[]{this.messageBundle.getString("viewer.utilityPane.search.searching1.moreFile.msg"), this.messageBundle.getString("viewer.utilityPane.search.searching1.oneFile.msg"), this.messageBundle.getString("viewer.utilityPane.search.searching1.moreFile.msg")};
        ChoiceFormat choiceForm = new ChoiceFormat(fileLimits, fileStrings);
        Format[] formats = new Format[]{null, choiceForm, null};
        messageForm.setFormats(formats);
        return messageForm;
    }

    public MessageFormat setupSearchCompletionMessageForm() {
        MessageFormat messageForm = new MessageFormat(this.messageBundle.getString("viewer.utilityPane.search.progress.msg"));
        double[] pageLimits = new double[]{0.0, 1.0, 2.0};
        String[] pageStrings = new String[]{this.messageBundle.getString("viewer.utilityPane.search.progress.morePage.msg"), this.messageBundle.getString("viewer.utilityPane.search.progress.onePage.msg"), this.messageBundle.getString("viewer.utilityPane.search.progress.morePage.msg")};
        ChoiceFormat pageChoiceForm = new ChoiceFormat(pageLimits, pageStrings);
        String[] resultsStrings = new String[]{this.messageBundle.getString("viewer.utilityPane.search.progress.moreMatch.msg"), this.messageBundle.getString("viewer.utilityPane.search.progress.oneMatch.msg"), this.messageBundle.getString("viewer.utilityPane.search.progress.moreMatch.msg")};
        ChoiceFormat resultsChoiceForm = new ChoiceFormat(pageLimits, resultsStrings);
        Format[] formats = new Format[]{null, pageChoiceForm, resultsChoiceForm};
        messageForm.setFormats(formats);
        return messageForm;
    }

    class FindEntry
    extends DefaultMutableTreeNode {
        String title;
        int pageNumber;

        FindEntry(String title) {
            this.pageNumber = 0;
            this.title = title;
            this.setUserObject(title);
        }

        FindEntry(String title, int pageNumber) {
            this.pageNumber = pageNumber;
            this.title = title;
            this.setUserObject(title);
        }

        public int getPageNumber() {
            return this.pageNumber;
        }
    }

    class TimerListener
    implements ActionListener {
        TimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            SearchPanel.this.progressBar.setValue(SearchPanel.this.searchTextTask.getCurrent());
            String s = SearchPanel.this.searchTextTask.getMessage();
            if (s != null) {
                SearchPanel.this.findMessage.setText(s);
            }
            if (SearchPanel.this.searchTextTask.isDone() || !SearchPanel.this.isSearching) {
                SearchPanel.this.findMessage.setText(SearchPanel.this.searchTextTask.getFinalMessage());
                SearchPanel.this.timer.stop();
                SearchPanel.this.searchTextTask.stop();
                SearchPanel.this.searchButton.setText(SearchPanel.this.messageBundle.getString("viewer.utilityPane.search.searchButton.label"));
                SearchPanel.this.clearSearchButton.setEnabled(true);
                SearchPanel.this.caseSensitiveCheckbox.setEnabled(true);
                SearchPanel.this.wholeWordCheckbox.setEnabled(true);
                SearchPanel.this.cumulativeCheckbox.setEnabled(true);
                SearchPanel.this.showPagesCheckbox.setEnabled(true);
                SearchPanel.this.progressBar.setValue(SearchPanel.this.progressBar.getMinimum());
                SearchPanel.this.progressBar.setVisible(false);
            }
        }
    }
}

