/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.annotation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.icepdf.core.pobjects.Destination;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.NameTree;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.actions.Action;
import org.icepdf.core.pobjects.actions.ActionFactory;
import org.icepdf.core.pobjects.actions.GoToAction;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.LinkAnnotation;
import org.icepdf.ri.common.FloatTextFieldInputVerifier;
import org.icepdf.ri.common.FloatTextFieldKeyListener;
import org.icepdf.ri.common.PageNumberTextFieldInputVerifier;
import org.icepdf.ri.common.PageNumberTextFieldKeyListener;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.utility.annotation.ActionsPanel;
import org.icepdf.ri.common.utility.annotation.AnnotationDialogAdapter;
import org.icepdf.ri.common.utility.annotation.NameTreeDialog;
import org.icepdf.ri.common.utility.annotation.ValueLabelItem;
import org.icepdf.ri.common.views.AnnotationComponent;

public class GoToActionDialog
extends AnnotationDialogAdapter
implements ActionListener,
ItemListener {
    public static final String EMPTY_DESTINATION = "      ";
    private SwingController controller;
    private ResourceBundle messageBundle;
    private AnnotationComponent currentAnnotation;
    private ActionsPanel actionsPanel;
    private GridBagConstraints constraints;
    private JButton okButton;
    private JButton cancelButton;
    private JRadioButton implicitDestination;
    private JRadioButton namedDestination;
    private JComboBox implicitDestTypeComboBox;
    private JTextField pageNumberTextField;
    private JTextField topTextField;
    private JTextField bottomTextField;
    private JTextField leftTextField;
    private JTextField rightTextField;
    private JTextField zoomTextField;
    private JButton viewPositionButton;
    private JLabel destinationName;
    private JButton viewNamedDesButton;
    private NameTreeDialog nameTreeDialog;

    public GoToActionDialog(SwingController controller, ActionsPanel actionsPanel) {
        super(controller.getViewerFrame(), true);
        this.controller = controller;
        this.messageBundle = this.controller.getMessageBundle();
        this.actionsPanel = actionsPanel;
        this.setTitle(this.messageBundle.getString("viewer.utilityPane.action.dialog.goto.title"));
        this.setGui();
    }

    @Override
    public void setAnnotationComponent(AnnotationComponent annotation) {
        this.currentAnnotation = annotation;
        Action action = this.currentAnnotation.getAnnotation().getAction();
        Destination dest = null;
        if (action != null && action instanceof GoToAction) {
            dest = ((GoToAction)action).getDestination();
        } else if (action == null && this.currentAnnotation.getAnnotation() instanceof LinkAnnotation) {
            LinkAnnotation linkAnnotation = (LinkAnnotation)this.currentAnnotation.getAnnotation();
            dest = linkAnnotation.getDestination();
        }
        if (this.controller.getDocument().getCatalog().getNameTree() == null) {
            this.implicitDestinationFieldsEnabled(true);
            this.clearImplicitDestinations(true);
            this.namedDestination.setEnabled(false);
        } else {
            this.namedDestination.setEnabled(true);
        }
        if (dest != null) {
            this.clearImplicitDestinations(false);
            this.clearImplicitDestinations(true);
            if (dest.getNamedDestination() == null) {
                this.implicitDestinationFieldsEnabled(true);
                Name type = dest.getType();
                this.applySelectedValue(this.implicitDestTypeComboBox, type);
                this.enableFitTypeFields(type);
                this.applyTypeValues(dest, type);
                this.pageNumberTextField.setText(String.valueOf(this.controller.getDocument().getPageTree().getPageNumber(dest.getPageReference()) + 1));
            } else {
                this.implicitDestinationFieldsEnabled(false);
                this.destinationName.setText(dest.getNamedDestination().toString());
            }
        } else {
            this.applySelectedValue(this.implicitDestTypeComboBox, Destination.TYPE_FIT);
            this.enableFitTypeFields(Destination.TYPE_FIT);
        }
    }

    private void saveActionState() {
        Destination destination;
        Annotation annotation = this.currentAnnotation.getAnnotation();
        if (this.implicitDestination.isSelected()) {
            Name fitType = (Name)((ValueLabelItem)this.implicitDestTypeComboBox.getSelectedItem()).getValue();
            int pageNumber = Integer.parseInt(this.pageNumberTextField.getText());
            Reference pageReference = this.controller.getDocument().getPageTree().getPageReference(pageNumber - 1);
            List<Object> destArray = null;
            if (fitType.equals(Destination.TYPE_FIT) || fitType.equals(Destination.TYPE_FITB)) {
                destArray = Destination.destinationSyntax(pageReference, fitType);
            } else if (fitType.equals(Destination.TYPE_FITH) || fitType.equals(Destination.TYPE_FITBH) || fitType.equals(Destination.TYPE_FITV) || fitType.equals(Destination.TYPE_FITBV)) {
                Object top = this.parseDestCoordinate(this.topTextField.getText());
                destArray = Destination.destinationSyntax(pageReference, fitType, top);
            } else if (fitType.equals(Destination.TYPE_XYZ)) {
                Object left = this.parseDestCoordinate(this.leftTextField.getText());
                Object top = this.parseDestCoordinate(this.topTextField.getText());
                Object zoom = this.parseDestCoordinate(this.zoomTextField.getText());
                destArray = Destination.destinationSyntax(pageReference, fitType, left, top, zoom);
            } else if (fitType.equals(Destination.TYPE_FITR)) {
                Object left = this.parseDestCoordinate(this.leftTextField.getText());
                Object bottom = this.parseDestCoordinate(this.leftTextField.getText());
                Object right = this.parseDestCoordinate(this.leftTextField.getText());
                Object top = this.parseDestCoordinate(this.leftTextField.getText());
                destArray = Destination.destinationSyntax(pageReference, fitType, left, bottom, right, top);
            }
            destination = new Destination(annotation.getLibrary(), destArray);
        } else {
            destination = new Destination(annotation.getLibrary(), new Name(this.destinationName.getText()));
        }
        GoToAction action = (GoToAction)annotation.getAction();
        if (action == null) {
            action = (GoToAction)ActionFactory.buildAction(annotation.getLibrary(), 1);
            action.setDestination(destination);
            annotation.addAction(action);
            this.actionsPanel.clearActionList();
            this.actionsPanel.addActionToList(action);
        } else {
            action.setDestination(destination);
            annotation.updateAction(action);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.saveActionState();
            this.dispose();
        } else if (e.getSource() == this.cancelButton) {
            this.dispose();
        } else if (e.getSource() == this.viewNamedDesButton) {
            NameTree nameTree = this.controller.getDocument().getCatalog().getNameTree();
            if (nameTree != null) {
                this.nameTreeDialog = new NameTreeDialog(this.controller, true, nameTree);
                this.nameTreeDialog.setDestinationName(this.destinationName);
                this.nameTreeDialog.setVisible(true);
                this.nameTreeDialog.dispose();
            }
        } else if (e.getSource() == this.viewPositionButton) {
            // empty if block
        }
    }

    @Override
    public void dispose() {
        this.setVisible(false);
        super.dispose();
        if (this.nameTreeDialog != null) {
            this.nameTreeDialog.dispose();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1 || e.getStateChange() == 2) {
            if (e.getSource() == this.implicitDestination) {
                this.implicitDestinationFieldsEnabled(e.getStateChange() == 1);
                if (this.implicitDestination.isSelected() && this.implicitDestTypeComboBox.getSelectedItem() == null) {
                    this.applySelectedValue(this.implicitDestTypeComboBox, Destination.TYPE_FIT);
                    this.enableFitTypeFields(Destination.TYPE_FIT);
                }
            } else if (e.getSource() == this.implicitDestTypeComboBox) {
                ValueLabelItem valueItem = (ValueLabelItem)e.getItem();
                Name fitType = (Name)valueItem.getValue();
                this.enableFitTypeFields(fitType);
            }
        }
    }

    protected void setGui() {
        JPanel goToActionPanel = new JPanel();
        goToActionPanel.setAlignmentY(0.0f);
        GridBagLayout layout = new GridBagLayout();
        goToActionPanel.setLayout(layout);
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 0;
        this.constraints.weightx = 1.0;
        this.constraints.anchor = 11;
        this.constraints.anchor = 13;
        this.constraints.insets = new Insets(5, 5, 5, 5);
        JPanel explicitDestinationSubpane = new JPanel(new GridLayout(4, 4, 10, 5));
        explicitDestinationSubpane.setBorder(new EmptyBorder(0, 40, 0, 0));
        explicitDestinationSubpane.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.action.dialog.goto.type.label")));
        this.implicitDestTypeComboBox = this.buildImplicitDestTypes();
        this.implicitDestTypeComboBox.addItemListener(this);
        explicitDestinationSubpane.add(this.implicitDestTypeComboBox);
        explicitDestinationSubpane.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.action.dialog.goto.page.label")));
        this.pageNumberTextField = this.buildDocumentPageNumbers();
        explicitDestinationSubpane.add(this.pageNumberTextField);
        explicitDestinationSubpane.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.action.dialog.goto.top.label")));
        this.topTextField = this.buildFloatTextField();
        explicitDestinationSubpane.add(this.topTextField);
        explicitDestinationSubpane.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.action.dialog.goto.bottom.label")));
        this.bottomTextField = this.buildFloatTextField();
        explicitDestinationSubpane.add(this.bottomTextField);
        explicitDestinationSubpane.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.action.dialog.goto.left.label")));
        this.leftTextField = this.buildFloatTextField();
        explicitDestinationSubpane.add(this.leftTextField);
        explicitDestinationSubpane.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.action.dialog.goto.right.label")));
        this.rightTextField = this.buildFloatTextField();
        explicitDestinationSubpane.add(this.rightTextField);
        explicitDestinationSubpane.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.action.dialog.goto.zoom.label")));
        this.zoomTextField = this.buildFloatTextField();
        explicitDestinationSubpane.add(this.zoomTextField);
        explicitDestinationSubpane.add(new JLabel());
        explicitDestinationSubpane.add(new JLabel());
        JPanel pageNumberPane = new JPanel(new BorderLayout(5, 5));
        this.implicitDestination = new JRadioButton(this.messageBundle.getString("viewer.utilityPane.action.dialog.goto.explicitDestination.title"), true);
        this.implicitDestination.addItemListener(this);
        pageNumberPane.add((Component)this.implicitDestination, "North");
        pageNumberPane.add((Component)explicitDestinationSubpane, "Center");
        JPanel namedDestSubpane = new JPanel(new FlowLayout(0, 5, 5));
        namedDestSubpane.setBorder(new EmptyBorder(0, 40, 0, 0));
        namedDestSubpane.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.action.dialog.goto.name.label")));
        this.destinationName = new JLabel(EMPTY_DESTINATION);
        namedDestSubpane.add(this.destinationName);
        this.viewNamedDesButton = new JButton(this.messageBundle.getString("viewer.utilityPane.action.dialog.goto.browse"));
        this.viewNamedDesButton.addActionListener(this);
        namedDestSubpane.add(this.viewNamedDesButton);
        JPanel namedDestPane = new JPanel(new BorderLayout(5, 5));
        this.namedDestination = new JRadioButton(this.messageBundle.getString("viewer.utilityPane.action.dialog.goto.nameDestination.title"), false);
        namedDestPane.add((Component)this.namedDestination, "North");
        namedDestPane.add((Component)namedDestSubpane, "Center");
        ButtonGroup actionButtonGroup = new ButtonGroup();
        actionButtonGroup.add(this.implicitDestination);
        actionButtonGroup.add(this.namedDestination);
        this.okButton = new JButton(this.messageBundle.getString("viewer.button.ok.label"));
        this.okButton.setMnemonic(this.messageBundle.getString("viewer.button.ok.mnemonic").charAt(0));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(this.messageBundle.getString("viewer.button.cancel.label"));
        this.cancelButton.setMnemonic(this.messageBundle.getString("viewer.button.cancel.mnemonic").charAt(0));
        this.cancelButton.addActionListener(this);
        JPanel okCancelPanel = new JPanel(new FlowLayout());
        okCancelPanel.add(this.okButton);
        okCancelPanel.add(this.cancelButton);
        this.constraints.insets = new Insets(5, 5, 5, 5);
        this.constraints.anchor = 17;
        this.addGB(goToActionPanel, pageNumberPane, 0, 0, 1, 1);
        this.addGB(goToActionPanel, namedDestPane, 0, 1, 1, 1);
        this.constraints.insets = new Insets(15, 5, 5, 5);
        this.constraints.anchor = 10;
        this.addGB(goToActionPanel, okCancelPanel, 0, 2, 1, 1);
        this.getContentPane().add(goToActionPanel);
        this.setSize(new Dimension(500, 325));
        this.setLocationRelativeTo(this.controller.getViewerFrame());
    }

    private Object parseDestCoordinate(String fieldValue) {
        try {
            return Float.valueOf(Float.parseFloat(fieldValue));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private String getDestCoordinate(Float coord) {
        if (coord != null) {
            return String.valueOf(coord);
        }
        return "";
    }

    private void applyTypeValues(Destination dest, Name type) {
        if (Destination.TYPE_XYZ.equals(type)) {
            this.leftTextField.setText(this.getDestCoordinate(dest.getLeft()));
            this.topTextField.setText(this.getDestCoordinate(dest.getTop()));
            this.zoomTextField.setText(this.getDestCoordinate(dest.getZoom()));
        } else if (!Destination.TYPE_FIT.equals(type)) {
            if (Destination.TYPE_FITH.equals(type)) {
                this.topTextField.setText(this.getDestCoordinate(dest.getTop()));
            } else if (Destination.TYPE_FITV.equals(type)) {
                this.leftTextField.setText(this.getDestCoordinate(dest.getLeft()));
            } else if (Destination.TYPE_FITR.equals(type)) {
                this.leftTextField.setText(this.getDestCoordinate(dest.getLeft()));
                this.rightTextField.setText(this.getDestCoordinate(dest.getRight()));
                this.topTextField.setText(this.getDestCoordinate(dest.getTop()));
                this.bottomTextField.setText(this.getDestCoordinate(dest.getBottom()));
            } else if (!Destination.TYPE_FITB.equals(type)) {
                if (Destination.TYPE_FITH.equals(type)) {
                    this.topTextField.setText(this.getDestCoordinate(dest.getTop()));
                } else if (Destination.TYPE_FITBV.equals(type)) {
                    this.leftTextField.setText(this.getDestCoordinate(dest.getLeft()));
                }
            }
        }
    }

    private JTextField buildDocumentPageNumbers() {
        final JTextField textField = new JTextField();
        textField.setInputVerifier(new PageNumberTextFieldInputVerifier());
        textField.addKeyListener(new PageNumberTextFieldKeyListener());
        textField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                int maxValue;
                String fieldValue;
                int currentValue;
                Object src = e.getSource();
                if (src == null) {
                    return;
                }
                if (src == textField && (currentValue = Integer.parseInt(fieldValue = textField.getText())) > (maxValue = GoToActionDialog.this.controller.getDocument().getNumberOfPages())) {
                    textField.setText(String.valueOf(maxValue));
                }
            }
        });
        textField.setText("1");
        return textField;
    }

    private JTextField buildFloatTextField() {
        final JTextField textField = new JTextField();
        textField.setInputVerifier(new FloatTextFieldInputVerifier());
        textField.addKeyListener(new FloatTextFieldKeyListener());
        textField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Object src = e.getSource();
                if (src == null) {
                    return;
                }
                if (src == textField) {
                    String fieldValue = textField.getText();
                    if ("".equals(fieldValue)) {
                        return;
                    }
                    float currentValue = Float.parseFloat(fieldValue);
                    textField.setText(String.valueOf(currentValue));
                }
            }
        });
        return textField;
    }

    private JComboBox buildImplicitDestTypes() {
        ValueLabelItem[] destTypes = new ValueLabelItem[]{new ValueLabelItem(Destination.TYPE_XYZ, this.messageBundle.getString("viewer.utilityPane.action.dialog.goto.type.xyz.label")), new ValueLabelItem(Destination.TYPE_FITH, this.messageBundle.getString("viewer.utilityPane.action.dialog.goto.type.fith.label")), new ValueLabelItem(Destination.TYPE_FITR, this.messageBundle.getString("viewer.utilityPane.action.dialog.goto.type.fitr.label")), new ValueLabelItem(Destination.TYPE_FIT, this.messageBundle.getString("viewer.utilityPane.action.dialog.goto.type.fit.label")), new ValueLabelItem(Destination.TYPE_FITB, this.messageBundle.getString("viewer.utilityPane.action.dialog.goto.type.fitb.label")), new ValueLabelItem(Destination.TYPE_FITBH, this.messageBundle.getString("viewer.utilityPane.action.dialog.goto.type.fitbh.label")), new ValueLabelItem(Destination.TYPE_FITBV, this.messageBundle.getString("viewer.utilityPane.action.dialog.goto.type.fitbv.label")), new ValueLabelItem(Destination.TYPE_FITBV, this.messageBundle.getString("viewer.utilityPane.action.dialog.goto.type.fitbv.label"))};
        return new JComboBox<ValueLabelItem>(destTypes);
    }

    private void addGB(JPanel layout, Component component, int x, int y, int rowSpan, int colSpan) {
        this.constraints.gridx = x;
        this.constraints.gridy = y;
        this.constraints.gridwidth = rowSpan;
        this.constraints.gridheight = colSpan;
        layout.add(component, this.constraints);
    }

    private void implicitDestinationFieldsEnabled(boolean isImplictDestSelected) {
        this.implicitDestination.setSelected(isImplictDestSelected);
        this.namedDestination.setSelected(!isImplictDestSelected);
        this.pageNumberTextField.setEnabled(isImplictDestSelected);
        this.implicitDestTypeComboBox.setEnabled(isImplictDestSelected);
        this.leftTextField.setEnabled(isImplictDestSelected);
        this.topTextField.setEnabled(isImplictDestSelected);
        this.zoomTextField.setEnabled(isImplictDestSelected);
        this.destinationName.setEnabled(!isImplictDestSelected);
        this.viewNamedDesButton.setEnabled(!isImplictDestSelected);
    }

    private void clearImplicitDestinations(boolean isImplictDestSelected) {
        if (!isImplictDestSelected) {
            this.pageNumberTextField.setText("");
            this.implicitDestTypeComboBox.setSelectedIndex(-1);
            this.leftTextField.setText("");
            this.topTextField.setText("");
            this.zoomTextField.setText("");
        } else {
            this.destinationName.setText(EMPTY_DESTINATION);
        }
    }

    private void enableFitTypeFields(Name fitType) {
        if (fitType.equals(Destination.TYPE_FIT) || fitType.equals(Destination.TYPE_FITB)) {
            this.setFitTypesEnabled(false, false, false, false, false);
        } else if (fitType.equals(Destination.TYPE_FITH) || fitType.equals(Destination.TYPE_FITBH)) {
            this.setFitTypesEnabled(true, false, false, false, false);
        } else if (fitType.equals(Destination.TYPE_FITV) || fitType.equals(Destination.TYPE_FITBV)) {
            this.setFitTypesEnabled(false, false, true, false, false);
        } else if (fitType.equals(Destination.TYPE_XYZ)) {
            this.setFitTypesEnabled(true, false, true, false, true);
        } else if (fitType.equals(Destination.TYPE_FITR)) {
            this.setFitTypesEnabled(true, true, true, true, false);
        }
    }

    private void setFitTypesEnabled(boolean top, boolean bottom, boolean left, boolean right, boolean zoom) {
        this.topTextField.setEnabled(top);
        this.bottomTextField.setEnabled(bottom);
        this.leftTextField.setEnabled(left);
        this.rightTextField.setEnabled(right);
        this.zoomTextField.setEnabled(zoom);
    }

    private void applySelectedValue(JComboBox comboBox, Object value) {
        comboBox.removeItemListener(this);
        for (int i = 0; i < comboBox.getItemCount(); ++i) {
            ValueLabelItem currentItem = (ValueLabelItem)comboBox.getItemAt(i);
            if (!currentItem.getValue().equals(value)) continue;
            comboBox.setSelectedIndex(i);
            break;
        }
        comboBox.addItemListener(this);
    }
}

