/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.annotation;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.annotations.FreeTextAnnotation;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.utility.annotation.AnnotationPanelAdapter;
import org.icepdf.ri.common.utility.annotation.ValueLabelItem;
import org.icepdf.ri.common.views.AnnotationComponent;
import org.icepdf.ri.common.views.annotations.FreeTextAnnotationComponent;

public class FreeTextAnnotationPanel
extends AnnotationPanelAdapter
implements ItemListener,
ActionListener {
    private static final int DEFAULT_FONT_SIZE = 5;
    private static final int DEFAULT_FONT_FAMILY = 0;
    private static final Color DEFAULT_FONT_COLOR = Color.DARK_GRAY;
    public static final int DEFAULT_STROKE_THICKNESS_STYLE = 0;
    public static final int DEFAULT_STROKE_STYLE = 0;
    public static final int DEFAULT_FILL_STYLE = 0;
    private static final Color DEFAULT_BORDER_COLOR = Color.LIGHT_GRAY;
    private static final Color DEFAULT_STROKE_COLOR = new Color(1, 1, 1);
    private static ValueLabelItem[] FONT_NAMES_LIST;
    private static ValueLabelItem[] FONT_SIZES_LIST;
    private FreeTextAnnotation freeTextAnnotation;
    private JComboBox fontNameBox;
    private JComboBox fontSizeBox;
    private JButton fontColorButton;
    private JComboBox fillTypeBox;
    private JButton fillColorButton;
    private JComboBox strokeTypeBox;
    private JComboBox strokeThicknessBox;
    private JComboBox strokeStyleBox;
    private JButton strokeColorButton;

    public FreeTextAnnotationPanel(SwingController controller) {
        super(controller);
        this.setLayout(new GridLayout(9, 2, 5, 2));
        this.setFocusable(true);
        this.createGUI();
        this.setEnabled(false);
        this.revalidate();
    }

    @Override
    public void setAnnotationComponent(AnnotationComponent newAnnotation) {
        if (newAnnotation == null || newAnnotation.getAnnotation() == null) {
            this.setEnabled(false);
            return;
        }
        this.currentAnnotationComponent = newAnnotation;
        FreeTextAnnotationComponent freeTextAnnotationComponent = (FreeTextAnnotationComponent)this.currentAnnotationComponent;
        this.freeTextAnnotation = (FreeTextAnnotation)freeTextAnnotationComponent.getAnnotation();
        this.applySelectedValue(this.fontNameBox, this.freeTextAnnotation.getFontName());
        this.applySelectedValue(this.fontSizeBox, this.freeTextAnnotation.getFontSize());
        this.fontColorButton.setBackground(this.freeTextAnnotation.getFontColor());
        this.applySelectedValue(this.strokeTypeBox, this.freeTextAnnotation.isStrokeType());
        this.applySelectedValue(this.strokeStyleBox, this.freeTextAnnotation.getBorderStyle().getBorderStyle());
        this.applySelectedValue(this.strokeThicknessBox, Float.valueOf(this.freeTextAnnotation.getBorderStyle().getStrokeWidth()));
        this.strokeColorButton.setBackground(this.freeTextAnnotation.getColor());
        this.applySelectedValue(this.fillTypeBox, this.freeTextAnnotation.isFillType());
        this.fillColorButton.setBackground(this.freeTextAnnotation.getFillColor());
        this.safeEnable(this.fontNameBox, true);
        this.safeEnable(this.fontSizeBox, true);
        this.safeEnable(this.fontColorButton, true);
        this.safeEnable(this.strokeTypeBox, true);
        this.safeEnable(this.strokeThicknessBox, true);
        this.safeEnable(this.strokeStyleBox, true);
        this.safeEnable(this.strokeColorButton, true);
        this.safeEnable(this.fillTypeBox, true);
        this.safeEnable(this.fillColorButton, true);
        this.disableInvisibleFields();
    }

    private void disableInvisibleFields() {
        boolean fillType = this.freeTextAnnotation.isFillType();
        boolean strokeType = this.freeTextAnnotation.isStrokeType();
        this.safeEnable(this.fillColorButton, fillType);
        this.safeEnable(this.strokeThicknessBox, strokeType);
        this.safeEnable(this.strokeStyleBox, strokeType);
        this.safeEnable(this.strokeColorButton, strokeType);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ValueLabelItem item = (ValueLabelItem)e.getItem();
        if (e.getStateChange() == 1) {
            if (e.getSource() == this.fontNameBox) {
                this.freeTextAnnotation.setFontName((String)item.getValue());
            } else if (e.getSource() == this.fontSizeBox) {
                this.freeTextAnnotation.setFontSize((Integer)item.getValue());
            } else if (e.getSource() == this.strokeTypeBox) {
                Boolean visible = (Boolean)item.getValue();
                this.freeTextAnnotation.setStrokeType(visible);
                if (visible.booleanValue()) {
                    this.freeTextAnnotation.getBorderStyle().setStrokeWidth(((Float)((ValueLabelItem)this.strokeThicknessBox.getSelectedItem()).getValue()).floatValue());
                    this.freeTextAnnotation.getBorderStyle().setBorderStyle((Name)((ValueLabelItem)this.strokeStyleBox.getSelectedItem()).getValue());
                } else {
                    this.freeTextAnnotation.getBorderStyle().setStrokeWidth(0.0f);
                }
                this.disableInvisibleFields();
            } else if (e.getSource() == this.strokeStyleBox) {
                this.freeTextAnnotation.getBorderStyle().setBorderStyle((Name)item.getValue());
            } else if (e.getSource() == this.strokeThicknessBox) {
                this.freeTextAnnotation.getBorderStyle().setStrokeWidth(((Float)item.getValue()).floatValue());
            } else if (e.getSource() == this.fillTypeBox) {
                this.freeTextAnnotation.setFillType((Boolean)item.getValue());
                if (this.freeTextAnnotation.isFillType()) {
                    this.freeTextAnnotation.setFillColor(this.fillColorButton.getBackground());
                }
                this.disableInvisibleFields();
            }
            this.updateCurrentAnnotation();
            this.currentAnnotationComponent.resetAppearanceShapes();
            this.currentAnnotationComponent.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Color chosenColor;
        if (e.getSource() == this.strokeColorButton) {
            Color chosenColor2 = JColorChooser.showDialog(this.strokeColorButton, this.messageBundle.getString("viewer.utilityPane.annotation.freeText.border.color.ChooserTitle"), this.strokeColorButton.getBackground());
            if (chosenColor2 != null) {
                this.strokeColorButton.setBackground(chosenColor2);
                this.freeTextAnnotation.setColor(chosenColor2);
            }
        } else if (e.getSource() == this.fillColorButton) {
            Color chosenColor3 = JColorChooser.showDialog(this.fillColorButton, this.messageBundle.getString("viewer.utilityPane.annotation.freeText.fill.color.ChooserTitle"), this.fillColorButton.getBackground());
            if (chosenColor3 != null) {
                this.fillColorButton.setBackground(chosenColor3);
                this.freeTextAnnotation.setFillColor(chosenColor3);
            }
        } else if (e.getSource() == this.fontColorButton && (chosenColor = JColorChooser.showDialog(this.fillColorButton, this.messageBundle.getString("viewer.utilityPane.annotation.freeText.font.color.ChooserTitle"), this.fontColorButton.getBackground())) != null) {
            this.fontColorButton.setBackground(chosenColor);
            this.freeTextAnnotation.setFontColor(chosenColor);
        }
        this.updateCurrentAnnotation();
        this.currentAnnotationComponent.resetAppearanceShapes();
        this.currentAnnotationComponent.repaint();
    }

    private void createGUI() {
        if (FONT_NAMES_LIST == null) {
            FONT_NAMES_LIST = new ValueLabelItem[]{new ValueLabelItem("Helvetica", "Helvetica"), new ValueLabelItem("Helvetica-Oblique", "Helvetica-Oblique"), new ValueLabelItem("Helvetica-Bold", "Helvetica-Bold"), new ValueLabelItem("Helvetica-BoldOblique", "Helvetica-BoldOblique"), new ValueLabelItem("Times-Italic", "Times-Italic"), new ValueLabelItem("Times-Bold", "Times-Bold"), new ValueLabelItem("Times-BoldItalic", "Times-BoldItalic"), new ValueLabelItem("Times-Roman", "Times-Roman"), new ValueLabelItem("Courier", "Courier"), new ValueLabelItem("Courier-Oblique", "Courier-Oblique"), new ValueLabelItem("Courier-BoldOblique", "Courier-BoldOblique"), new ValueLabelItem("Courier-Bold", "Courier-Bold"), new ValueLabelItem("Courier-Bold", "Courier-Bold")};
        }
        if (FONT_SIZES_LIST == null) {
            FONT_SIZES_LIST = new ValueLabelItem[]{new ValueLabelItem(6, this.messageBundle.getString("viewer.common.number.six")), new ValueLabelItem(8, this.messageBundle.getString("viewer.common.number.eight")), new ValueLabelItem(9, this.messageBundle.getString("viewer.common.number.nine")), new ValueLabelItem(10, this.messageBundle.getString("viewer.common.number.ten")), new ValueLabelItem(12, this.messageBundle.getString("viewer.common.number.twelve")), new ValueLabelItem(14, this.messageBundle.getString("viewer.common.number.fourteen")), new ValueLabelItem(16, this.messageBundle.getString("viewer.common.number.sixteen")), new ValueLabelItem(18, this.messageBundle.getString("viewer.common.number.eighteen")), new ValueLabelItem(20, this.messageBundle.getString("viewer.common.number.twenty")), new ValueLabelItem(24, this.messageBundle.getString("viewer.common.number.twentyFour")), new ValueLabelItem(36, this.messageBundle.getString("viewer.common.number.thirtySix")), new ValueLabelItem(48, this.messageBundle.getString("viewer.common.number.fortyEight"))};
        }
        this.setBorder(new TitledBorder(new EtchedBorder(1), this.messageBundle.getString("viewer.utilityPane.annotation.freeText.appearance.title"), 1, 0));
        this.fontNameBox = new JComboBox<ValueLabelItem>(FONT_NAMES_LIST);
        this.fontNameBox.setSelectedIndex(0);
        this.fontNameBox.addItemListener(this);
        this.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.freeText.font.name")));
        this.add(this.fontNameBox);
        this.fontSizeBox = new JComboBox<ValueLabelItem>(FONT_SIZES_LIST);
        this.fontSizeBox.setSelectedIndex(5);
        this.fontSizeBox.addItemListener(this);
        this.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.freeText.font.size")));
        this.add(this.fontSizeBox);
        this.fontColorButton = new JButton();
        this.fontColorButton.addActionListener(this);
        this.fontColorButton.setOpaque(true);
        this.fontColorButton.setBackground(DEFAULT_FONT_COLOR);
        this.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.freeText.font.color")));
        this.add(this.fontColorButton);
        this.strokeTypeBox = new JComboBox<ValueLabelItem>(VISIBLE_TYPE_LIST);
        this.strokeTypeBox.setSelectedIndex(0);
        this.strokeTypeBox.addItemListener(this);
        this.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.freeText.border.type")));
        this.add(this.strokeTypeBox);
        this.strokeThicknessBox = new JComboBox<ValueLabelItem>(LINE_THICKNESS_LIST);
        this.strokeThicknessBox.setSelectedIndex(0);
        this.strokeThicknessBox.addItemListener(this);
        this.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.freeText.border.thickness")));
        this.add(this.strokeThicknessBox);
        this.strokeStyleBox = new JComboBox<ValueLabelItem>(LINE_STYLE_LIST);
        this.strokeStyleBox.setSelectedIndex(0);
        this.strokeStyleBox.addItemListener(this);
        this.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.freeText.border.style")));
        this.add(this.strokeStyleBox);
        this.strokeColorButton = new JButton();
        this.strokeColorButton.addActionListener(this);
        this.strokeColorButton.setOpaque(true);
        this.strokeColorButton.setBackground(DEFAULT_BORDER_COLOR);
        this.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.freeText.border.color")));
        this.add(this.strokeColorButton);
        this.fillTypeBox = new JComboBox<ValueLabelItem>(VISIBLE_TYPE_LIST);
        this.fillTypeBox.setSelectedIndex(0);
        this.fillTypeBox.addItemListener(this);
        this.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.freeText.fill.type")));
        this.add(this.fillTypeBox);
        this.fillColorButton = new JButton();
        this.fillColorButton.addActionListener(this);
        this.fillColorButton.setOpaque(true);
        this.fillColorButton.setBackground(DEFAULT_STROKE_COLOR);
        this.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.freeText.fill.color")));
        this.add(this.fillColorButton);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.safeEnable(this.fontNameBox, enabled);
        this.safeEnable(this.fontSizeBox, enabled);
        this.safeEnable(this.fontColorButton, enabled);
        this.safeEnable(this.strokeTypeBox, enabled);
        this.safeEnable(this.strokeThicknessBox, enabled);
        this.safeEnable(this.strokeStyleBox, enabled);
        this.safeEnable(this.strokeColorButton, enabled);
        this.safeEnable(this.fillTypeBox, enabled);
        this.safeEnable(this.fillColorButton, enabled);
    }

    protected boolean safeEnable(JComponent comp, boolean enabled) {
        if (comp != null) {
            comp.setEnabled(enabled);
            return true;
        }
        return false;
    }

    private void applySelectedValue(JComboBox comboBox, Object value) {
        comboBox.removeItemListener(this);
        for (int i = 0; i < comboBox.getItemCount(); ++i) {
            ValueLabelItem currentItem = (ValueLabelItem)comboBox.getItemAt(i);
            if (!currentItem.getValue().equals(value)) continue;
            comboBox.setSelectedIndex(i);
            break;
        }
        comboBox.addItemListener(this);
    }
}

