/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.annotation;

import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.utility.annotation.AnnotationPanelAdapter;
import org.icepdf.ri.common.utility.annotation.ValueLabelItem;
import org.icepdf.ri.common.views.AnnotationComponent;

public class FlagsPanel
extends AnnotationPanelAdapter
implements ItemListener {
    private JComboBox readOnlyComboBox;
    private JComboBox noRotateComboBox;
    private JComboBox noZoomComboBox;
    private JComboBox printableComboBox;

    public FlagsPanel(SwingController controller) {
        super(controller);
        this.setLayout(new GridLayout(4, 2, 5, 2));
        this.setFocusable(true);
        this.createGUI();
        this.setEnabled(false);
        this.revalidate();
    }

    @Override
    public void setAnnotationComponent(AnnotationComponent annotationComponent) {
        if (annotationComponent == null || annotationComponent.getAnnotation() == null) {
            this.setEnabled(false);
            return;
        }
        this.currentAnnotationComponent = annotationComponent;
        Annotation annotation = this.currentAnnotationComponent.getAnnotation();
        this.noRotateComboBox.setSelectedIndex(annotation.getFlagNoRotate() ? 0 : 1);
        this.noZoomComboBox.setSelectedIndex(annotation.getFlagNoZoom() ? 0 : 1);
        this.readOnlyComboBox.setSelectedIndex(annotation.getFlagReadOnly() ? 0 : 1);
        this.printableComboBox.setSelectedIndex(annotation.getFlagPrint() ? 0 : 1);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if (source == this.noRotateComboBox) {
            this.currentAnnotationComponent.getAnnotation().setFlag(16, this.noRotateComboBox.getSelectedIndex() == 0);
        } else if (source == this.noZoomComboBox) {
            this.currentAnnotationComponent.getAnnotation().setFlag(8, this.noZoomComboBox.getSelectedIndex() == 0);
        } else if (source == this.readOnlyComboBox) {
            this.currentAnnotationComponent.getAnnotation().setFlag(64, this.readOnlyComboBox.getSelectedIndex() == 0);
        } else if (source == this.printableComboBox) {
            this.currentAnnotationComponent.getAnnotation().setFlag(4, this.printableComboBox.getSelectedIndex() == 0);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.noRotateComboBox.setEnabled(enabled);
        this.noZoomComboBox.setEnabled(enabled);
        this.readOnlyComboBox.setEnabled(enabled);
        this.printableComboBox.setEnabled(enabled);
    }

    private void createGUI() {
        this.setBorder(new TitledBorder(new EtchedBorder(1), this.messageBundle.getString("viewer.utilityPane.annotation.flags.title"), 1, 0));
        ValueLabelItem[] flagList = new ValueLabelItem[]{new ValueLabelItem(Boolean.TRUE, this.messageBundle.getString("viewer.utilityPane.annotation.flags.enabled")), new ValueLabelItem(Boolean.FALSE, this.messageBundle.getString("viewer.utilityPane.annotation.flags.disabled"))};
        this.noRotateComboBox = new JComboBox<ValueLabelItem>(flagList);
        this.noRotateComboBox.addItemListener(this);
        this.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.flags.noRotate")));
        this.add(this.noRotateComboBox);
        this.noZoomComboBox = new JComboBox<ValueLabelItem>(flagList);
        this.noZoomComboBox.addItemListener(this);
        this.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.flags.noZoom")));
        this.add(this.noZoomComboBox);
        this.readOnlyComboBox = new JComboBox<ValueLabelItem>(flagList);
        this.readOnlyComboBox.addItemListener(this);
        this.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.flags.readOnly")));
        this.add(this.readOnlyComboBox);
        this.printableComboBox = new JComboBox<ValueLabelItem>(flagList);
        this.printableComboBox.addItemListener(this);
        this.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.flags.printable")));
        this.add(this.printableComboBox);
    }
}

