/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.annotation;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.BorderStyle;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.utility.annotation.AnnotationPanelAdapter;
import org.icepdf.ri.common.utility.annotation.ValueLabelItem;
import org.icepdf.ri.common.views.AnnotationComponent;

public class BorderPanel
extends AnnotationPanelAdapter
implements ItemListener,
ActionListener {
    private static final int DEFAULT_LINK_TYPE = 1;
    private static final int DEFAULT_LINE_THICKNESS = 0;
    private static final int DEFAULT_LINE_STYLE = 0;
    private static final Color DEFAULT_BORDER_COLOR = Color.BLACK;
    private static ValueLabelItem[] LINE_STYLE_LIST;
    private JComboBox linkTypeBox;
    private JComboBox lineThicknessBox;
    private JComboBox lineStyleBox;
    private JButton colorButton;

    public BorderPanel(SwingController controller) {
        super(controller);
        this.setLayout(new GridLayout(4, 2, 5, 2));
        this.setFocusable(true);
        this.createGUI();
        this.setEnabled(false);
        this.revalidate();
    }

    @Override
    public void setAnnotationComponent(AnnotationComponent newAnnotation) {
        if (newAnnotation == null || newAnnotation.getAnnotation() == null) {
            this.setEnabled(false);
            return;
        }
        this.currentAnnotationComponent = newAnnotation;
        Annotation annotation = this.currentAnnotationComponent.getAnnotation();
        if (annotation.getLineThickness() == 0.0f) {
            this.applySelectedValue(this.linkTypeBox, 0);
        } else {
            this.applySelectedValue(this.linkTypeBox, 1);
        }
        this.applySelectedValue(this.lineThicknessBox, Float.valueOf(annotation.getLineThickness()));
        this.applySelectedValue(this.lineStyleBox, annotation.getLineStyle());
        this.colorButton.setBackground(annotation.getColor());
        this.enableAppearanceInputComponents(annotation.getBorderType() == 1);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Annotation annotation = this.currentAnnotationComponent.getAnnotation();
        ValueLabelItem item = (ValueLabelItem)e.getItem();
        if (e.getStateChange() == 1) {
            if (e.getSource() == this.linkTypeBox) {
                boolean linkVisible = (Boolean)item.getValue();
                if (linkVisible) {
                    annotation.getBorderStyle().setStrokeWidth(1.0f);
                    if (annotation.getColor() == null) {
                        annotation.setColor(Color.BLACK);
                    }
                } else {
                    annotation.getBorderStyle().setStrokeWidth(0.0f);
                }
                this.applySelectedValue(this.lineThicknessBox, Float.valueOf(annotation.getLineThickness()));
                this.enableAppearanceInputComponents(linkVisible);
            } else if (e.getSource() == this.lineThicknessBox) {
                float lineThickness = ((Float)item.getValue()).floatValue();
                annotation.getBorderStyle().setStrokeWidth(lineThickness);
            } else if (e.getSource() == this.lineStyleBox) {
                Name lineStyle = (Name)item.getValue();
                annotation.getBorderStyle().setBorderStyle(lineStyle);
            }
            this.updateCurrentAnnotation();
            this.currentAnnotationComponent.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Color chosenColor;
        Annotation annotation = this.currentAnnotationComponent.getAnnotation();
        if (e.getSource() == this.colorButton && (chosenColor = JColorChooser.showDialog(this.colorButton, this.messageBundle.getString("viewer.utilityPane.annotation.border.colorChooserTitle"), this.colorButton.getBackground())) != null) {
            this.colorButton.setBackground(chosenColor);
            annotation.setColor(chosenColor);
            this.updateCurrentAnnotation();
            this.currentAnnotationComponent.repaint();
        }
    }

    private void createGUI() {
        if (LINE_STYLE_LIST == null) {
            LINE_STYLE_LIST = new ValueLabelItem[]{new ValueLabelItem(BorderStyle.BORDER_STYLE_SOLID, this.messageBundle.getString("viewer.utilityPane.annotation.border.solid")), new ValueLabelItem(BorderStyle.BORDER_STYLE_DASHED, this.messageBundle.getString("viewer.utilityPane.annotation.border.dashed")), new ValueLabelItem(BorderStyle.BORDER_STYLE_BEVELED, this.messageBundle.getString("viewer.utilityPane.annotation.border.beveled")), new ValueLabelItem(BorderStyle.BORDER_STYLE_INSET, this.messageBundle.getString("viewer.utilityPane.annotation.border.inset")), new ValueLabelItem(BorderStyle.BORDER_STYLE_UNDERLINE, this.messageBundle.getString("viewer.utilityPane.annotation.border.underline"))};
        }
        this.setBorder(new TitledBorder(new EtchedBorder(1), this.messageBundle.getString("viewer.utilityPane.annotation.border.title"), 1, 0));
        this.linkTypeBox = new JComboBox<ValueLabelItem>(VISIBLE_TYPE_LIST);
        this.linkTypeBox.setSelectedIndex(1);
        this.linkTypeBox.addItemListener(this);
        this.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.border.linkType")));
        this.add(this.linkTypeBox);
        this.lineThicknessBox = new JComboBox<ValueLabelItem>(LINE_THICKNESS_LIST);
        this.lineThicknessBox.setSelectedIndex(0);
        this.lineThicknessBox.addItemListener(this);
        this.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.border.lineThickness")));
        this.add(this.lineThicknessBox);
        this.lineStyleBox = new JComboBox<ValueLabelItem>(LINE_STYLE_LIST);
        this.lineStyleBox.setSelectedIndex(0);
        this.lineStyleBox.addItemListener(this);
        this.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.border.lineStyle")));
        this.add(this.lineStyleBox);
        this.colorButton = new JButton();
        this.colorButton.addActionListener(this);
        this.colorButton.setOpaque(true);
        this.colorButton.setBackground(DEFAULT_BORDER_COLOR);
        this.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.border.colorLabel")));
        this.add(this.colorButton);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.safeEnable(this.linkTypeBox, enabled);
        this.safeEnable(this.lineThicknessBox, enabled);
        this.safeEnable(this.lineStyleBox, enabled);
        this.safeEnable(this.colorButton, enabled);
    }

    private void enableAppearanceInputComponents(boolean visible) {
        if (!visible) {
            this.safeEnable(this.linkTypeBox, true);
            this.safeEnable(this.lineThicknessBox, false);
            this.safeEnable(this.lineStyleBox, false);
            this.safeEnable(this.colorButton, false);
        } else {
            this.safeEnable(this.linkTypeBox, true);
            this.safeEnable(this.lineThicknessBox, true);
            this.safeEnable(this.lineStyleBox, true);
            this.safeEnable(this.colorButton, true);
        }
    }

    protected boolean safeEnable(JComponent comp, boolean enabled) {
        if (comp != null) {
            comp.setEnabled(enabled);
            return true;
        }
        return false;
    }

    private void applySelectedValue(JComboBox comboBox, Object value) {
        comboBox.removeItemListener(this);
        for (int i = 0; i < comboBox.getItemCount(); ++i) {
            ValueLabelItem currentItem = (ValueLabelItem)comboBox.getItemAt(i);
            if (!currentItem.getValue().equals(value)) continue;
            comboBox.setSelectedIndex(i);
            break;
        }
        comboBox.addItemListener(this);
    }
}

