/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.tools;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.icepdf.ri.common.tools.SelectionBoxHandler;
import org.icepdf.ri.common.tools.ToolHandler;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;

public class TextSelectionViewHandler
extends SelectionBoxHandler
implements ToolHandler {
    private static final Logger logger = Logger.getLogger(TextSelectionViewHandler.class.toString());
    protected JComponent parentComponent;

    public TextSelectionViewHandler(DocumentViewController documentViewController, DocumentViewModel documentViewModel, JComponent parentComponent) {
        super(documentViewController, null, documentViewModel);
        this.parentComponent = parentComponent;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.parentComponent != null) {
            this.parentComponent.requestFocus();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.documentViewController.clearSelectedText();
        this.resetRectangle(e.getX(), e.getY());
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.updateSelectionSize(e, this.parentComponent);
        ArrayList<WeakReference<AbstractPageViewComponent>> selectedPages = this.documentViewModel.getSelectedPageText();
        AbstractPageViewComponent pageComponent = this.isOverPageComponent(this.parentComponent, e);
        if (pageComponent != null) {
            MouseEvent modeEvent = SwingUtilities.convertMouseEvent(this.parentComponent, e, pageComponent);
            if (selectedPages != null && selectedPages.size() > 0) {
                for (WeakReference<AbstractPageViewComponent> page : selectedPages) {
                    AbstractPageViewComponent pageComp = (AbstractPageViewComponent)page.get();
                    if (pageComp == null) continue;
                    pageComp.dispatchEvent(modeEvent);
                }
            }
        }
        if (selectedPages != null && selectedPages.size() > 0) {
            this.documentViewController.firePropertyChange("textSelected", null, null);
        }
        if (selectedPages != null && selectedPages.size() > 0) {
            for (WeakReference<AbstractPageViewComponent> page : selectedPages) {
                AbstractPageViewComponent pageComp = (AbstractPageViewComponent)page.get();
                if (pageComp == null) continue;
                pageComp.clearSelectionRectangle();
            }
        }
        this.clearRectangle(this.parentComponent);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.documentViewController != null) {
            this.updateSelectionSize(e, this.parentComponent);
            this.documentViewModel.clearSelectedPageText();
            if (this.documentViewModel != null) {
                List<AbstractPageViewComponent> pages = this.documentViewModel.getPageComponents();
                for (AbstractPageViewComponent page : pages) {
                    Rectangle tmp = SwingUtilities.convertRectangle(this.parentComponent, this.getRectToDraw(), page);
                    if (!page.getBounds().intersects(tmp)) continue;
                    this.documentViewModel.addSelectedPageText(page);
                    Rectangle selectRec = SwingUtilities.convertRectangle(this.parentComponent, this.rectToDraw, page);
                    page.setSelectionRectangle(SwingUtilities.convertPoint(this.parentComponent, e.getPoint(), page), selectRec);
                }
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        AbstractPageViewComponent pageComponent = this.isOverPageComponent(this.parentComponent, e);
        if (pageComponent != null) {
            pageComponent.dispatchEvent(SwingUtilities.convertMouseEvent(this.parentComponent, e, pageComponent));
        }
    }

    @Override
    public void paintTool(Graphics g) {
    }

    @Override
    public void setSelectionRectangle(Point cursorLocation, Rectangle selection) {
    }

    @Override
    public void installTool() {
    }

    @Override
    public void uninstallTool() {
    }
}

