/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.tools;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.AnnotationFactory;
import org.icepdf.core.pobjects.annotations.BorderStyle;
import org.icepdf.core.pobjects.annotations.SquareAnnotation;
import org.icepdf.core.util.ColorUtil;
import org.icepdf.core.util.Defs;
import org.icepdf.ri.common.tools.SelectionBoxHandler;
import org.icepdf.ri.common.tools.ToolHandler;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.AnnotationCallback;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.annotations.AbstractAnnotationComponent;
import org.icepdf.ri.common.views.annotations.AnnotationComponentFactory;

public class SquareAnnotationHandler
extends SelectionBoxHandler
implements ToolHandler {
    private static final Logger logger;
    protected static final float DEFAULT_STROKE_WIDTH = 3.0f;
    protected static BasicStroke stroke;
    protected static Color lineColor;
    protected static Color internalColor;
    protected Rectangle rectangle;
    protected BorderStyle borderStyle = new BorderStyle();

    public SquareAnnotationHandler(DocumentViewController documentViewController, AbstractPageViewComponent pageViewComponent, DocumentViewModel documentViewModel) {
        super(documentViewController, pageViewComponent, documentViewModel);
        this.borderStyle.setStrokeWidth(3.0f);
    }

    @Override
    public void paintTool(Graphics g) {
        if (this.rectangle != null) {
            Graphics2D gg = (Graphics2D)g;
            Color oldColor = gg.getColor();
            Stroke oldStroke = gg.getStroke();
            gg.setStroke(stroke);
            gg.setColor(lineColor);
            gg.draw(this.rectangle);
            g.setColor(oldColor);
            gg.setStroke(oldStroke);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (this.rectangle == null) {
            this.rectangle = new Rectangle();
        }
        this.currentRect = new Rectangle(x, y, 0, 0);
        this.updateDrawableRect(this.pageViewComponent.getWidth(), this.pageViewComponent.getHeight());
        this.rectangle.setRect(this.currentRect);
        this.pageViewComponent.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.updateSelectionSize(e, this.pageViewComponent);
        this.rectangle = this.convertToPageSpace(this.rectangle);
        this.rectToDraw.setRect(this.rectToDraw.getX() - 3.0, this.rectToDraw.getY() - 3.0, this.rectToDraw.getWidth() + 6.0, this.rectToDraw.getHeight() + 6.0);
        Rectangle tBbox = this.convertToPageSpace(this.rectToDraw);
        SquareAnnotation annotation = (SquareAnnotation)AnnotationFactory.buildAnnotation(this.documentViewModel.getDocument().getPageTree().getLibrary(), Annotation.SUBTYPE_SQUARE, tBbox);
        annotation.setColor(lineColor);
        if (annotation.isFillColor()) {
            annotation.setFillColor(internalColor);
        }
        annotation.setRectangle(this.rectangle);
        annotation.setBorderStyle(this.borderStyle);
        annotation.setBBox(tBbox);
        annotation.resetAppearanceStream(this.getPageTransform());
        AbstractAnnotationComponent comp = AnnotationComponentFactory.buildAnnotationComponent(annotation, this.documentViewController, this.pageViewComponent, this.documentViewModel);
        Rectangle bbox = new Rectangle(this.rectToDraw.x, this.rectToDraw.y, this.rectToDraw.width, this.rectToDraw.height);
        comp.setBounds(bbox);
        comp.refreshAnnotationRect();
        if (this.documentViewController.getAnnotationCallback() != null) {
            AnnotationCallback annotationCallback = this.documentViewController.getAnnotationCallback();
            annotationCallback.newAnnotation(this.pageViewComponent, comp);
        }
        this.documentViewController.getParentController().setDocumentToolMode(6);
        this.rectangle = null;
        this.clearRectangle(this.pageViewComponent);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.pageViewComponent != null) {
            this.pageViewComponent.requestFocus();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void installTool() {
    }

    @Override
    public void uninstallTool() {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.updateSelectionSize(e, this.pageViewComponent);
        this.rectangle.setRect(this.rectToDraw);
        this.pageViewComponent.repaint();
    }

    protected Rectangle convertToPageSpace(Rectangle rect) {
        Page currentPage = this.pageViewComponent.getPage();
        AffineTransform at = currentPage.getPageTransform(this.documentViewModel.getPageBoundary(), this.documentViewModel.getViewRotation(), this.documentViewModel.getViewZoom());
        try {
            at = at.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            logger.log(Level.FINE, "Error converting to page space.", e);
        }
        Rectangle tBbox = new Rectangle(rect.x, rect.y, rect.width, rect.height);
        tBbox = at.createTransformedShape(tBbox).getBounds();
        return tBbox;
    }

    @Override
    public void setSelectionRectangle(Point cursorLocation, Rectangle selection) {
    }

    static {
        block5: {
            int colorValue;
            String color;
            block4: {
                logger = Logger.getLogger(SquareAnnotationHandler.class.toString());
                stroke = new BasicStroke(3.0f, 0, 0, 1.0f);
                try {
                    color = Defs.sysProperty("org.icepdf.core.views.page.annotation.squareCircle.stroke.color", "#ff0000");
                    colorValue = ColorUtil.convertColor(color);
                    lineColor = new Color(colorValue >= 0 ? colorValue : Integer.parseInt("ff0000", 16));
                }
                catch (NumberFormatException e) {
                    if (!logger.isLoggable(Level.WARNING)) break block4;
                    logger.warning("Error reading squareCircle Annotation stroke colour");
                }
            }
            try {
                color = Defs.sysProperty("org.icepdf.core.views.page.annotation.squareCircle.fill.color", "#ffffff");
                colorValue = ColorUtil.convertColor(color);
                internalColor = new Color(colorValue >= 0 ? colorValue : Integer.parseInt("ffffff", 16));
            }
            catch (NumberFormatException e) {
                if (!logger.isLoggable(Level.WARNING)) break block5;
                logger.warning("Error reading squareCircle Annotation fill colour");
            }
        }
    }
}

