/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.tools;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.logging.Logger;
import javax.swing.event.MouseInputListener;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.AnnotationFactory;
import org.icepdf.ri.common.tools.SelectionBoxHandler;
import org.icepdf.ri.common.tools.ToolHandler;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.AnnotationCallback;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.annotations.AbstractAnnotationComponent;
import org.icepdf.ri.common.views.annotations.AnnotationComponentFactory;

public class LinkAnnotationHandler
extends SelectionBoxHandler
implements ToolHandler,
MouseInputListener {
    private static final Logger logger = Logger.getLogger(LinkAnnotationHandler.class.toString());

    public LinkAnnotationHandler(DocumentViewController documentViewController, AbstractPageViewComponent pageViewComponent, DocumentViewModel documentViewModel) {
        super(documentViewController, pageViewComponent, documentViewModel);
        selectionBoxColour = Color.GRAY;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.pageViewComponent != null) {
            this.pageViewComponent.requestFocus();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        this.currentRect = new Rectangle(x, y, 0, 0);
        this.updateDrawableRect(this.pageViewComponent.getWidth(), this.pageViewComponent.getHeight());
        this.pageViewComponent.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.updateSelectionSize(e, this.pageViewComponent);
        if (this.rectToDraw.getWidth() < 5.0 || this.rectToDraw.getHeight() < 5.0) {
            this.rectToDraw.setSize(new Dimension(15, 25));
        }
        Rectangle tBbox = this.convertToPageSpace(this.rectToDraw).getBounds();
        Annotation annotation = AnnotationFactory.buildAnnotation(this.documentViewModel.getDocument().getPageTree().getLibrary(), Annotation.SUBTYPE_LINK, tBbox);
        AbstractAnnotationComponent comp = AnnotationComponentFactory.buildAnnotationComponent(annotation, this.documentViewController, this.pageViewComponent, this.documentViewModel);
        comp.setBounds(this.rectToDraw);
        comp.refreshAnnotationRect();
        if (this.documentViewController.getAnnotationCallback() != null) {
            AnnotationCallback annotationCallback = this.documentViewController.getAnnotationCallback();
            annotationCallback.newAnnotation(this.pageViewComponent, comp);
        }
        this.documentViewController.getParentController().setDocumentToolMode(6);
        this.clearRectangle(this.pageViewComponent);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.updateSelectionSize(e, this.pageViewComponent);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void installTool() {
    }

    @Override
    public void uninstallTool() {
    }

    @Override
    public void setSelectionRectangle(Point cursorLocation, Rectangle selection) {
    }

    @Override
    public void paintTool(Graphics g) {
        LinkAnnotationHandler.paintSelectionBox(g, this.rectToDraw);
    }
}

