/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class FileExtensionUtils {
    public static final String pdf = "pdf";
    public static final String svg = "svg";
    public static final String ps = "ps";
    public static final String txt = "txt";

    public static FileFilter getPDFFileFilter() {
        return new ExtensionFileFilter("Adobe PDF Files (*.pdf)", pdf);
    }

    public static FileFilter getTextFileFilter() {
        return new ExtensionFileFilter("Text Files (*.txt)", txt);
    }

    public static FileFilter getSVGFileFilter() {
        return new ExtensionFileFilter("SVG Files (*.svg)", svg);
    }

    public static String getExtension(File f) {
        return FileExtensionUtils.getExtension(f.getName());
    }

    public static String getExtension(String s) {
        String ext = null;
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    private static class ExtensionFileFilter
    extends FileFilter {
        private String description;
        private String extension;

        ExtensionFileFilter(String desc, String ext) {
            this.description = desc;
            this.extension = ext;
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String ext = FileExtensionUtils.getExtension(f);
            if (ext != null) {
                return ext.equals(this.extension);
            }
            return false;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

