/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.graphics.OptionalContentState;
import org.icepdf.core.pobjects.graphics.PaintTimer;
import org.icepdf.core.pobjects.graphics.commands.DrawCmd;
import org.icepdf.core.pobjects.graphics.commands.ImageDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.ShapesDrawCmd;
import org.icepdf.core.pobjects.graphics.text.PageText;
import org.icepdf.core.util.Defs;

public class Shapes {
    private static final Logger logger = Logger.getLogger(Shapes.class.toString());
    private static int shapesInitialCapacity = 5000;
    protected boolean paintAlpha = !Defs.sysPropertyBoolean("org.icepdf.core.paint.disableAlpha", false);
    private boolean interrupted;
    protected ArrayList<DrawCmd> shapes = new ArrayList(shapesInitialCapacity);
    protected OptionalContentState optionalContentState = new OptionalContentState();
    private Page parentPage;
    private PageText pageText = new PageText();

    public PageText getPageText() {
        return this.pageText;
    }

    public int getShapesCount() {
        if (this.shapes != null) {
            return this.shapes.size();
        }
        return 0;
    }

    public ArrayList<DrawCmd> getShapes() {
        return this.shapes;
    }

    public void add(ArrayList<DrawCmd> shapes) {
        shapes.addAll(shapes);
    }

    public void setPageParent(Page parent) {
        this.parentPage = parent;
    }

    public void add(DrawCmd drawCmd) {
        this.shapes.add(drawCmd);
    }

    public boolean isPaintAlpha() {
        return this.paintAlpha;
    }

    public void setPaintAlpha(boolean paintAlpha) {
        this.paintAlpha = paintAlpha;
    }

    public void paint(Graphics2D g) {
        try {
            AffineTransform base = new AffineTransform(g.getTransform());
            Shape clip = g.getClip();
            PaintTimer paintTimer = new PaintTimer();
            Shape previousShape = null;
            int max = this.shapes.size();
            for (int i = 0; i < max; ++i) {
                if (this.interrupted) {
                    this.interrupted = false;
                    break;
                }
                DrawCmd nextShape = this.shapes.get(i);
                previousShape = nextShape.paintOperand(g, this.parentPage, previousShape, clip, base, this.optionalContentState, this.paintAlpha, paintTimer);
            }
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Error painting shapes.", e);
        }
    }

    public void interruptPaint() {
        this.interrupted = true;
    }

    public ArrayList<Image> getImages() {
        ArrayList<Image> images = new ArrayList<Image>();
        for (DrawCmd object : this.shapes) {
            if (object instanceof ImageDrawCmd) {
                images.add(((ImageDrawCmd)object).getImage());
                continue;
            }
            if (!(object instanceof ShapesDrawCmd)) continue;
            images.addAll(((ShapesDrawCmd)object).getShapes().getImages());
        }
        return images;
    }

    public void contract() {
        if (this.shapes != null) {
            this.shapes.trimToSize();
        }
    }

    static {
        shapesInitialCapacity = Defs.sysPropertyInt("org.icepdf.core.shapes.initialCapacity", shapesInitialCapacity);
    }
}

