/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.graphics.PColorSpace;
import org.icepdf.core.util.Library;

public class CalRGB
extends PColorSpace {
    public static final Name WHITE_POINT_KEY = new Name("WhitePoint");
    public static final Name GAMMA_KEY = new Name("Gamma");
    public static final Name MATRIX_KEY = new Name("Matrix");
    public static final Name CALRGB_KEY = new Name("CalRGB");
    protected float[] whitepoint = new float[]{1.0f, 1.0f, 1.0f};
    protected float[] gamma = new float[]{1.0f, 1.0f, 1.0f};
    protected float[] matrix = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};

    CalRGB(Library l, HashMap h) {
        super(l, h);
        int i;
        List m = (List)h.get(WHITE_POINT_KEY);
        if (m != null) {
            for (i = 0; i < 3; ++i) {
                this.whitepoint[i] = ((Number)m.get(i)).floatValue();
            }
        }
        if ((m = (List)h.get(GAMMA_KEY)) != null) {
            for (i = 0; i < 3; ++i) {
                this.gamma[i] = ((Number)m.get(i)).floatValue();
            }
        }
        if ((m = (List)h.get(MATRIX_KEY)) != null) {
            for (i = 0; i < 9; ++i) {
                this.matrix[i] = ((Number)m.get(i)).floatValue();
            }
        }
    }

    @Override
    public int getNumComponents() {
        return 3;
    }

    @Override
    public Color getColor(float[] f, boolean fillAndStroke) {
        return new Color(f[2], f[1], f[0]);
    }
}

