/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.io;

import java.io.IOException;
import java.io.InputStream;

public class SizeInputStream
extends InputStream {
    private InputStream in = null;
    private int size = 0;
    private int bytesRead = 0;

    public SizeInputStream(InputStream in, int size) {
        this.in = in;
        this.size = size;
    }

    @Override
    public int available() {
        return this.size - this.bytesRead;
    }

    @Override
    public int read() throws IOException {
        int b = this.in.read();
        if (b != -1) {
            ++this.bytesRead;
        }
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int read = this.in.read(b);
        this.bytesRead += read;
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.in.read(b, off, len);
        this.bytesRead += read;
        return read;
    }
}

