/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.rmi.encoded;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.logging.Logger;

public class EncodedOutputStream
extends FilterOutputStream {
    private SecureRandom random;
    private boolean encrypt = true;

    public EncodedOutputStream(OutputStream unencodedStream, byte[] seed) {
        super(unencodedStream);
        try {
            this.random = SecureRandom.getInstance("SHA1PRNG");
            this.random.setSeed(seed);
            StringBuilder hexString = new StringBuilder();
            for (byte b : seed) {
                hexString.append(Integer.toHexString(b & 0xFF));
            }
            Logger.getLogger(this.getClass().getCanonicalName()).finer("EncodedOutputStream seed: " + hexString);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    public void setEncrypt(boolean g) {
        this.encrypt = g;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.encrypt) {
            int rni = this.random.nextInt();
            int e = (b ^ rni) & 0xFF;
            Logger.getLogger(this.getClass().getCanonicalName()).finest("Writing " + Integer.toHexString(b & 0xFF) + ", encoded as " + Integer.toHexString(e & 0xFF) + " rni " + rni);
            this.out.write(e);
        } else {
            this.out.write(b);
        }
    }
}

