/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.rmi.encoded;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.logging.Logger;

public class EncodedInputStream
extends FilterInputStream {
    private SecureRandom random;
    private boolean encrypt = true;

    public void setEncrypt(boolean b) {
        this.encrypt = b;
    }

    public EncodedInputStream(InputStream encodedStream, byte[] seed) {
        super(encodedStream);
        try {
            this.random = SecureRandom.getInstance("SHA1PRNG");
            this.random.setSeed(seed);
            StringBuilder hexString = new StringBuilder();
            for (byte b : seed) {
                hexString.append(Integer.toHexString(b & 0xFF));
            }
            Logger.getLogger(this.getClass().getCanonicalName()).finer("EncodedInputStream seed: " + hexString);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int read() throws IOException {
        if (this.encrypt) {
            int b = this.in.read();
            if (b == -1) {
                return b;
            }
            int rni = this.random.nextInt();
            int u = (b ^ rni) & 0xFF;
            Logger.getLogger(this.getClass().getCanonicalName()).finest("Reading " + Integer.toHexString(b & 0xFF) + ", decoded as " + Integer.toHexString(u & 0xFF) + " rni " + rni);
            return u;
        }
        return this.in.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.encrypt) {
            int numBytes = this.in.read(b, off, len);
            if (numBytes <= 0) {
                return numBytes;
            }
            for (int i = 0; i < numBytes; ++i) {
                int rni = this.random.nextInt();
                int u = (b[off + i] ^ rni) & 0xFF;
                Logger.getLogger(this.getClass().getCanonicalName()).finest("Reading " + Integer.toHexString(b[off + i] & 0xFF) + ", decoded as " + Integer.toHexString(u & 0xFF) + " rni " + rni);
                b[off + i] = (byte)u;
            }
            return numBytes;
        }
        return this.in.read(b, off, len);
    }
}

