/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.reflect;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarException;
import java.util.jar.JarFile;

public class ClassFinder {
    public static <T> T getInstance(Class<T> c) {
        Object returnElement = null;
        try {
            Method m = c.getMethod("sharedInstance", null);
            if (c.isAssignableFrom(m.getReturnType())) {
                returnElement = m.invoke(null, (Object[])null);
            }
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        try {
            if (returnElement == null) {
                returnElement = c.newInstance();
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return (T)returnElement;
    }

    public static <T> List<Class<T>> findImplementors(Class<T> interfaceClass) {
        String[] classPaths = System.getProperty("java.class.path").split(";");
        Vector<Class<T>> returnList = new Vector<Class<T>>();
        for (String classPath : classPaths) {
            System.out.println("Searching " + classPath);
            File f = new File(classPath);
            if (f.isDirectory()) {
                try {
                    ClassFinder.traverseDirectory(f, f, returnList, interfaceClass);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            try {
                JarFile jf = new JarFile(f);
                Enumeration<JarEntry> entries = jf.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
                    String className = entry.getName().replaceAll("/", ".").substring(0, entry.getName().length() - 6);
                    ClassFinder.testClass(className, returnList, interfaceClass);
                }
            }
            catch (JarException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return returnList;
    }

    private static <T> void traverseDirectory(File dir, File baseDirectory, List<Class<T>> list, Class<T> interfaceClass) throws IOException {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                ClassFinder.traverseDirectory(f, baseDirectory, list, interfaceClass);
                continue;
            }
            if (!f.getName().endsWith(".class")) continue;
            String className = f.getCanonicalPath().substring(baseDirectory.getCanonicalPath().length(), f.getCanonicalPath().length() - 6);
            String separator = System.getProperty("file.separator").replaceAll("\\\\", "\\\\\\\\");
            if ((className = className.replaceAll(separator, ".")).startsWith(".")) {
                className = className.substring(1);
            }
            ClassFinder.testClass(className, list, interfaceClass);
        }
    }

    private static <T> void testClass(String className, List<Class<T>> list, Class<T> interfaceClass) {
        try {
            Class<?>[] interfaces;
            Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(className);
            if (clazz.isInterface()) {
                return;
            }
            for (Class<?> iface : interfaces = clazz.getInterfaces()) {
                if (!iface.equals(interfaceClass)) continue;
                list.add(clazz);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

