/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.parser2;

import java.util.List;
import se.sjobeck.parser2.BinaryOperation;
import se.sjobeck.parser2.Function;
import se.sjobeck.parser2.NumberOperation;
import se.sjobeck.parser2.Operation;
import se.sjobeck.parser2.UnaryOperation;

public class OperationFactory {
    private static char[] prefixUnaryOperators = new char[]{'\u221a'};
    private static char[] binaryOperators = new char[]{'+', '-', '*', '/', ':', '^'};

    public static synchronized Operation parse(String s, List<Function> ... vars) {
        s = OperationFactory.trimParenthesis(s);
        try {
            double value = Double.parseDouble(s.trim());
            return new NumberOperation(value);
        }
        catch (Exception e) {
            int i;
            if (s.trim().equals("\u03c0")) {
                return new NumberOperation(Math.PI);
            }
            if (OperationFactory.variableExists(s, vars)) {
                return new NumberOperation(OperationFactory.variableValue(s, vars));
            }
            int parenthesisLevel = 0;
            int[] breakpoints = new int[binaryOperators.length];
            for (i = 0; i < breakpoints.length; ++i) {
                breakpoints[i] = -1;
            }
            for (i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                int index = -1;
                if (c == '(') {
                    ++parenthesisLevel;
                    continue;
                }
                if (c == ')') {
                    --parenthesisLevel;
                    continue;
                }
                if (parenthesisLevel != 0 || (index = OperationFactory.isBinaryOperator(c)) < 0) continue;
                breakpoints[index] = i;
            }
            for (i = 0; i < breakpoints.length; ++i) {
                if (breakpoints[i] <= 0) continue;
                try {
                    Operation left = OperationFactory.parse(s.substring(0, breakpoints[i]), vars);
                    Operation right = OperationFactory.parse(s.substring(breakpoints[i] + 1), vars);
                    return new BinaryOperation(binaryOperators[i], left, right);
                }
                catch (IllegalArgumentException e2) {
                    throw new IllegalArgumentException("Could not parse partial expression '" + s + "'");
                }
            }
            if (OperationFactory.isPrefixUnaryOperator(s.charAt(0)) != -1) {
                return new UnaryOperation(s.charAt(0), OperationFactory.parse(s.substring(1), vars));
            }
            throw new IllegalArgumentException("Could not parse partial expression '" + s + "'");
        }
    }

    private static int isPrefixUnaryOperator(char c) {
        for (int i = 0; i < prefixUnaryOperators.length; ++i) {
            if (prefixUnaryOperators[i] != c) continue;
            return i;
        }
        return -1;
    }

    private static int isBinaryOperator(char c) {
        for (int i = 0; i < binaryOperators.length; ++i) {
            if (binaryOperators[i] != c) continue;
            return i;
        }
        return -1;
    }

    private static String trimParenthesis(String s) {
        if (s == null || s.equals("")) {
            throw new IllegalArgumentException("No function defined!");
        }
        if (s.charAt(0) == '(' && s.charAt(s.length() - 1) == ')') {
            int parenthesisLevel = 1;
            for (int i = 1; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == '(') {
                    ++parenthesisLevel;
                    continue;
                }
                if (c != ')' || --parenthesisLevel != 0) continue;
                if (i == s.length() - 1) {
                    return OperationFactory.trimParenthesis(s.substring(1, s.length() - 1).trim());
                }
                return s;
            }
            throw new IllegalArgumentException("Unbalanced parentheses in '" + s + "'");
        }
        return s;
    }

    private static boolean variableExists(String s, List<Function> ... vars) {
        for (List<Function> varList : vars) {
            for (int i = 0; i < varList.size(); ++i) {
                if (!varList.get(i).getIdentifier().equalsIgnoreCase(s)) continue;
                return true;
            }
        }
        return false;
    }

    private static double variableValue(String s, List<Function> ... vars) {
        for (List<Function> varList : vars) {
            for (int i = 0; i < varList.size(); ++i) {
                if (!varList.get(i).getIdentifier().equalsIgnoreCase(s)) continue;
                return varList.get(i).getValue(vars);
            }
        }
        throw new IllegalArgumentException("Variable '" + s + "' has no value");
    }
}

