/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.List;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import se.sjobeck.gui.TwoInputDialog;

public final class DialogCreator {
    public static void showInformation(Component parent, Object message, String title) {
        JOptionPane.showMessageDialog(parent, message, title, 1);
    }

    private DialogCreator() {
    }

    public static void showError(Object message, String title) {
        JOptionPane.showMessageDialog(null, message, title, 0);
    }

    public static void showInformation(Object message, String title) {
        DialogCreator.showInformation(null, message, title);
    }

    public static boolean showConfirm(Object message, String title) {
        return DialogCreator.showConfirm(null, message, title);
    }

    public static boolean showConfirm(Component parent, Object message, String title) {
        int showConfirmDialog = JOptionPane.showConfirmDialog(parent, message, title, 0);
        return showConfirmDialog == 0;
    }

    public static String showQuestion(Object message, String title) {
        String showInputDialog = JOptionPane.showInputDialog(null, message, title, 3);
        return showInputDialog;
    }

    public static File showFileChooser(String approveButtonText, List<String> fileExtensionsToFilter) {
        int showDialog;
        JFileChooser fc = new JFileChooser();
        if (fileExtensionsToFilter != null && fileExtensionsToFilter.size() > 1) {
            String[] a = new String[1];
            fc.setFileFilter(new FileNameExtensionFilter(fileExtensionsToFilter.get(0), fileExtensionsToFilter.subList(1, fileExtensionsToFilter.size()).toArray(a)));
        }
        if ((showDialog = fc.showDialog(null, approveButtonText)) == 0) {
            return fc.getSelectedFile();
        }
        return null;
    }

    public static File showFileChooser(String approveButtonText, List<String> fileExtensionsToFilter, String selectedFile) {
        JFileChooser fc = new JFileChooser();
        if (fileExtensionsToFilter != null && fileExtensionsToFilter.size() > 1) {
            String[] a = new String[1];
            fc.setFileFilter(new FileNameExtensionFilter(fileExtensionsToFilter.get(0), fileExtensionsToFilter.subList(1, fileExtensionsToFilter.size()).toArray(a)));
        }
        fc.setSelectedFile(new File(selectedFile));
        int showDialog = fc.showDialog(null, approveButtonText);
        if (showDialog == 0) {
            return fc.getSelectedFile();
        }
        return null;
    }

    public static Point2D showDeltaMoveDialog(JFrame jFrame) {
        TwoInputDialog tid = new TwoInputDialog((Frame)jFrame, true);
        tid.setVisible(true);
        if (tid.isOk()) {
            return tid.getDeltaMove();
        }
        return new Point2D.Double(0.0, 0.0);
    }

    public static void main(String[] args) {
        DialogCreator.testShowQuestion();
        DialogCreator.testShowFileChooser();
    }

    private static void testShowQuestion() {
        System.out.println(DialogCreator.showQuestion("test str\u00e4ng", "en fr\u00e5ga"));
        System.out.println(DialogCreator.showQuestion(new JLabel("fnurr"), "en fr\u00e5ga"));
    }

    private static void testShowFileChooser() {
        Vector<String> fudo = new Vector<String>();
        System.out.println(DialogCreator.showFileChooser("hej svejs, jag \u00e4r b\u00e4st! alla filer kan v\u00e4ljas", null));
        System.out.println(DialogCreator.showFileChooser("alla filer igen med tom lista", fudo));
        fudo.add("filter-namn");
        System.out.println(DialogCreator.showFileChooser("n\u00e4stan tom lista", fudo));
        fudo.add("jpg");
        System.out.println(DialogCreator.showFileChooser("jpg", fudo));
        fudo.add("png");
        fudo.add("pdf");
        System.out.println(DialogCreator.showFileChooser("jpg png pdf", fudo));
    }
}

