/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.digitizer;

import java.io.IOException;
import java.io.InputStream;
import se.sjobeck.digitizer.DigitizerDriver;
import se.sjobeck.digitizer.DigitizerEvent;
import se.sjobeck.digitizer.ReaderThread;
import se.sjobeck.digitizer.serial.SerialPortDigitizer;

class SerialPortReaderThread
extends ReaderThread {
    private InputStream in = null;
    private boolean newData = false;
    private SerialPortDigitizer digitizer = null;
    private byte[] buffer = new byte[1024];
    private int bytes = 0;

    SerialPortReaderThread() {
        super("SerialPortReaderThread");
    }

    @Override
    public String getDescription() {
        return this.digitizer.getDescription();
    }

    public void setDigitizer(SerialPortDigitizer digitizer) {
        this.digitizer = digitizer;
        this.setFrameSize(digitizer.getFrameSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!SerialPortReaderThread.interrupted()) {
            try {
                SerialPortReaderThread serialPortReaderThread = this;
                synchronized (serialPortReaderThread) {
                    this.wait();
                    if (this.in != null && this.newData) {
                        this.newData = false;
                        this.readData();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public synchronized void setInputStream(InputStream in) {
        this.in = in;
        this.resetBuffer();
    }

    public synchronized void dataAvailable() {
        this.newData = true;
        this.notifyAll();
    }

    public byte[] getBuffer() {
        byte[] ret = new byte[this.bytes];
        System.arraycopy(this.buffer, 0, ret, 0, this.bytes);
        return ret;
    }

    public void resetBuffer() {
        this.bytes = 0;
    }

    public synchronized void setFrameSize(int size) {
        this.buffer = new byte[size];
        this.bytes = 0;
    }

    private void readData() {
        try {
            while (this.in.available() > 0) {
                this.bytes += this.in.read(this.buffer, this.bytes, this.buffer.length - this.bytes);
                if (this.bytes <= 0) continue;
                if (this.bytes > this.buffer.length) {
                    System.out.println("Input buffer overflow!");
                    this.bytes = 0;
                    continue;
                }
                if (this.bytes != this.buffer.length || this.digitizer == null) continue;
                DigitizerEvent ev = this.digitizer.generateEvent(this.buffer);
                DigitizerDriver.postEvent(ev);
                this.bytes = 0;
            }
        }
        catch (IOException ex) {
            System.out.println("Cannot read input stream!");
        }
    }
}

