/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.digitizer;

import java.awt.geom.Point2D;
import se.sjobeck.digitizer.DigitizerEvent;

public class IPDigitizerEvent
implements DigitizerEvent {
    private long x;
    private long y;
    private int linesPerInch;
    private int button;
    private long timestamp;

    public IPDigitizerEvent(long x, long y, int lpi, int button) {
        this.x = x;
        this.y = y;
        this.linesPerInch = lpi;
        this.button = button;
        this.timestamp = System.currentTimeMillis();
    }

    @Override
    public long getTimeStamp() {
        return this.timestamp;
    }

    @Override
    public boolean buttonIsSet(int buttonNr) {
        return (this.button & buttonNr) > 0;
    }

    @Override
    public int getRawButton() {
        return this.button;
    }

    @Override
    public Point2D getPointInMillimeters() {
        double xcoord = (double)this.x / (double)this.linesPerInch * 25.4;
        double ycoord = (double)this.y / (double)this.linesPerInch * 25.4;
        return new Point2D.Double(xcoord, ycoord);
    }

    @Override
    public Point2D getPointInInches() {
        double xcoord = (double)this.x / (double)this.linesPerInch;
        double ycoord = (double)this.y / (double)this.linesPerInch;
        return new Point2D.Double(xcoord, ycoord);
    }

    @Override
    public long getRawX() {
        return this.x;
    }

    @Override
    public long getRawY() {
        return this.y;
    }

    @Override
    public String toString() {
        return "Inch-Pound DigitizerEvent[x=" + this.x + ", y=" + this.y + ", button=" + this.button + ", linesPerInch=" + this.linesPerInch + "]";
    }
}

