/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.fonts.nfont;

import java.awt.Color;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.fonts.nfont.CMap;
import org.icepdf.core.pobjects.fonts.nfont.Encoding;
import org.icepdf.core.pobjects.fonts.nfont.NFont;
import org.icepdf.core.pobjects.fonts.nfont.NFontTrueType;
import org.icepdf.core.pobjects.fonts.nfont.NFontType1;
import org.icepdf.core.pobjects.fonts.nfont.c.a;
import org.icepdf.core.pobjects.fonts.nfont.c.e;
import org.icepdf.core.pobjects.fonts.nfont.k;
import org.icepdf.core.pobjects.fonts.nfont.l;
import org.icepdf.core.pobjects.fonts.nfont.m;

public class NFontOpenType
extends NFontTrueType
implements Cloneable {
    private static final Logger logger = Logger.getLogger(NFontOpenType.class.toString());
    public static final String FORMAT = "OpenType";
    public static final String SUBFORMAT_CFF = "CFF";
    private static final int TAG_OTTO = e.a("OTTO");
    private static final int TAG_MORX = e.a("morx");
    private NFontType1 cff_;
    private int glyphcnt_ = -1;
    private boolean flayout_;
    private l kern_;

    public NFontOpenType(URL uRL) {
        super(uRL);
    }

    public NFontOpenType(byte[] byArray) {
        super(byArray);
    }

    protected void parse() {
        this.flayout_ = false;
        this.kern_ = null;
        super.parse();
        if (TAG_OTTO == this.getID()) {
            if (this.getTableDirectory(1735162214) != null) {
                throw new IllegalStateException();
            }
            m m2 = this.getTableDirectory(1128678944);
            try {
                this.cff_ = new NFontType1(this.ra_, m2.c, m2.d);
            }
            catch (FontFormatException fontFormatException) {
                // empty catch block
            }
            this.cff_.widths_ = this.widths_;
            this.cff_ = (NFontType1)this.cff_.deriveFont(Encoding.IDENTITY, CMap.IDENTITY);
        } else {
            this.cff_ = null;
        }
    }

    public NFont deriveFont(float f2) {
        NFontOpenType nFontOpenType = (NFontOpenType)super.deriveFont(f2);
        if (SUBFORMAT_CFF == this.getSubformat()) {
            nFontOpenType.cff_ = (NFontType1)this.cff_.deriveFont(f2);
        }
        return nFontOpenType;
    }

    public NFont deriveFont(AffineTransform affineTransform) {
        NFontOpenType nFontOpenType = (NFontOpenType)super.deriveFont(affineTransform);
        if (SUBFORMAT_CFF == this.getSubformat()) {
            nFontOpenType.cff_ = (NFontType1)this.cff_.deriveFont(affineTransform);
        }
        return nFontOpenType;
    }

    public k deriveFont(float[] fArray, int n2, int n3, int n4, int n5, Rectangle2D rectangle2D) {
        NFontOpenType nFontOpenType = (NFontOpenType)super.deriveFont(fArray, n2, n3, n4, n5, rectangle2D);
        if (SUBFORMAT_CFF == this.getSubformat()) {
            nFontOpenType.cff_ = (NFontType1)this.cff_.deriveFont(fArray, n2, n3, n4, n5, rectangle2D);
        }
        return nFontOpenType;
    }

    public String getFormat() {
        return FORMAT;
    }

    public String getSubformat() {
        return this.cff_ != null ? SUBFORMAT_CFF : super.getSubformat();
    }

    public boolean isHinted() {
        return SUBFORMAT_CFF == this.getSubformat() ? this.cff_.isHinted() : super.isHinted();
    }

    public int getNumGlyphs() {
        if (this.glyphcnt_ == -1) {
            this.glyphcnt_ = SUBFORMAT_CFF == this.getSubformat() ? this.cff_.getNumGlyphs() : super.getNumGlyphs();
        }
        return this.glyphcnt_;
    }

    private void readLayoutTables() {
        if (this.flayout_) {
            return;
        }
        this.flayout_ = true;
        if (this != this.ur_) {
            NFontOpenType nFontOpenType = (NFontOpenType)this.ur_;
            nFontOpenType.readLayoutTables();
            this.kern_ = nFontOpenType.kern_;
        } else {
            this.kern_ = new l(this);
        }
    }

    private void readGSUBTable() {
        int n2;
        int n3;
        int n4;
        if (this.getTable(1196643650).length < 10) {
            return;
        }
        float f2 = this.readFixed();
        int n5 = this.readUint16();
        int n6 = this.readUint16();
        int n7 = this.readUint16();
        this.setOffset(n5);
        int n8 = this.readUint16();
        for (n4 = 0; n4 < n8; ++n4) {
            n3 = this.readUint32();
            n2 = this.readUint16();
            if (!logger.isLoggable(Level.FINER)) continue;
            logger.finer("script: " + e.a(n3) + " " + Integer.toHexString(n3) + " @ " + n2);
        }
        this.setOffset(n6);
        n8 = this.readUint16();
        for (n4 = 0; n4 < n8; ++n4) {
            n3 = this.readUint32();
            n2 = this.readUint16();
            if (!logger.isLoggable(Level.FINER)) continue;
            logger.finer("feature: " + e.a(n3) + " " + Integer.toHexString(n3) + " @ " + n2);
        }
    }

    private void readFeatTable() {
        if (this.getTable(1717920116).length < 10) {
            return;
        }
        float f2 = this.readFixed();
        int n2 = this.readUint16();
        this.skip(6);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this.getOffset();
            int n4 = this.readUint16();
            int n5 = this.readUint16();
            int n6 = this.readUint32();
            int n7 = this.readUint16();
            int n8 = this.readInt16();
        }
    }

    private void readMortTable() {
        if (this.getTable(1836020340).length < 6) {
            return;
        }
        float f2 = this.readFixed();
        int n2 = this.readUint32();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this.getOffset();
            int n4 = this.readUint32();
            int n5 = this.readUint32();
            int n6 = this.readUint16();
            int n7 = this.readUint16();
            int n8 = n4;
            for (int i3 = 0; i3 < n6; ++i3) {
                int n9 = this.readUint16();
                int n10 = this.readUint16();
                int n11 = this.readUint32();
                int n12 = this.readUint32();
                if (!logger.isLoggable(Level.FINER)) continue;
                logger.finer("mort feature type = " + n9 + ", setting = " + n10);
            }
            this.setOffset(n3 + n5);
        }
    }

    private void readMorxTable() {
        if (this.getTable(TAG_MORX).length < 6) {
            return;
        }
    }

    Shape getGlyph(int n2) {
        return SUBFORMAT_CFF == this.getSubformat() ? this.cff_.getGlyph(n2) : super.getGlyph(n2);
    }

    private int[] estr2glyphs(String string, long l2) {
        this.readLayoutTables();
        int n2 = string.length();
        int[] nArray = new int[n2 * 3];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            char c3 = this.c2g_.toSelector(c2);
            nArray[n3++] = c3;
        }
        if ((0x20L & l2) != 0L) {
            // empty if block
        }
        return a.a(nArray, n3);
    }

    private int[] gsub() {
        return null;
    }

    private int[] gpos() {
        return null;
    }

    public int getKern(int n2, int n3) {
        return this.kern_ != null ? this.kern_.a(n2, n3) : 0;
    }

    public void drawEstring(Graphics2D graphics2D, String string, float f2, float f3, long l2, int n2, Color color) {
        if (SUBFORMAT_CFF == this.getSubformat()) {
            this.cff_.drawEstring(graphics2D, this.c2g_.toSelector(string), f2, f3, l2, n2, color);
        } else {
            super.drawEstring(graphics2D, string, f2, f3, l2, n2, color);
        }
    }
}

