/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.util;

import java.awt.Component;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import javax.swing.JOptionPane;
import se.sjobeck.parser2.Function;

public class StaticHelpers {
    private static FileFilter geometraFileFilter = null;
    private static FileFilter geometraProjectFileFilter = null;
    public static final char[] unsafe = new char[]{'\\', '/', ':', '?', '*', '\"', '<', '>', '|', '+', '[', ']', '(', ')'};
    private static DecimalFormat num = new DecimalFormat("###,###");
    private static DecimalFormat smallNum = new DecimalFormat("###,##0.00");
    private static DecimalFormat tidFormat = new DecimalFormat("###,###");

    public static String getExtraResourcesDirectoryName() {
        return ".extra_project_resources";
    }

    public static String getXML_DatabasName() {
        return ".xml_databas";
    }

    public static String getBakFileExtensioin() {
        return ".bak";
    }

    public static boolean approveStringAsFileOrDirectorySafe(String in) {
        if (in.length() < 1) {
            return false;
        }
        for (char c : unsafe) {
            if (in.indexOf(c) <= -1) continue;
            return false;
        }
        return !in.endsWith(StaticHelpers.getBakFileExtensioin());
    }

    public static boolean inTrash(File f) {
        if (f.getName().equals(".trash")) {
            return true;
        }
        if (f.getParentFile() == null) {
            return false;
        }
        return StaticHelpers.inTrash(f.getParentFile());
    }

    public static double toDouble(String in) {
        char[] toCharArray = in.toCharArray();
        StringBuffer g = new StringBuffer();
        String test = "-0123456789.,";
        for (char c : toCharArray) {
            if (test.indexOf(c) <= -1) continue;
            if (c == ',') {
                c = '.';
            }
            g.append(c);
        }
        return Double.valueOf(g.toString());
    }

    public static FileFilter getGeometraProjectFileFilter() {
        if (geometraProjectFileFilter == null) {
            geometraProjectFileFilter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    if (pathname == null) {
                        return false;
                    }
                    if (pathname.isDirectory()) {
                        File[] listFiles = pathname.listFiles(new FileFilter(){

                            @Override
                            public boolean accept(File pathname) {
                                if (pathname == null) {
                                    return false;
                                }
                                return pathname.getName().toLowerCase().endsWith(".geo");
                            }
                        });
                        return listFiles != null && listFiles.length > 0;
                    }
                    return false;
                }
            };
        }
        return geometraProjectFileFilter;
    }

    public static FileFilter getGeometraFileFilter() {
        if (geometraFileFilter == null) {
            geometraFileFilter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return !pathname.isDirectory() && (pathname.getName().toLowerCase().endsWith(".pdf") || pathname.getName().toLowerCase().endsWith(".geo") || pathname.getName().toLowerCase().equals(".versiontracker"));
                }
            };
        }
        return geometraFileFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized byte[] getFileContent(File f) {
        FileInputStream fis = null;
        byte[] data = null;
        try {
            int i;
            fis = new FileInputStream(f);
            Vector<Byte> vec = new Vector<Byte>();
            byte[] nix = new byte[1024];
            int k = fis.read(nix);
            while (k != -1) {
                for (i = 0; i < k; ++i) {
                    vec.add(new Byte(nix[i]));
                }
                k = fis.read(nix);
            }
            data = new byte[vec.size()];
            for (i = 0; i < vec.size(); ++i) {
                data[i] = (Byte)vec.get(i);
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(StaticHelpers.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(StaticHelpers.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(StaticHelpers.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return data;
    }

    public static synchronized long getCRC(byte[] data) {
        if (data == null) {
            return -1L;
        }
        CRC32 crc = new CRC32();
        crc.update(data);
        return crc.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized long getCRC(File f) {
        FileInputStream file = null;
        FilterInputStream check = null;
        BufferedInputStream in = null;
        try {
            file = new FileInputStream(f);
            check = new CheckedInputStream(file, new CRC32());
            in = new BufferedInputStream(check);
            while (in.read() != -1) {
            }
            long l = ((CheckedInputStream)check).getChecksum().getValue();
            return l;
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(StaticHelpers.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(StaticHelpers.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (file != null) {
                    file.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(StaticHelpers.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (check != null) {
                try {
                    check.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(StaticHelpers.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(StaticHelpers.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return -1L;
    }

    public static String fixhtmltags(String str) {
        StringBuilder sb = new StringBuilder();
        String[] moo = str.split(" ");
        int max = 30;
        int n = 0;
        for (String m : moo) {
            sb.append(m + " ");
            if ((n += m.length()) <= max) continue;
            n = 0;
            sb.append("<br>");
        }
        return sb.toString();
    }

    public static void warn(String message) {
        StaticHelpers.warn(message, null);
    }

    public static void warn(String message, Component parent) {
        JOptionPane.showMessageDialog(parent, message, ResourceBundle.getBundle("se/sjobeck/Bibliotek").getString("ERROR_MESSAGE"), 0);
    }

    public static void message(String message) {
        JOptionPane.showMessageDialog(null, message, ResourceBundle.getBundle("se/sjobeck/Bibliotek").getString("MESSAGE"), 1);
    }

    public static String format(double tal) {
        if (Double.isNaN(tal)) {
            return "<Fel i formel>";
        }
        return num.format(tal);
    }

    public static String format2Dec(double tal) {
        if (Double.isNaN(tal)) {
            return "<Fel i formel>";
        }
        if (tal < 100.0) {
            return smallNum.format(tal);
        }
        return num.format(tal);
    }

    public static String formatPercent(double tal) {
        if (Double.isNaN(tal)) {
            return "<Fel i formel>";
        }
        return smallNum.format(tal * 100.0) + "%";
    }

    public static String tidFormat(double tid) {
        if (Double.isInfinite(tid)) {
            return "-:--";
        }
        if (Double.isNaN(tid)) {
            return "<Fel i formel>";
        }
        if (tid < 0.0) {
            int tim = (int)(tid *= -1.0);
            int min = (int)((tid - (double)tim) * 60.0);
            return "-" + tidFormat.format(tim) + ":" + (min < 10 ? "0" : "") + min;
        }
        int tim = (int)tid;
        int min = (int)((tid - (double)tim) * 60.0);
        return tidFormat.format(tim) + ":" + (min < 10 ? "0" : "") + min;
    }

    public static void center(Component w) {
        w.setLocation(Math.max(0, (Toolkit.getDefaultToolkit().getScreenSize().width - w.getSize().width) / 2), Math.max(0, (Toolkit.getDefaultToolkit().getScreenSize().height - w.getSize().height) / 2));
    }

    public static double parseDouble(String s) {
        return Function.getValue(s);
    }

    public static Vector<Long> MakeDatabaseFileNamesToLongs(Vector<String> fudo) {
        Vector<Long> fido = new Vector<Long>();
        for (String in : fudo) {
            if (in.length() <= 7) continue;
            try {
                long parseLong = Long.parseLong(in.substring(0, in.length() - 7));
                fido.add(parseLong);
            }
            catch (Exception e) {}
        }
        return fido;
    }
}

