/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.rmi.encoded;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import se.sjobeck.rmi.encoded.EncodedInputStream;
import se.sjobeck.rmi.encoded.EncodedOutputStream;
import se.sjobeck.rmi.encoded.EncodedSocket;

class ClientEncodedSocket
extends EncodedSocket {
    private byte[] sharedSecret;
    private byte[] id;

    ClientEncodedSocket(byte[] id, byte[] sharedSecret, String host, int port) throws IOException {
        super(host, port);
        this.sharedSecret = sharedSecret;
        this.id = id;
    }

    ClientEncodedSocket() {
    }

    @Override
    protected synchronized void performHandshake() throws IOException {
        OutputStream unencodedOut = super.getRawOutputStream();
        InputStream unencodedIn = super.getRawInputStream();
        unencodedOut.write(this.id.length);
        unencodedOut.write(this.id);
        byte[] keyBytes = new byte[this.sharedSecret.length];
        int read_bytes = unencodedIn.read(keyBytes);
        byte[] peerKey = new byte[this.sharedSecret.length];
        for (int i = 0; i < this.sharedSecret.length; ++i) {
            peerKey[i] = (byte)(this.sharedSecret[i] ^ keyBytes[i]);
        }
        this.encodedOut = new EncodedOutputStream(unencodedOut, peerKey);
        byte[] myKey = new byte[this.sharedSecret.length];
        generator.nextBytes(myKey);
        this.encodedOut.write(myKey);
        this.encodedIn = new EncodedInputStream(unencodedIn, myKey);
    }
}

