/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.network;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import se.sjobeck.network.VirtualFileSystem;

public class VirtualFile
extends File {
    private static final long serialVersionUID = 8394032705762727204L;
    private boolean traversible;
    private boolean hidden;
    private List<VirtualFile> children = Collections.emptyList();
    private VirtualFile parent;
    private long lastModified;
    private long fileSize;
    private static VirtualFileSystem fs;

    public VirtualFile(File dir) {
        this(dir, (VirtualFile)null);
    }

    public VirtualFile(File dir, VirtualFile vparent) {
        super(dir.getAbsolutePath());
        this.parent = vparent;
        this.setup(dir);
    }

    public void setVirtualFileSystem(VirtualFileSystem vfs) {
        fs = vfs;
    }

    private void setup(File dir) {
        this.lastModified = dir.lastModified();
        this.fileSize = dir.length();
        this.traversible = dir.isDirectory();
        this.hidden = dir.isHidden();
        if (this.traversible) {
            this.children = new ArrayList<VirtualFile>();
            this.fillChildren(dir);
        }
    }

    private void fillChildren(File dir) {
        File[] list = dir.listFiles();
        if (list == null || list.length == 0) {
            return;
        }
        for (File f : list) {
            if (!f.exists()) continue;
            this.children.add(new VirtualFile(f, this));
        }
    }

    public VirtualFile find(File f) {
        if (this.equals(f)) {
            return this;
        }
        if (this.traversible) {
            for (int i = 0; i < this.children.size(); ++i) {
                VirtualFile vf = this.children.get(i);
                VirtualFile ret = vf.find(f);
                if (ret == null) continue;
                return ret;
            }
        }
        return null;
    }

    @Override
    public File[] listFiles() {
        return this.children.toArray(new VirtualFile[this.children.size()]);
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    @Override
    public int compareTo(File pathname) {
        if (pathname == null) {
            return -1;
        }
        return this.getAbsolutePath().compareTo(pathname.getAbsolutePath());
    }

    @Override
    public boolean createNewFile() throws IOException {
        return false;
    }

    @Override
    public boolean delete() {
        if (fs == null) {
            return super.delete();
        }
        return fs.removeFile(this);
    }

    @Override
    public void deleteOnExit() {
        if (fs == null) {
            super.deleteOnExit();
        } else {
            fs.removeFile(this);
        }
    }

    @Override
    public boolean equals(Object obj) {
        return this.compareTo((File)obj) == 0;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public File getAbsoluteFile() {
        return this;
    }

    @Override
    public String getAbsolutePath() {
        return super.getAbsolutePath();
    }

    @Override
    public File getCanonicalFile() throws IOException {
        return this;
    }

    @Override
    public String getCanonicalPath() throws IOException {
        return super.getCanonicalPath();
    }

    @Override
    public String getName() {
        return super.getName();
    }

    @Override
    public String getParent() {
        if (this.parent != null) {
            return this.parent.getPath();
        }
        return null;
    }

    @Override
    public File getParentFile() {
        return this.parent;
    }

    @Override
    public String getPath() {
        return super.getPath();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean isAbsolute() {
        return true;
    }

    @Override
    public boolean isDirectory() {
        return this.traversible;
    }

    @Override
    public boolean isFile() {
        return !this.traversible;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public long lastModified() {
        return this.lastModified;
    }

    @Override
    public long length() {
        return this.fileSize;
    }

    @Override
    public String[] list() {
        File[] arr = this.listFiles();
        String[] ret = new String[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            ret[i] = arr[i].getName();
        }
        return ret;
    }

    @Override
    public String[] list(FilenameFilter filter) {
        return super.list(filter);
    }

    @Override
    public File[] listFiles(FileFilter filter) {
        return super.listFiles(filter);
    }

    @Override
    public File[] listFiles(FilenameFilter filter) {
        return super.listFiles(filter);
    }

    @Override
    public boolean mkdir() {
        return super.mkdir();
    }

    @Override
    public boolean mkdirs() {
        return super.mkdirs();
    }

    @Override
    public boolean renameTo(File dest) {
        if (fs == null) {
            return super.renameTo(dest);
        }
        return fs.renameFile(this, dest);
    }

    @Override
    public boolean setLastModified(long time) {
        return super.setLastModified(time);
    }

    @Override
    public boolean setReadOnly() {
        return super.setReadOnly();
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public URI toURI() {
        return super.toURI();
    }

    @Override
    public URL toURL() throws MalformedURLException {
        return super.toURL();
    }
}

