/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import se.sjobeck.datastructures.TlgStruct;
import se.sjobeck.util.StaticHelpers;

public class CheckBoxList
extends JList {
    static final long serialVersionUID = 0L;
    private static TlgStruct tillagg;
    private static boolean inomhus;

    public CheckBoxList() {
        this.setCellRenderer(new CheckBoxRenderer());
        this.setSelectionModel(new CheckBoxListSelectionModel());
        inomhus = true;
    }

    public static void setInomhus(boolean b) {
        inomhus = b;
    }

    private class CheckBoxRenderer
    extends JCheckBox
    implements ListCellRenderer {
        static final long serialVersionUID = 0L;

        CheckBoxRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
            this.setText(value.toString());
            tillagg = (TlgStruct)value;
            this.setEnabled(tillagg.isInomhus() && inomhus || tillagg.isUtomhus() && !inomhus);
            this.setSelected(isSelected);
            return this;
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            if (tillagg != null) {
                return "<html>Avtalstext:<br>" + StaticHelpers.fixhtmltags(tillagg.getAvtalsText()) + "<br><br>Kommentar:<br>" + StaticHelpers.fixhtmltags(tillagg.getKommentar()) + "</html>";
            }
            return null;
        }
    }

    private class CheckBoxListSelectionModel
    extends DefaultListSelectionModel {
        static final long serialVersionUID = 0L;

        private CheckBoxListSelectionModel() {
        }

        @Override
        public void setSelectionInterval(int index0, int index1) {
            if (index0 == index1 && this.isSelectedIndex(index0)) {
                super.removeSelectionInterval(index0, index1);
            } else {
                super.addSelectionInterval(index0, index1);
            }
        }
    }
}

