/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class BackgroundImagePanel
extends JPanel {
    static final long serialVersionUID = 0L;
    private BufferedImage image;
    private RenderingStyle style;
    private float alignmentX = 0.5f;
    private float alignmentY = 0.5f;

    public BackgroundImagePanel(BufferedImage image) {
        this(image, RenderingStyle.TILED);
    }

    public BackgroundImagePanel(BufferedImage image, RenderingStyle style) {
        this.style = style;
        this.setImage(image);
    }

    public void setImage(BufferedImage image) {
        this.image = image;
        if (this.style == RenderingStyle.ACTUAL && image != null) {
            super.setPreferredSize(new Dimension(image.getWidth(), image.getHeight()));
        }
    }

    public void setImageAlignmentX(float alignmentX) {
        this.alignmentX = alignmentX > 1.0f ? 1.0f : (alignmentX < 0.0f ? 0.0f : alignmentX);
    }

    public void setImageAlignmentY(float alignmentY) {
        this.alignmentY = alignmentY > 1.0f ? 1.0f : (alignmentY < 0.0f ? 0.0f : alignmentY);
    }

    public void add(JComponent component) {
        this.add(component, null);
    }

    public void add(JComponent component, Object constraints) {
        component.setOpaque(false);
        if (component instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)component;
            JViewport viewport = scrollPane.getViewport();
            viewport.setOpaque(false);
            Component c = viewport.getView();
            if (c instanceof JComponent) {
                ((JComponent)c).setOpaque(false);
            }
        }
        super.add((Component)component, constraints);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.image == null) {
            return;
        }
        switch (this.style) {
            case TILED: {
                this.drawTiled(g);
                break;
            }
            case SCALED: {
                Dimension d = this.getSize();
                g.drawImage(this.image, 0, 0, d.width, d.height, null);
                break;
            }
            case ACTUAL: 
            case CROPPED: {
                this.drawActual(g);
            }
        }
    }

    private void drawTiled(Graphics g) {
        Dimension d = this.getSize();
        int width = this.image.getWidth(null);
        int height = this.image.getHeight(null);
        for (int x = 0; x < d.width; x += width) {
            for (int y = 0; y < d.height; y += height) {
                g.drawImage(this.image, x, y, null, null);
            }
        }
    }

    private void drawActual(Graphics g) {
        Dimension d = this.getSize();
        float x = (float)(d.width - this.image.getWidth()) * this.alignmentX;
        float y = (float)(d.height - this.image.getHeight()) * this.alignmentY;
        g.drawImage(this.image, (int)x, (int)y, this);
    }

    public static enum RenderingStyle {
        TILED,
        SCALED,
        ACTUAL,
        CROPPED;

    }
}

