/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.digitizer.usb;

import se.sjobeck.digitizer.DigitizerEvent;
import se.sjobeck.digitizer.IPDigitizerEvent;
import se.sjobeck.digitizer.usb.HidData;
import se.sjobeck.digitizer.usb.HidDevice;
import se.sjobeck.digitizer.usb.USBDigitizer;

public class RollUpUSB
implements USBDigitizer {
    @Override
    public boolean matchesSignature(HidDevice dev) {
        return dev.getVendorID() == 1932 && dev.getProductID() == 770 && dev.getProductVersion() == 272;
    }

    @Override
    public DigitizerEvent generateEvent(HidData[] inData) {
        if (inData[1].getButtonUsages() == 1 && inData[1].getButtonUsage(0) == 50) {
            if (inData[0].getButtonUsages() != 0) {
                return new IPDigitizerEvent(inData[6].getScaledValue(), inData[7].getScaledValue(), 1000, inData[0].getButtonUsage(0));
            }
            return new IPDigitizerEvent(inData[6].getScaledValue(), inData[7].getScaledValue(), 1000, 0);
        }
        if (inData[5].getButtonUsages() == 1 && inData[5].getButtonUsage(0) == 50) {
            if (inData[4].getButtonUsages() == 1) {
                return new IPDigitizerEvent(inData[10].getScaledValue(), inData[11].getScaledValue(), 1000, inData[4].getButtonUsage(0));
            }
            if (inData[4].getButtonUsages() == 2) {
                return new IPDigitizerEvent(inData[10].getScaledValue(), inData[11].getScaledValue(), 1000, 3);
            }
            return new IPDigitizerEvent(inData[10].getScaledValue(), inData[11].getScaledValue(), 1000, 0);
        }
        return null;
    }

    @Override
    public String getDescription() {
        return "Generic Roll-Up (Usb)";
    }
}

