/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.datastructures.kalkylering;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import se.sjobeck.database.Database;
import se.sjobeck.datastructures.TlgStruct;
import se.sjobeck.datastructures.kalkylering.Fabrikat;
import se.sjobeck.datastructures.kalkylering.RadHanterare;
import se.sjobeck.datastructures.kalkylering.RadStruct;
import se.sjobeck.datastructures.kalkylering.TimprisStruct;
import se.sjobeck.datastructures.kalkylering.UE_OvrigaKostnader;

public class ProjektInfo
implements Serializable {
    public static final long serialVersionUID = 0L;
    private long today;
    protected TimprisStruct timpris = null;
    protected TlgStruct[] globalaTillagg = new TlgStruct[0];
    protected Fabrikat fabrikat;
    private transient boolean nybyggnad;
    protected transient RadHanterare radHanterare = null;
    protected Map<RadStruct, Double> egnaTider = null;
    private boolean utlandsTraktamente;
    private List<UE_OvrigaKostnader> ue_vec = new Vector<UE_OvrigaKostnader>();
    private double ackPrisProcent = 1.0;

    public synchronized void setUtlandsTraktamente(boolean u_trakt) {
        this.utlandsTraktamente = u_trakt;
    }

    public synchronized boolean getUtlandsTraktamente() {
        return this.utlandsTraktamente;
    }

    private Object readResolve() {
        this.radHanterare = null;
        if (this.timpris != null) {
            this.timpris.setOwner(this);
        }
        if (this.ue_vec == null) {
            this.ue_vec = new Vector<UE_OvrigaKostnader>();
        }
        return this;
    }

    public double getEgenTid(RadStruct struct) {
        Double d = this.getEgenTid().get(struct);
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    public void putEgenTid(RadStruct struct, double value) {
        this.getEgenTid().put(struct, value);
    }

    public void removeEgenTid(RadStruct struct) {
        this.getEgenTid().remove(struct);
    }

    protected Map<RadStruct, Double> getEgenTid() {
        if (this.egnaTider == null) {
            this.egnaTider = new HashMap<RadStruct, Double>();
        }
        return this.egnaTider;
    }

    public TimprisStruct getTimprisStruct() {
        if (this.timpris == null) {
            this.timpris = new TimprisStruct(this);
        }
        return this.timpris;
    }

    public void setGlobalaTillagg(TlgStruct[] ny) {
        Logger.getLogger("se.sjobeck").entering("Projekt", "setGlobalaTillagg");
        this.globalaTillagg = ny;
        this.getRadHanterare().conditionsChanged();
    }

    public TlgStruct[] getGlobalaTillagg() {
        return this.globalaTillagg;
    }

    public Fabrikat getFabrikat() {
        if (this.fabrikat == null) {
            return Fabrikat.Nordsj\u00f6;
        }
        return this.fabrikat;
    }

    public void setFabrikat(Fabrikat f) {
        this.fabrikat = f;
        this.getRadHanterare().conditionsChanged();
    }

    public RadHanterare getRadHanterare() {
        if (this.radHanterare == null) {
            this.radHanterare = new RadHanterare(this);
        }
        return this.radHanterare;
    }

    public double getCustomMatpris(String behKod) {
        return Double.NaN;
    }

    public double getCustomAckpris(String behKod) {
        return Double.NaN;
    }

    public Database getDatabaseInstance() {
        return Database.getLatest();
    }

    public void addUEOK(UE_OvrigaKostnader ueok) {
        this.check_UEOK_container();
        this.ue_vec.add(ueok);
    }

    public void removeUEOK(UE_OvrigaKostnader ueok) {
        this.check_UEOK_container();
        this.ue_vec.remove(ueok);
    }

    public int getNumberOfUEOK() {
        this.check_UEOK_container();
        return this.ue_vec.size();
    }

    public UE_OvrigaKostnader getUEOK(int index) {
        this.check_UEOK_container();
        return this.ue_vec.get(index);
    }

    private void check_UEOK_container() {
        if (this.ue_vec == null) {
            this.ue_vec = new Vector<UE_OvrigaKostnader>();
        }
    }

    public double getUEOKPris() {
        this.check_UEOK_container();
        double pris = 0.0;
        for (UE_OvrigaKostnader ueok : this.ue_vec) {
            pris += ueok.getPris();
        }
        return pris;
    }

    public double getAckprisProcent() {
        return this.ackPrisProcent;
    }

    public void setAckPrisProcent(double ackPrisProcent) {
        this.ackPrisProcent = ackPrisProcent;
    }
}

