/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.datastructures.kalkylering;

import java.util.Map;
import se.sjobeck.datastructures.kalkylering.Fabrikat;

public class Behandling
implements Comparable<Behandling> {
    private String id;
    private String beskrivning;
    private String enhet;
    private Map<String, Double> ackordspunkter;
    private double ackpris;
    private Map<Fabrikat, Map<String, Double>> material;

    public Behandling() {
    }

    public Behandling(String id, String text, String enhet, double ackpris, Map<String, Double> ackord, Map<Fabrikat, Map<String, Double>> material) {
        this.id = id;
        this.beskrivning = text;
        this.enhet = enhet;
        this.ackordspunkter = ackord;
        this.ackpris = ackpris;
        this.material = material;
    }

    public double getAckpris() {
        return this.ackpris;
    }

    public String toString() {
        return this.id;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.beskrivning;
    }

    public String getFullDescription() {
        if (!this.ackordspunkter.isEmpty()) {
            return this.beskrivning + "\n" + this.ackordspunkter;
        }
        return this.beskrivning + "\n" + "{Inga ackordspunkter}";
    }

    public boolean equals(Object o) {
        return o instanceof Behandling && ((Behandling)o).id.equals(this.id);
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + (this.id != null ? this.id.hashCode() : 0);
        return hash;
    }

    @Override
    public int compareTo(Behandling o) {
        return this.id.compareTo(o.id);
    }

    public Map<String, Double> getAckordspunkter() {
        return this.ackordspunkter;
    }

    public Map<Fabrikat, Map<String, Double>> getMaterial() {
        return this.material;
    }

    public String getEnhet() {
        return this.enhet;
    }
}

