/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.xml.xmp;

import com.itextpdf.text.pdf.PdfAConformanceLevel;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.xml.xmp.PdfASchema;
import com.itextpdf.text.xml.xmp.XmpSchema;
import com.itextpdf.text.xml.xmp.XmpWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfAXmpWriter
extends XmpWriter {
    public PdfAXmpWriter(OutputStream os, PdfDictionary info, PdfAConformanceLevel conformanceLevel) throws IOException {
        super(os, info);
        this.addRdfDescription(conformanceLevel);
    }

    public PdfAXmpWriter(OutputStream os, Map<String, String> info, PdfAConformanceLevel conformanceLevel) throws IOException {
        super(os, info);
        this.addRdfDescription(conformanceLevel);
    }

    private void addRdfDescription(PdfAConformanceLevel conformanceLevel) throws IOException {
        PdfASchema schema = new PdfASchema();
        switch (conformanceLevel) {
            case PDF_A_1A: {
                schema.addPart("1");
                schema.addConformance("A");
                break;
            }
            case PDF_A_1B: {
                schema.addPart("1");
                schema.addConformance("B");
                break;
            }
            case PDF_A_2A: {
                schema.addPart("2");
                schema.addConformance("A");
                break;
            }
            case PDF_A_2B: {
                schema.addPart("2");
                schema.addConformance("B");
                break;
            }
            case PDF_A_2U: {
                schema.addPart("2");
                schema.addConformance("U");
                break;
            }
            case PDF_A_3A: {
                schema.addPart("3");
                schema.addConformance("A");
                break;
            }
            case PDF_A_3B: {
                schema.addPart("3");
                schema.addConformance("B");
                break;
            }
            case PDF_A_3U: {
                schema.addPart("3");
                schema.addConformance("U");
                break;
            }
        }
        super.addRdfDescription((XmpSchema)schema);
    }
}

