/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.fonts.nfont;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.fonts.CMap;
import org.icepdf.core.pobjects.fonts.Encoding;
import org.icepdf.core.pobjects.fonts.FontFile;
import org.icepdf.core.pobjects.fonts.nfont.c.i;
import org.icepdf.core.util.Defs;

public abstract class NFont
implements FontFile {
    private static final Logger logger = Logger.getLogger(NFont.class.toString());
    public static final int FLAG_NONE = Integer.MIN_VALUE;
    public static final int FLAG_FIXEDPITCH = 1;
    public static final int FLAG_SERIF = 2;
    public static final int FLAG_SANSSERIF = 0;
    public static final int FLAG_SYMBOLIC = 4;
    public static final int FLAG_SCRIPT = 8;
    public static final int FLAG_NONSYMBOLIC = 32;
    public static final int FLAG_ITALIC = 64;
    public static final int FLAG_ALLCAP = 65536;
    public static final int FLAG_SMALLCAP = 131072;
    public static final int FLAG_FORCEBOLD = 262144;
    public static final int FLAG_CONDENSED = 0x10000000;
    public static final int FLAG_EXPANDED = 0x20000000;
    public static final int FLAG_ORNAMENTAL = 0x40000000;
    public static final int FLAG_DEFAULT = 2;
    public static final int WEIGHT_THIN = 100;
    public static final int WEIGHT_EXTRALIGHT = 200;
    public static final int WEIGHT_LIGHT = 300;
    public static final int WEIGHT_NORMAL = 400;
    public static final int WEIGHT_MEDIUM = 500;
    public static final int WEIGHT_SEMIBOLD = 600;
    public static final int WEIGHT_BOLD = 700;
    public static final int WEIGHT_EXTRABOLD = 800;
    public static final int WEIGHT_BLACK = 900;
    public static final int MODE_FILL = 0;
    public static final int MODE_STROKE = 1;
    public static final int MODE_FILL_STROKE = 2;
    public static final int MODE_INVISIBLE = 3;
    public static final int MODE_FILL_ADD = 4;
    public static final int MODE_STROKE_ADD = 5;
    public static final int MODE_FILL_STROKE_ADD = 6;
    public static final int MODE_ADD = 7;
    public static final int MODE_INVALID = -1;
    public static final int RIGHT_INSTALL = 0;
    public static final int RIGHT_LICENSED = 1;
    public static final int RIGHT_RESTRICTED = 2;
    public static final int RIGHT_PREVIEW_PRINT = 4;
    public static final int RIGHT_EDITABLE = 8;
    public static final int RIGHT_NOSUBSET = 256;
    public static final int RIGHT_BITMAP = 512;
    public static final int RIGHT_NONCOMMERCIAL = 65536;
    public static final int RIGHT_HEURISTIC = 131072;
    public static final int RIGHT_UNKNOWN = -1;
    public static final long LAYOUT_NONE = 0L;
    public static final long LAYOUT_FALLBACK = 1L;
    public static final long LAYOUT_LIGATURE = 32L;
    public static final long LAYOUT_SMALLCAPS = 64L;
    public static final long LAYOUT_SWASH = 128L;
    public static final long LAYOUT_KERN = 1024L;
    public static final long LAYOUT_MINIMUM = 1L;
    public static final long LAYOUT_NORMAL = 1056L;
    public static final String SUBFORMAT_NONE = "none";
    public static final String NOTDEF = ".notdef";
    public static final char NOTDEF_CHAR = '\u0000';
    public static final char NOTVALID_CHAR = '\ufffe';
    public static final double AFM_SCALE = 0.001;
    private static final AffineTransform TRANSFORM_IDENTITY = new AffineTransform();
    private static boolean usebitmaps_ = "true".equals(Defs.property((String)"nfont.usebitmaps")) || Defs.property((String)"os.name").indexOf("OS X") == -1;
    private static org.icepdf.core.pobjects.fonts.nfont.b.i plex_ = new org.icepdf.core.pobjects.fonts.nfont.b.i(8, 32768L);
    protected org.icepdf.core.pobjects.fonts.nfont.CMap touni_ = null;
    protected float size_ = 1.0f;
    protected AffineTransform at_ = TRANSFORM_IDENTITY;
    protected Rectangle2D max_ = null;
    private URL source_;

    public static NFont getInstance(String string, int n2, int n3, float f2) {
        return org.icepdf.core.pobjects.fonts.nfont.i.a().a(string, n2, n3, f2);
    }

    public static void setUseBitmaps(boolean bl2) {
        usebitmaps_ = bl2;
    }

    public static boolean getUseBitmaps() {
        return usebitmaps_;
    }

    protected NFont(URL uRL) {
        this.source_ = uRL;
    }

    public NFont deriveFont(float f2) {
        NFont nFont;
        block2: {
            nFont = null;
            try {
                nFont = (NFont)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                if (!logger.isLoggable(Level.FINE)) break block2;
                logger.log(Level.FINE, this.getClass().getName() + " must 'implements Cloneable'");
            }
        }
        nFont.size_ = f2;
        nFont.max_ = null;
        return nFont;
    }

    public NFont deriveFont(AffineTransform affineTransform) {
        NFont nFont = this.deriveFont(this.size_);
        nFont.at_ = affineTransform.isIdentity() ? TRANSFORM_IDENTITY : new AffineTransform(affineTransform);
        return nFont;
    }

    public abstract String getName();

    public abstract String getFamily();

    public URL getSource() {
        return this.source_;
    }

    public String getVersion() {
        return null;
    }

    public String getDesigner() {
        return null;
    }

    public String getCopyright() {
        return null;
    }

    public int getRights() {
        return -1;
    }

    public abstract String getFormat();

    public String getSubformat() {
        return SUBFORMAT_NONE;
    }

    public abstract int getNumGlyphs();

    public int getMaxGlyphNum() {
        return this.getNumGlyphs();
    }

    public float getSize() {
        return this.size_;
    }

    public int getWeight() {
        return 400;
    }

    public int getFlags() {
        return Integer.MIN_VALUE;
    }

    public AffineTransform getTransform() {
        return new AffineTransform(this.at_);
    }

    public boolean isTransformed() {
        return !this.at_.isIdentity();
    }

    public String toUnicode(String string) {
        return this.touni_ != null ? this.touni_.toSelector(string) : string;
    }

    public String toUnicode(char c2) {
        return this.touni_ != null ? this.touni_.toUnicode(c2) : String.valueOf(c2);
    }

    public org.icepdf.core.pobjects.fonts.nfont.CMap getToUnicode() {
        return this.touni_;
    }

    public String fromUnicode(String string) {
        return this.touni_ != null ? this.touni_.fromSelector(string) : string;
    }

    public abstract char getSpaceEchar();

    public Point2D stringAdvance(String string) {
        return this.stringAdvance(string, 0, string != null ? string.length() : 0);
    }

    public Point2D stringAdvance(String string, int n2, int n3) {
        return this.estringAdvance(this.fromUnicode(string), n2, n3);
    }

    public Point2D estringAdvance(String string, int n2, int n3) {
        double d2 = 0.0;
        double d3 = 0.0;
        if (string != null) {
            int n4 = Math.min(n3, string.length());
            for (int i2 = Math.max(n2, 0); i2 < n4; ++i2) {
                Point2D point2D = this.echarAdvance(string.charAt(i2));
                d2 += point2D.getX();
                d3 += point2D.getY();
            }
        }
        return new Point2D.Double(d2, d3);
    }

    public Point2D charAdvance(char c2) {
        return this.echarAdvance(this.fromUnicode(i.a(c2)).charAt(0));
    }

    public abstract Point2D echarAdvance(char var1);

    public Rectangle2D getStringBounds(String string) {
        return this.getStringBounds(string, 0, string != null ? string.length() : 0);
    }

    public Rectangle2D getStringBounds(String string, int n2, int n3) {
        return this.getEstringBounds(this.fromUnicode(string.substring(n2, n3)), n2, n3);
    }

    public Rectangle2D getEstringBounds(String string, int n2, int n3) {
        Rectangle2D rectangle2D = this.getMaxCharBounds();
        rectangle2D.setRect(0.0, rectangle2D.getY(), this.estringAdvance(string, n2, n3).getX(), rectangle2D.getHeight());
        return rectangle2D;
    }

    public abstract Rectangle2D getMaxCharBounds();

    public abstract Rectangle2D getCharBounds(char var1);

    public double getHeight() {
        if (this.max_ == null) {
            this.max_ = this.getMaxCharBounds();
        }
        return this.max_.getHeight();
    }

    public double getAscent() {
        if (this.max_ == null) {
            this.max_ = this.getMaxCharBounds();
        }
        return -this.max_.getY();
    }

    public double getDescent() {
        return this.getHeight() - this.getAscent();
    }

    public boolean canDisplay(char c2) {
        return this.canDisplayEchar(this.fromUnicode(i.a(c2)).charAt(0));
    }

    public abstract boolean canDisplayEchar(char var1);

    public void drawString(Graphics2D graphics2D, String string, float f2, float f3) {
        this.drawString(graphics2D, string, f2, f3, 1024L, 0, null);
    }

    public void drawString(Graphics2D graphics2D, String string, float f2, float f3, long l2, int n2, Color color) {
        String string2 = this.fromUnicode(string);
        this.drawEstring(graphics2D, string2, f2, f3, l2, n2, color);
    }

    public abstract void drawEstring(Graphics2D var1, String var2, float var3, float var4, long var5, int var7, Color var8);

    public static String strFlags(int n2) {
        StringBuilder stringBuilder = new StringBuilder(30);
        if ((1 & n2) != 0) {
            stringBuilder.append("/fix");
        }
        if ((4 & n2) != 0) {
            stringBuilder.append("/sym");
        }
        if ((8 & n2) != 0) {
            stringBuilder.append("/script");
        }
        if ((0x20 & n2) != 0) {
            stringBuilder.append("/nonsym");
        }
        if ((0x40 & n2) != 0) {
            stringBuilder.append("/ital");
        }
        if ((0x10000 & n2) != 0) {
            stringBuilder.append("/allcap");
        }
        if ((0x20000 & n2) != 0) {
            stringBuilder.append("/smcap");
        }
        if ((0x40000 & n2) != 0) {
            stringBuilder.append("/force");
        }
        if ((0x10000000 & n2) != 0) {
            stringBuilder.append("/cond");
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.getName() + "/" + this.getSize() + " " + this.getFormat() + "/" + this.getSubformat();
    }

    protected static org.icepdf.core.pobjects.fonts.nfont.b.i getMultiplex() {
        return plex_;
    }

    public int getStyle() {
        return 0;
    }

    public FontFile deriveFont(Encoding encoding, CMap cMap) {
        return null;
    }

    public FontFile deriveFont(float[] fArray, int n2, float f2, float f3, float f4, char[] cArray) {
        return null;
    }

    public FontFile deriveFont(Map map, int n2, float f2, float f3, float f4, char[] cArray) {
        return null;
    }

    public FontFile deriveFont(float f2, ArrayList arrayList) {
        return null;
    }
}

