/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.util.pdf;

import java.util.List;
import java.util.Vector;
import se.sjobeck.util.pdf.PsiTabell;
import se.sjobeck.util.pdf.PsiTabellImpl;
import se.sjobeck.util.pdf.PsiTabellObject;
import se.sjobeck.util.pdf.PsiTabellObjectImpl;

public class PsiTabellFactory {
    private PsiTabellFactory() {
        assert (false);
    }

    public static PsiTabell buildPsiTabell(String tabellHeader, List<Object> listObj, int numberOfColumns, int[] columnWeight) {
        int numberOfRows = listObj.size() / numberOfColumns;
        if (listObj.size() % numberOfColumns > 0) {
            ++numberOfRows;
        }
        PsiTabellImpl pti = new PsiTabellImpl(tabellHeader, numberOfColumns, numberOfRows, columnWeight);
        for (Object obj : listObj) {
            pti.addPsiTabellObject(new PsiTabellObjectImpl(obj, 10, PsiTabellObject.TextSetting.ORDINARY));
        }
        return pti;
    }

    public static PsiTabell buildEnklaRaderMedTextTabell(String tabellHeader, String text) {
        int[] columnWeight = new int[]{1};
        Vector<Object> fudo = new Vector<Object>();
        fudo.add(text);
        return PsiTabellFactory.buildPsiTabell(tabellHeader, fudo, 1, columnWeight);
    }

    public static PsiTabell buildFyraKolumnerMedTextOchExtraLulLul(String tabellHeader, List<Object> listObj, int[] lullul, int[] columnWeight) {
        int nbrOfColumns = 4;
        PsiTabell bpt = PsiTabellFactory.buildPsiTabell(tabellHeader, listObj, nbrOfColumns, columnWeight);
        for (int i : lullul) {
            int col = i % nbrOfColumns - 1;
            int row = i / nbrOfColumns;
            PsiTabellObject cellObject = bpt.getCellObject(col, row);
            PsiTabellObject.TextSetting[] ts = new PsiTabellObject.TextSetting[]{PsiTabellObject.TextSetting.FAT};
            cellObject.setTextSetting(ts);
        }
        return bpt;
    }

    public static PsiTabell buildTv\u00e5KolumnerMedText(String tabellHeader, List<Object> listObj) {
        int[] columnWeight = new int[]{1, 1};
        return PsiTabellFactory.buildPsiTabell(tabellHeader, listObj, 2, columnWeight);
    }

    public static PsiTabell buildTv\u00e5KolumnerMedText(String tabellHeader, List<Object> listObj, int columnweight_0, int columnWeight_1) {
        int[] columnWeight = new int[]{columnweight_0, columnWeight_1};
        return PsiTabellFactory.buildPsiTabell(tabellHeader, listObj, 2, columnWeight);
    }
}

