/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.util.pdf;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfGState;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import se.sjobeck.datastructures.Projekt;
import se.sjobeck.eKalkyl;
import se.sjobeck.network2.ClientThread;
import se.sjobeck.util.pdf.AmaKoderKlartext;
import se.sjobeck.util.pdf.Content;
import se.sjobeck.util.pdf.DirectContent;
import se.sjobeck.util.pdf.EgenKontroll;
import se.sjobeck.util.pdf.EgenKontroll_Avancerad;
import se.sjobeck.util.pdf.ImageContent;
import se.sjobeck.util.pdf.Kolumn;
import se.sjobeck.util.pdf.MaterialTabell;
import se.sjobeck.util.pdf.Paper;
import se.sjobeck.util.pdf.ProjektSammanstallning;
import se.sjobeck.util.pdf.ProjektTabell;
import se.sjobeck.util.pdf.PsiTabell;
import se.sjobeck.util.pdf.PsiTabellObject;
import se.sjobeck.util.pdf.PsiTabellObjectImpl;
import se.sjobeck.util.pdf.Text;
import se.sjobeck.util.pdf.VerticalAlignment;

public class OutputGenerator {
    private static XStream stream = new XStream(new DomDriver());

    public static void generatePdf(InputStream formatting_data, Projekt currentProject, File outputFile, boolean printFolder) {
        Paper p = (Paper)stream.fromXML(formatting_data);
        OutputGenerator.generatePdf(p, currentProject, outputFile, printFolder);
    }

    public static void generatePdf(String formatting_data, Projekt currentProject, File outputFile, boolean printFolder) {
        Paper p = (Paper)stream.fromXML(formatting_data);
        OutputGenerator.generatePdf(p, currentProject, outputFile, printFolder);
    }

    public static void generatePdf(Paper p, Projekt currentProject, File outputFile, boolean printFolders) {
        Rectangle ps;
        switch (p.size) {
            case A1: {
                ps = PageSize.A1;
                break;
            }
            case A2: {
                ps = PageSize.A2;
                break;
            }
            case A3: {
                ps = PageSize.A3;
                break;
            }
            case A4: {
                ps = PageSize.A4;
                break;
            }
            case A5: {
                ps = PageSize.A5;
                break;
            }
            default: {
                ps = PageSize.A4;
            }
        }
        Document document = p.layout == Paper.PaperRotation.Landscape ? new Document(ps.rotate(), p.marginLeft, p.marginRight, p.marginTop, p.marginBottom) : new Document(ps, p.marginLeft, p.marginRight, p.marginTop, p.marginBottom);
        try {
            PdfWriter w = PdfWriter.getInstance(document, new FileOutputStream(outputFile));
            w.setPageEvent(OutputGenerator.buildPageEventHelper(p, currentProject, outputFile));
            OutputGenerator.initDocument(document);
            document.open();
            System.out.println("Document opened");
            for (Content c : p.content) {
                System.out.println("Adding content '" + c.getClass() + "'");
                c.addContent(document, currentProject, outputFile, printFolders);
            }
            document.close();
            System.out.println("Document closed");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void genereatePdf(EgenKontroll ek, File outputFile) {
        int marginLeft = 10;
        int marginRight = 10;
        int marginTop = 10;
        int marginBottom = 25;
        Document document = new Document(PageSize.A4, marginLeft, marginRight, marginTop, marginBottom);
        try {
            PdfWriter w = PdfWriter.getInstance(document, new FileOutputStream(outputFile));
            PdfPageEventHelper ppeh = OutputGenerator.getPPEH(ek);
            w.setPageEvent(ppeh);
            document.open();
            float flyttaInRubrik = 0.0f;
            float tablewidth = 90.0f;
            PsiTabell psiTabell = ek.getTabell(0).get(0);
            Paragraph t_0 = OutputGenerator.transformToParagraph(psiTabell.getPsiTabellHeader());
            t_0.setIndentationLeft(flyttaInRubrik);
            t_0.setAlignment(1);
            document.add(t_0);
            PsiTabellObjectImpl psiTabellHeader = new PsiTabellObjectImpl((Object)"  ", 6, PsiTabellObject.TextSetting.ORDINARY);
            document.add(OutputGenerator.transformToParagraph(psiTabellHeader));
            PdfPTable ppt = OutputGenerator.transformToPdfPTable(psiTabell);
            ppt.setWidthPercentage(tablewidth);
            ppt.setSpacingAfter(450.0f);
            ppt.setSpacingBefore(80.0f);
            document.add(ppt);
            psiTabell = ek.getTabell(0).get(1);
            psiTabellHeader = new PsiTabellObjectImpl((Object)"  ", 6, PsiTabellObject.TextSetting.ORDINARY);
            document.add(OutputGenerator.transformToParagraph(psiTabellHeader));
            ppt = OutputGenerator.transformToPdfPTable(psiTabell);
            ppt.setWidthPercentage(tablewidth);
            document.add(ppt);
            OutputGenerator.addLogo(document, w.getDirectContent());
            for (int i = 1; i < ek.getNumberOfpages(); ++i) {
                document.newPage();
                Vector<PsiTabell> tabell = ek.getTabell(i);
                int k = 0;
                for (PsiTabell ptab : tabell) {
                    PsiTabellObject psiTabellHeader1 = ptab.getPsiTabellHeader();
                    if (++k > 1) {
                        psiTabellHeader1.setTextSize(4);
                    }
                    t_0 = OutputGenerator.transformToParagraph(psiTabellHeader1);
                    t_0.setIndentationLeft(29.0f);
                    t_0.setAlignment(0);
                    document.add(t_0);
                    psiTabellHeader = new PsiTabellObjectImpl((Object)"  ", 6, PsiTabellObject.TextSetting.ORDINARY);
                    document.add(OutputGenerator.transformToParagraph(psiTabellHeader));
                    ppt = OutputGenerator.transformToPdfPTable(ptab);
                    ppt.setWidthPercentage(tablewidth);
                    document.add(ppt);
                }
            }
            document.close();
        }
        catch (DocumentException ex) {
            Logger.getLogger(OutputGenerator.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(OutputGenerator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private static PdfPageEventHelper getPPEH(EgenKontroll ps) {
        class Fudo
        extends PdfPageEventHelper {
            EgenKontroll ps;
            PdfContentByte cb;
            BaseFont bf = null;
            Font font = null;
            PdfTemplate nPages;

            public Fudo(EgenKontroll ps) {
                this.ps = ps;
            }

            @Override
            public void onOpenDocument(PdfWriter writer, Document document) {
                try {
                    this.bf = BaseFont.createFont("Helvetica", "Cp1252", false);
                    this.font = FontFactory.getFont("Helvetica-Bold", "Cp1252", false, 10.0f, 1);
                    this.cb = writer.getDirectContent();
                    this.nPages = writer.getDirectContent().createTemplate(100.0f, 100.0f);
                    this.nPages.setBoundingBox(new Rectangle(-20.0f, -20.0f, 100.0f, 100.0f));
                }
                catch (DocumentException de) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            @Override
            public void onStartPage(PdfWriter writer, Document document) {
                this.cb.setFontAndSize(this.bf, 10.0f);
                this.cb.beginText();
                float y = 10.0f;
                float _y = document.getPageSize().getHeight() - y;
                this.cb.showTextAligned(0, "eKalkyl", 10.0f, _y, 0.0f);
                this.cb.showTextAligned(1, this.ps.foretag, document.getPageSize().getWidth() / 2.0f + 0.0f, _y, 0.0f);
                this.cb.endText();
                String text = "Sida " + writer.getPageNumber() + " av ";
                float textSize = this.bf.getWidthPoint(text, 10.0f);
                float textBaseX = document.getPageSize().getWidth() - 10.0f;
                float textBaseY = document.getPageSize().getHeight() - 15.0f;
                float adjust = this.bf.getWidthPoint("00", 10.0f);
                this.cb.beginText();
                this.cb.setTextMatrix(textBaseX - textSize - adjust, textBaseY);
                this.cb.showText(text);
                this.cb.endText();
                this.cb.addTemplate(this.nPages, textBaseX - adjust, textBaseY);
            }

            @Override
            public void onEndPage(PdfWriter writer, Document document) {
                float y = 10.0f;
                float xdelta = document.getPageSize().getWidth() - 20.0f;
                float x = 10.0f;
                this.cb.setFontAndSize(this.font.getBaseFont(), 10.0f);
                this.cb.beginText();
                String projectName = "Projektnamn ";
                float widthPoint = this.font.getBaseFont().getWidthPoint(projectName, 10.0f);
                this.cb.showTextAligned(0, projectName, x, y + 10.0f, 0.0f);
                this.cb.endText();
                this.cb.setFontAndSize(this.bf, 10.0f);
                this.cb.beginText();
                String temp = this.ps.getProjektNamn().getText() + " ";
                float textwidth = this.bf.getWidthPoint(temp, 10.0f);
                this.cb.showTextAligned(0, temp, x + widthPoint, y + 10.0f, 0.0f);
                this.cb.endText();
                float usedSpace = 10.0f + widthPoint + textwidth;
                this.cb.setFontAndSize(this.font.getBaseFont(), 10.0f);
                this.cb.beginText();
                String customer = "Kund ";
                widthPoint = this.font.getBaseFont().getWidthPoint(customer, 10.0f);
                float b = usedSpace > x + 0.5f * xdelta ? usedSpace : x + 0.5f * xdelta;
                this.cb.showTextAligned(0, customer, b, y + 10.0f, 0.0f);
                this.cb.endText();
                this.cb.setFontAndSize(this.bf, 10.0f);
                this.cb.beginText();
                temp = this.ps.kund;
                this.cb.showTextAligned(0, temp, b + widthPoint, y + 10.0f, 0.0f);
                this.cb.endText();
                this.cb.setFontAndSize(this.font.getBaseFont(), 10.0f);
                this.cb.beginText();
                String place = "Plats ";
                widthPoint = this.font.getBaseFont().getWidthPoint(place, 10.0f);
                this.cb.showTextAligned(0, place, x, y, 0.0f);
                this.cb.endText();
                this.cb.setFontAndSize(this.bf, 10.0f);
                this.cb.beginText();
                temp = this.ps.plats;
                this.cb.showTextAligned(0, temp, x + widthPoint, y, 0.0f);
                this.cb.endText();
                this.cb.setFontAndSize(this.font.getBaseFont(), 10.0f);
                this.cb.beginText();
                String contact = "Kontakt/tel ";
                widthPoint = this.font.getBaseFont().getWidthPoint(contact, 10.0f);
                this.cb.showTextAligned(0, contact, x + 0.333f * xdelta, y, 0.0f);
                this.cb.endText();
                this.cb.setFontAndSize(this.bf, 10.0f);
                this.cb.beginText();
                temp = this.ps.kontakt;
                this.cb.showTextAligned(0, temp, x + 0.333f * xdelta + widthPoint, y, 0.0f);
                this.cb.endText();
                this.cb.setFontAndSize(this.font.getBaseFont(), 10.0f);
                this.cb.beginText();
                String ansvarig = "Ansvarig/tel ";
                widthPoint = this.font.getBaseFont().getWidthPoint(ansvarig, 10.0f);
                this.cb.showTextAligned(0, ansvarig, x + 0.667f * xdelta, y, 0.0f);
                this.cb.endText();
                this.cb.setFontAndSize(this.bf, 10.0f);
                this.cb.beginText();
                temp = this.ps.ansvarig;
                this.cb.showTextAligned(0, temp, x + 0.667f * xdelta + widthPoint, y, 0.0f);
                this.cb.endText();
                float x1 = 10.0f;
                float x2 = x1 + xdelta;
                this.cb.moveTo(x1, y + 22.0f);
                this.cb.lineTo(x2, y + 22.0f);
                this.cb.stroke();
            }

            @Override
            public void onCloseDocument(PdfWriter writer, Document document) {
                this.nPages.beginText();
                try {
                    this.nPages.setFontAndSize(this.bf, 10.0f);
                }
                catch (Exception e) {
                    Logger.getLogger(this.getClass().toString()).severe(e.toString());
                }
                this.nPages.setTextMatrix(0.0f, 0.0f);
                this.nPages.showText(Integer.toString(writer.getPageNumber() - 1));
                this.nPages.endText();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void addLogo(Document document) {
                Preferences p = Preferences.userNodeForPackage(eKalkyl.class);
                if (p.getBoolean("logo_printpicture", false)) {
                    Image img;
                    try {
                        img = Image.getInstance(p.get("logo_filename", null));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        img = null;
                    }
                    if (img != null) {
                        int orientation = p.getInt("logo_orientation", 0);
                        this.cb.saveState();
                        try {
                            float y;
                            float x;
                            PdfGState gstate = new PdfGState();
                            float alpha = 1.0f - (float)p.getInt("logo_translucent", 50) / 100.0f;
                            gstate.setFillOpacity(alpha);
                            gstate.setStrokeOpacity(alpha);
                            this.cb.setGState(gstate);
                            float pageWidth = document.getPageSize().getWidth();
                            float pageHeight = document.getPageSize().getHeight();
                            float imageWidth = img.getWidth();
                            float imageHeight = img.getHeight();
                            switch (orientation) {
                                case 8: {
                                    x = 0.0f;
                                    y = pageHeight - imageHeight;
                                    break;
                                }
                                case 1: {
                                    x = (pageWidth - imageWidth) / 2.0f;
                                    y = pageHeight - imageHeight;
                                    break;
                                }
                                case 2: {
                                    x = pageWidth - imageWidth;
                                    y = pageHeight - imageHeight;
                                    break;
                                }
                                case 3: {
                                    x = pageWidth - imageWidth;
                                    y = (pageHeight - imageHeight) / 2.0f;
                                    break;
                                }
                                case 4: {
                                    x = pageWidth - imageWidth;
                                    y = 0.0f;
                                    break;
                                }
                                case 5: {
                                    x = (pageWidth - imageWidth) / 2.0f;
                                    y = 0.0f;
                                    break;
                                }
                                case 6: {
                                    x = 0.0f;
                                    y = 0.0f;
                                    break;
                                }
                                case 7: {
                                    x = 0.0f;
                                    y = (pageHeight - imageHeight) / 2.0f;
                                    break;
                                }
                                default: {
                                    x = (pageWidth - imageWidth) / 2.0f;
                                    y = (pageHeight - imageHeight) / 2.0f;
                                }
                            }
                            img.setAbsolutePosition(x, y);
                            this.cb.addImage(img);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        finally {
                            this.cb.restoreState();
                        }
                    }
                }
            }
        }
        return new Fudo(ps);
    }

    private static PdfPageEventHelper getPPEH(EgenKontroll_Avancerad ps) {
        class Fudo
        extends PdfPageEventHelper {
            EgenKontroll_Avancerad ps;
            PdfContentByte cb;
            BaseFont bf = null;
            Font font = null;
            PdfTemplate nPages;

            public Fudo(EgenKontroll_Avancerad ps) {
                this.ps = ps;
            }

            @Override
            public void onOpenDocument(PdfWriter writer, Document document) {
                try {
                    this.bf = BaseFont.createFont("Helvetica", "Cp1252", false);
                    this.font = FontFactory.getFont("Helvetica-Bold", "Cp1252", false, 10.0f, 1);
                    this.cb = writer.getDirectContent();
                    this.nPages = writer.getDirectContent().createTemplate(100.0f, 100.0f);
                    this.nPages.setBoundingBox(new Rectangle(-20.0f, -20.0f, 100.0f, 100.0f));
                }
                catch (DocumentException de) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            @Override
            public void onStartPage(PdfWriter writer, Document document) {
                this.cb.setFontAndSize(this.bf, 10.0f);
                this.cb.beginText();
                float y = 10.0f;
                float _y = document.getPageSize().getHeight() - y;
                this.cb.showTextAligned(0, "eKalkyl\u2122", 10.0f, _y, 0.0f);
                this.cb.showTextAligned(1, this.ps.foretag, document.getPageSize().getWidth() / 2.0f + 0.0f, _y, 0.0f);
                this.cb.endText();
                String text = "Sida " + writer.getPageNumber() + " av ";
                float textSize = this.bf.getWidthPoint(text, 10.0f);
                float textBaseX = document.getPageSize().getWidth() - 10.0f;
                float textBaseY = document.getPageSize().getHeight() - 15.0f;
                float adjust = this.bf.getWidthPoint("00", 10.0f);
                this.cb.beginText();
                this.cb.setTextMatrix(textBaseX - textSize - adjust, textBaseY);
                this.cb.showText(text);
                this.cb.endText();
                this.cb.addTemplate(this.nPages, textBaseX - adjust, textBaseY);
            }

            @Override
            public void onEndPage(PdfWriter writer, Document document) {
                float y = 10.0f;
                float xdelta = document.getPageSize().getWidth() - 20.0f;
                float x = 10.0f;
                this.cb.setFontAndSize(this.font.getBaseFont(), 10.0f);
                this.cb.beginText();
                String projectName = "Projektnamn ";
                float widthPoint = this.font.getBaseFont().getWidthPoint(projectName, 10.0f);
                this.cb.showTextAligned(0, projectName, x, y + 10.0f, 0.0f);
                this.cb.endText();
                this.cb.setFontAndSize(this.bf, 10.0f);
                this.cb.beginText();
                String temp = this.ps.getProjektNamn().getText() + " ";
                float textwidth = this.bf.getWidthPoint(temp, 10.0f);
                this.cb.showTextAligned(0, temp, x + widthPoint, y + 10.0f, 0.0f);
                this.cb.endText();
                float usedSpace = 10.0f + widthPoint + textwidth;
                this.cb.setFontAndSize(this.font.getBaseFont(), 10.0f);
                this.cb.beginText();
                String customer = "Kund ";
                widthPoint = this.font.getBaseFont().getWidthPoint(customer, 10.0f);
                float b = usedSpace > x + 0.5f * xdelta ? usedSpace : x + 0.5f * xdelta;
                this.cb.showTextAligned(0, customer, b, y + 10.0f, 0.0f);
                this.cb.endText();
                this.cb.setFontAndSize(this.bf, 10.0f);
                this.cb.beginText();
                temp = this.ps.kund;
                this.cb.showTextAligned(0, temp, b + widthPoint, y + 10.0f, 0.0f);
                this.cb.endText();
                this.cb.setFontAndSize(this.font.getBaseFont(), 10.0f);
                this.cb.beginText();
                String place = "Plats ";
                widthPoint = this.font.getBaseFont().getWidthPoint(place, 10.0f);
                this.cb.showTextAligned(0, place, x, y, 0.0f);
                this.cb.endText();
                this.cb.setFontAndSize(this.bf, 10.0f);
                this.cb.beginText();
                temp = this.ps.plats;
                this.cb.showTextAligned(0, temp, x + widthPoint, y, 0.0f);
                this.cb.endText();
                this.cb.setFontAndSize(this.font.getBaseFont(), 10.0f);
                this.cb.beginText();
                String contact = "Kontakt/tel ";
                widthPoint = this.font.getBaseFont().getWidthPoint(contact, 10.0f);
                this.cb.showTextAligned(0, contact, x + 0.333f * xdelta, y, 0.0f);
                this.cb.endText();
                this.cb.setFontAndSize(this.bf, 10.0f);
                this.cb.beginText();
                temp = this.ps.kontakt;
                this.cb.showTextAligned(0, temp, x + 0.333f * xdelta + widthPoint, y, 0.0f);
                this.cb.endText();
                this.cb.setFontAndSize(this.font.getBaseFont(), 10.0f);
                this.cb.beginText();
                String ansvarig = "Ansvarig/tel ";
                widthPoint = this.font.getBaseFont().getWidthPoint(ansvarig, 10.0f);
                this.cb.showTextAligned(0, ansvarig, x + 0.667f * xdelta, y, 0.0f);
                this.cb.endText();
                this.cb.setFontAndSize(this.bf, 10.0f);
                this.cb.beginText();
                temp = this.ps.ansvarig;
                this.cb.showTextAligned(0, temp, x + 0.667f * xdelta + widthPoint, y, 0.0f);
                this.cb.endText();
                float x1 = 10.0f;
                float x2 = x1 + xdelta;
                this.cb.moveTo(x1, y + 22.0f);
                this.cb.lineTo(x2, y + 22.0f);
                this.cb.stroke();
            }

            @Override
            public void onCloseDocument(PdfWriter writer, Document document) {
                this.nPages.beginText();
                try {
                    this.nPages.setFontAndSize(this.bf, 10.0f);
                }
                catch (Exception e) {
                    Logger.getLogger(this.getClass().toString()).severe(e.toString());
                }
                this.nPages.setTextMatrix(0.0f, 0.0f);
                this.nPages.showText(Integer.toString(writer.getPageNumber() - 1));
                this.nPages.endText();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void addLogo(Document document) {
                Preferences p = Preferences.userNodeForPackage(eKalkyl.class);
                if (p.getBoolean("logo_printpicture", false)) {
                    Image img;
                    try {
                        img = Image.getInstance(p.get("logo_filename", null));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        img = null;
                    }
                    if (img != null) {
                        int orientation = p.getInt("logo_orientation", 0);
                        this.cb.saveState();
                        try {
                            float y;
                            float x;
                            PdfGState gstate = new PdfGState();
                            float alpha = 1.0f - (float)p.getInt("logo_translucent", 50) / 100.0f;
                            gstate.setFillOpacity(alpha);
                            gstate.setStrokeOpacity(alpha);
                            this.cb.setGState(gstate);
                            float pageWidth = document.getPageSize().getWidth();
                            float pageHeight = document.getPageSize().getHeight();
                            float imageWidth = img.getWidth();
                            float imageHeight = img.getHeight();
                            switch (orientation) {
                                case 8: {
                                    x = 0.0f;
                                    y = pageHeight - imageHeight;
                                    break;
                                }
                                case 1: {
                                    x = (pageWidth - imageWidth) / 2.0f;
                                    y = pageHeight - imageHeight;
                                    break;
                                }
                                case 2: {
                                    x = pageWidth - imageWidth;
                                    y = pageHeight - imageHeight;
                                    break;
                                }
                                case 3: {
                                    x = pageWidth - imageWidth;
                                    y = (pageHeight - imageHeight) / 2.0f;
                                    break;
                                }
                                case 4: {
                                    x = pageWidth - imageWidth;
                                    y = 0.0f;
                                    break;
                                }
                                case 5: {
                                    x = (pageWidth - imageWidth) / 2.0f;
                                    y = 0.0f;
                                    break;
                                }
                                case 6: {
                                    x = 0.0f;
                                    y = 0.0f;
                                    break;
                                }
                                case 7: {
                                    x = 0.0f;
                                    y = (pageHeight - imageHeight) / 2.0f;
                                    break;
                                }
                                default: {
                                    x = (pageWidth - imageWidth) / 2.0f;
                                    y = (pageHeight - imageHeight) / 2.0f;
                                }
                            }
                            img.setAbsolutePosition(x, y);
                            this.cb.addImage(img);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        finally {
                            this.cb.restoreState();
                        }
                    }
                }
            }
        }
        return new Fudo(ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLogo(Document document, PdfContentByte cb) {
        Preferences p = Preferences.userNodeForPackage(eKalkyl.class);
        Image img = null;
        try {
            String get = p.get("logo_filename", null);
            if (get != null) {
                img = Image.getInstance(get);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            img = null;
        }
        if (img != null) {
            int orientation = p.getInt("logo_orientation", 0);
            cb.saveState();
            try {
                float y;
                float x;
                PdfGState gstate = new PdfGState();
                float alpha = 1.0f;
                gstate.setFillOpacity(alpha);
                gstate.setStrokeOpacity(alpha);
                cb.setGState(gstate);
                float pageWidth = document.getPageSize().getWidth();
                float pageHeight = document.getPageSize().getHeight();
                float imageWidth = img.getWidth();
                float imageHeight = img.getHeight();
                switch (orientation) {
                    case 8: {
                        x = 0.0f;
                        y = pageHeight - imageHeight;
                        break;
                    }
                    case 1: {
                        x = (pageWidth - imageWidth) / 2.0f;
                        y = pageHeight - imageHeight;
                        break;
                    }
                    case 2: {
                        x = pageWidth - imageWidth;
                        y = pageHeight - imageHeight;
                        break;
                    }
                    case 3: {
                        x = pageWidth - imageWidth;
                        y = (pageHeight - imageHeight) / 2.0f;
                        break;
                    }
                    case 4: {
                        x = pageWidth - imageWidth;
                        y = 0.0f;
                        break;
                    }
                    case 5: {
                        x = (pageWidth - imageWidth) / 2.0f;
                        y = 0.0f;
                        break;
                    }
                    case 6: {
                        x = 0.0f;
                        y = 0.0f;
                        break;
                    }
                    case 7: {
                        x = 0.0f;
                        y = (pageHeight - imageHeight) / 2.0f;
                        break;
                    }
                    default: {
                        x = (pageWidth - imageWidth) / 2.0f;
                        y = (pageHeight - imageHeight) / 2.0f;
                    }
                }
                img.setAbsolutePosition(x, y);
                cb.addImage(img);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                cb.restoreState();
            }
        }
    }

    private static PdfPageEventHelper getPPEH(ProjektSammanstallning ps) {
        class Fudo
        extends PdfPageEventHelper {
            ProjektSammanstallning ps;
            PdfContentByte cb;
            BaseFont bf = null;
            PdfTemplate nPages;
            private DateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");

            public Fudo(ProjektSammanstallning ps) {
                this.ps = ps;
            }

            @Override
            public void onOpenDocument(PdfWriter writer, Document document) {
                try {
                    this.bf = BaseFont.createFont("Helvetica", "Cp1252", false);
                    this.cb = writer.getDirectContent();
                    this.nPages = writer.getDirectContent().createTemplate(100.0f, 100.0f);
                    this.nPages.setBoundingBox(new Rectangle(-20.0f, -20.0f, 100.0f, 100.0f));
                }
                catch (DocumentException de) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            @Override
            public void onStartPage(PdfWriter writer, Document document) {
                this.cb.setFontAndSize(this.bf, 10.0f);
                this.cb.beginText();
                float y = 10.0f;
                float _y = document.getPageSize().getHeight() - y;
                this.cb.showTextAligned(0, this.ps.getProjektNamn().getText(), 10.0f, _y, 0.0f);
                this.cb.showTextAligned(2, ClientThread.getUserFullName(), document.getPageSize().getWidth() - 10.0f, _y, 0.0f);
                this.cb.showTextAligned(1, "Projektsammanst\u00e4llning", document.getPageSize().getWidth() / 2.0f + 0.0f, _y, 0.0f);
                this.cb.endText();
            }

            @Override
            public void onEndPage(PdfWriter writer, Document document) {
                this.cb.setFontAndSize(this.bf, 10.0f);
                this.cb.beginText();
                float y = 10.0f;
                this.cb.showTextAligned(0, this.dateFormatter.format(new Date()), 10.0f, y, 0.0f);
                this.cb.showTextAligned(1, ClientThread.getApplicationType().toString() + "\u2122", document.getPageSize().getWidth() / 2.0f + 0.0f, y, 0.0f);
                this.cb.endText();
                String text = "Sida " + writer.getPageNumber() + " av ";
                float textSize = this.bf.getWidthPoint(text, 10.0f);
                float textBaseX = document.getPageSize().getWidth() - 10.0f;
                float textBaseY = 15.0f;
                float adjust = this.bf.getWidthPoint("00", 10.0f);
                this.cb.beginText();
                this.cb.setTextMatrix(textBaseX - textSize - adjust, textBaseY);
                this.cb.showText(text);
                this.cb.endText();
                this.cb.addTemplate(this.nPages, textBaseX - adjust, textBaseY);
                this.addLogo(document);
            }

            @Override
            public void onCloseDocument(PdfWriter writer, Document document) {
                this.nPages.beginText();
                try {
                    this.nPages.setFontAndSize(this.bf, 10.0f);
                }
                catch (Exception e) {
                    Logger.getLogger(this.getClass().toString()).severe(e.toString());
                }
                this.nPages.setTextMatrix(0.0f, 0.0f);
                this.nPages.showText(Integer.toString(writer.getPageNumber() - 1));
                this.nPages.endText();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void addLogo(Document document) {
                Preferences p = Preferences.userNodeForPackage(eKalkyl.class);
                if (p.getBoolean("logo_printpicture", false)) {
                    Image img;
                    try {
                        img = Image.getInstance(p.get("logo_filename", null));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        img = null;
                    }
                    if (img != null) {
                        int orientation = p.getInt("logo_orientation", 0);
                        this.cb.saveState();
                        try {
                            float y;
                            float x;
                            PdfGState gstate = new PdfGState();
                            float alpha = 1.0f - (float)p.getInt("logo_translucent", 50) / 100.0f;
                            gstate.setFillOpacity(alpha);
                            gstate.setStrokeOpacity(alpha);
                            this.cb.setGState(gstate);
                            float pageWidth = document.getPageSize().getWidth();
                            float pageHeight = document.getPageSize().getHeight();
                            float imageWidth = img.getWidth();
                            float imageHeight = img.getHeight();
                            switch (orientation) {
                                case 8: {
                                    x = 0.0f;
                                    y = pageHeight - imageHeight;
                                    break;
                                }
                                case 1: {
                                    x = (pageWidth - imageWidth) / 2.0f;
                                    y = pageHeight - imageHeight;
                                    break;
                                }
                                case 2: {
                                    x = pageWidth - imageWidth;
                                    y = pageHeight - imageHeight;
                                    break;
                                }
                                case 3: {
                                    x = pageWidth - imageWidth;
                                    y = (pageHeight - imageHeight) / 2.0f;
                                    break;
                                }
                                case 4: {
                                    x = pageWidth - imageWidth;
                                    y = 0.0f;
                                    break;
                                }
                                case 5: {
                                    x = (pageWidth - imageWidth) / 2.0f;
                                    y = 0.0f;
                                    break;
                                }
                                case 6: {
                                    x = 0.0f;
                                    y = 0.0f;
                                    break;
                                }
                                case 7: {
                                    x = 0.0f;
                                    y = (pageHeight - imageHeight) / 2.0f;
                                    break;
                                }
                                default: {
                                    x = (pageWidth - imageWidth) / 2.0f;
                                    y = (pageHeight - imageHeight) / 2.0f;
                                }
                            }
                            img.setAbsolutePosition(x, y);
                            this.cb.addImage(img);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        finally {
                            this.cb.restoreState();
                        }
                    }
                }
            }
        }
        return new Fudo(ps);
    }

    public static void generatePdf(ProjektSammanstallning ps, File outputFile) {
        int marginLeft = 10;
        int marginRight = 10;
        int marginTop = 10;
        int marginBottom = 10;
        Document document = new Document(PageSize.A4, marginLeft, marginRight, marginTop, marginBottom);
        try {
            PdfWriter w = PdfWriter.getInstance(document, new FileOutputStream(outputFile));
            PdfPageEventHelper ppeh = OutputGenerator.getPPEH(ps);
            w.setPageEvent(ppeh);
            document.open();
            float flyttaInRubrik = 57.0f;
            for (int i = 0; i < ps.getNumberOfPsiTabells(); ++i) {
                PsiTabell psiTabell = ps.getPsiTabell(i);
                Paragraph t_0 = OutputGenerator.transformToParagraph(psiTabell.getPsiTabellHeader());
                t_0.setIndentationLeft(flyttaInRubrik);
                t_0.setAlignment(0);
                document.add(t_0);
                PsiTabellObjectImpl psiTabellHeader = new PsiTabellObjectImpl((Object)"  ", 6, PsiTabellObject.TextSetting.ORDINARY);
                document.add(OutputGenerator.transformToParagraph(psiTabellHeader));
                document.add(OutputGenerator.transformToPdfPTable(psiTabell));
            }
            document.close();
        }
        catch (DocumentException ex) {
            Logger.getLogger(OutputGenerator.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(OutputGenerator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private static PdfPTable transformToPdfPTable(PsiTabell pt) {
        PdfPTable ppt = new PdfPTable(pt.getNumnberOfColums());
        int[] w = new int[pt.getNumnberOfColums()];
        for (int i = 0; i < w.length; ++i) {
            w[i] = pt.getPsiTabellColumnSpacing().getSpacing(i);
        }
        try {
            ppt.setWidths(w);
        }
        catch (DocumentException ex) {
            Logger.getLogger(OutputGenerator.class.getName()).log(Level.SEVERE, null, ex);
        }
        for (int row = 0; row < pt.getNumberOfRows(); ++row) {
            for (int col = 0; col < pt.getNumnberOfColums(); ++col) {
                ppt.addCell(OutputGenerator.transformToParagraph(pt.getCellObject(col, row)));
            }
            ppt.completeRow();
        }
        return ppt;
    }

    private static Paragraph transformToParagraph(PsiTabellObject pto) {
        String fontName = "Times";
        float fontSize = pto.getTextSize();
        int fontStyle = OutputGenerator.getFontStyle(pto.getTextSetting());
        Font font = FontFactory.getFont(fontName, fontSize, fontStyle, BaseColor.BLACK);
        String message = pto.getText();
        Paragraph p = new Paragraph(message, font);
        return p;
    }

    private static int getFontStyle(PsiTabellObject.TextSetting[] textSettings) {
        boolean ordinaryFound = false;
        for (PsiTabellObject.TextSetting ts : textSettings) {
            if (ts != PsiTabellObject.TextSetting.ORDINARY) continue;
            ordinaryFound = true;
        }
        return ordinaryFound ? 0 : 1;
    }

    public static void main(String ... arg) {
        String s = stream.toXML(new Paper());
        System.out.println(s);
    }

    private static PdfPageEventHelper buildPageEventHelper(final Paper p, final Projekt proj, final File outFile) {
        return new PdfPageEventHelper(){
            PdfContentByte cb;
            BaseFont bf = null;
            PdfTemplate nPages;

            @Override
            public void onOpenDocument(PdfWriter writer, Document document) {
                try {
                    this.bf = BaseFont.createFont("Helvetica", "Cp1252", false);
                    this.cb = writer.getDirectContent();
                    this.nPages = writer.getDirectContent().createTemplate(100.0f, 100.0f);
                    this.nPages.setBoundingBox(new Rectangle(-20.0f, -20.0f, 100.0f, 100.0f));
                }
                catch (DocumentException de) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            @Override
            public void onStartPage(PdfWriter writer, Document document) {
                this.cb.setFontAndSize(this.bf, 10.0f);
                for (DirectContent dc : p.header) {
                    dc.addContent(document, proj, this.cb, VerticalAlignment.Top, outFile);
                }
            }

            @Override
            public void onEndPage(PdfWriter writer, Document document) {
                this.cb.setFontAndSize(this.bf, 10.0f);
                for (DirectContent dc : p.footer) {
                    dc.addContent(document, proj, this.cb, VerticalAlignment.Bottom, outFile);
                }
                String text = "Sida " + writer.getPageNumber() + " av ";
                float textSize = this.bf.getWidthPoint(text, 10.0f);
                float textBaseX = document.getPageSize().getWidth() - 20.0f;
                float textBaseY = 30.0f;
                float adjust = this.bf.getWidthPoint("00", 10.0f);
                this.cb.beginText();
                this.cb.setTextMatrix(textBaseX - textSize - adjust, textBaseY);
                this.cb.showText(text);
                this.cb.endText();
                this.cb.addTemplate(this.nPages, textBaseX - adjust, textBaseY);
                this.addLogo(document);
            }

            @Override
            public void onCloseDocument(PdfWriter writer, Document document) {
                this.nPages.beginText();
                try {
                    this.nPages.setFontAndSize(this.bf, 10.0f);
                }
                catch (Exception e) {
                    Logger.getLogger(this.getClass().toString()).severe(e.toString());
                }
                this.nPages.setTextMatrix(0.0f, 0.0f);
                this.nPages.showText(Integer.toString(writer.getPageNumber() - 1));
                this.nPages.endText();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void addLogo(Document document) {
                Preferences p2 = Preferences.userNodeForPackage(eKalkyl.class);
                if (p2.getBoolean("logo_printpicture", false)) {
                    Image img;
                    try {
                        img = Image.getInstance(p2.get("logo_filename", null));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        img = null;
                    }
                    if (img != null) {
                        int orientation = p2.getInt("logo_orientation", 0);
                        this.cb.saveState();
                        try {
                            float y;
                            float x;
                            PdfGState gstate = new PdfGState();
                            float alpha = 1.0f - (float)p2.getInt("logo_translucent", 50) / 100.0f;
                            gstate.setFillOpacity(alpha);
                            gstate.setStrokeOpacity(alpha);
                            this.cb.setGState(gstate);
                            float pageWidth = document.getPageSize().getWidth();
                            float pageHeight = document.getPageSize().getHeight();
                            float imageWidth = img.getWidth();
                            float imageHeight = img.getHeight();
                            switch (orientation) {
                                case 8: {
                                    x = 0.0f;
                                    y = pageHeight - imageHeight;
                                    break;
                                }
                                case 1: {
                                    x = (pageWidth - imageWidth) / 2.0f;
                                    y = pageHeight - imageHeight;
                                    break;
                                }
                                case 2: {
                                    x = pageWidth - imageWidth;
                                    y = pageHeight - imageHeight;
                                    break;
                                }
                                case 3: {
                                    x = pageWidth - imageWidth;
                                    y = (pageHeight - imageHeight) / 2.0f;
                                    break;
                                }
                                case 4: {
                                    x = pageWidth - imageWidth;
                                    y = 0.0f;
                                    break;
                                }
                                case 5: {
                                    x = (pageWidth - imageWidth) / 2.0f;
                                    y = 0.0f;
                                    break;
                                }
                                case 6: {
                                    x = 0.0f;
                                    y = 0.0f;
                                    break;
                                }
                                case 7: {
                                    x = 0.0f;
                                    y = (pageHeight - imageHeight) / 2.0f;
                                    break;
                                }
                                default: {
                                    x = (pageWidth - imageWidth) / 2.0f;
                                    y = (pageHeight - imageHeight) / 2.0f;
                                }
                            }
                            img.setAbsolutePosition(x, y);
                            this.cb.addImage(img);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        finally {
                            this.cb.restoreState();
                        }
                    }
                }
            }
        };
    }

    private static void initDocument(Document document) {
        document.addTitle("Title");
        document.addSubject("Subject");
        document.addKeywords("Keywords");
        document.addCreator("Creator");
        document.addAuthor("Author");
    }

    public static void genereatePdf(EgenKontroll_Avancerad ek, File file) {
        int marginLeft = 10;
        int marginRight = 10;
        int marginTop = 10;
        int marginBottom = 10;
        Document document = new Document(PageSize.A4, marginLeft, marginRight, marginTop, marginBottom);
        try {
            PdfWriter w = PdfWriter.getInstance(document, new FileOutputStream(file));
            PdfPageEventHelper ppeh = OutputGenerator.getPPEH(ek);
            w.setPageEvent(ppeh);
            document.open();
            float flyttaInRubrik = 0.0f;
            float tablewidth = 90.0f;
            PsiTabell psiTabell = ek.getTabell(0).get(0);
            Paragraph t_0 = OutputGenerator.transformToParagraph(psiTabell.getPsiTabellHeader());
            t_0.setIndentationLeft(flyttaInRubrik);
            t_0.setAlignment(1);
            document.add(t_0);
            PsiTabellObjectImpl psiTabellHeader = new PsiTabellObjectImpl((Object)"  ", 6, PsiTabellObject.TextSetting.ORDINARY);
            document.add(OutputGenerator.transformToParagraph(psiTabellHeader));
            PdfPTable ppt = OutputGenerator.transformToPdfPTable(psiTabell);
            ppt.setWidthPercentage(tablewidth);
            ppt.setSpacingAfter(450.0f);
            ppt.setSpacingBefore(80.0f);
            document.add(ppt);
            psiTabell = ek.getTabell(0).get(1);
            psiTabellHeader = new PsiTabellObjectImpl((Object)"  ", 6, PsiTabellObject.TextSetting.ORDINARY);
            document.add(OutputGenerator.transformToParagraph(psiTabellHeader));
            ppt = OutputGenerator.transformToPdfPTable(psiTabell);
            ppt.setWidthPercentage(tablewidth);
            document.add(ppt);
            OutputGenerator.addLogo(document, w.getDirectContent());
            for (int i = 1; i < ek.getNumberOfpages(); ++i) {
                document.newPage();
                Vector<PsiTabell> tabell = ek.getTabell(i);
                int k = 0;
                for (PsiTabell ptab : tabell) {
                    PsiTabellObject psiTabellHeader1 = ptab.getPsiTabellHeader();
                    if (++k > 1) {
                        psiTabellHeader1.setTextSize(4);
                    }
                    t_0 = OutputGenerator.transformToParagraph(psiTabellHeader1);
                    t_0.setIndentationLeft(29.0f);
                    t_0.setAlignment(0);
                    document.add(t_0);
                    psiTabellHeader = new PsiTabellObjectImpl((Object)"  ", 6, PsiTabellObject.TextSetting.ORDINARY);
                    document.add(OutputGenerator.transformToParagraph(psiTabellHeader));
                    ppt = OutputGenerator.transformToPdfPTable(ptab);
                    ppt.setWidthPercentage(tablewidth);
                    document.add(ppt);
                }
            }
            document.close();
        }
        catch (DocumentException ex) {
            Logger.getLogger(OutputGenerator.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(OutputGenerator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    static {
        stream.setMode(1001);
        stream.alias("Paper", Paper.class);
        stream.alias("Text", Text.class);
        stream.alias("Image", ImageContent.class);
        stream.alias("ProjektTabell", ProjektTabell.class);
        stream.alias("MaterialTabell", MaterialTabell.class);
        stream.alias("Kolumn", Kolumn.class);
        stream.alias("AmaKoderKlartext", AmaKoderKlartext.class);
    }
}

