/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.util.pdf;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import se.sjobeck.database.Database;
import se.sjobeck.datastructures.CustomAMA;
import se.sjobeck.datastructures.Projekt;
import se.sjobeck.datastructures.kalkylering.Behandling;
import se.sjobeck.datastructures.kalkylering.BehandlingsTyp;
import se.sjobeck.datastructures.kalkylering.RadHanterare;
import se.sjobeck.datastructures.kalkylering.RadStruct;
import se.sjobeck.datastructures.kalkylering.Underlag;
import se.sjobeck.datastructures.kalkylering.Ytmaterial;
import se.sjobeck.util.pdf.Content;
import se.sjobeck.util.pdf.PDFRenderer;

public class AmaKoderKlartext
implements Content,
PDFRenderer {
    @Override
    public void renderProject(Projekt p, File targetFile, boolean printFolders) {
        Document document = new Document(PageSize.A4.rotate(), 1.0f, 1.0f, 1.0f, 1.0f);
        try {
            PdfWriter w = PdfWriter.getInstance(document, new FileOutputStream(targetFile));
            document.addTitle("Title");
            document.addSubject("Subject");
            document.addKeywords("Keywords");
            document.addCreator("Creator");
            document.addAuthor("Author");
            document.open();
            HashSet<String> koder = new HashSet<String>();
            PdfPTable table = new PdfPTable(5);
            table.setWidthPercentage(90.0f);
            table.setWidths(new int[]{1, 1, 1, 12, 3});
            table.getDefaultCell().setBorderWidth(0.0f);
            table.getDefaultCell().setPadding(5.0f);
            for (RadStruct rad : p.getRader().getRader()) {
                Paragraph paragraph;
                p.getRadHanterare();
                String amaKod = RadHanterare.getAmaKod(rad);
                if (koder.contains(amaKod)) continue;
                koder.add(amaKod);
                if (rad.getBehKod() != null) {
                    paragraph = new Paragraph();
                    CustomAMA customAmaStruct = p.getCustomAMA(rad.getBehKod());
                    paragraph.add(customAmaStruct.getName());
                    paragraph.add(" | ");
                    paragraph.add(customAmaStruct.getBeskrivning());
                    PdfPCell cell = new PdfPCell(paragraph);
                    cell.setGrayFill(0.8f);
                    cell.setColspan(5);
                    cell.setBorder(0);
                    cell.setPadding(5.0f);
                    table.addCell(cell);
                    continue;
                }
                paragraph = new Paragraph();
                Database data = p.getDatabaseInstance();
                p.getRadHanterare();
                paragraph.add(RadHanterare.getAmaKod(rad));
                paragraph.add(" | ");
                Collection<Underlag> us = data.getUnderlag(rad);
                String tempString = "<Felaktigt underlag>";
                for (Underlag u : us) {
                    if (!u.getId().equals(rad.getUnderlagID())) continue;
                    tempString = u.getDescription();
                }
                paragraph.add(tempString);
                paragraph.add(" \\ ");
                Collection<Ytmaterial> ys = data.getYtmaterial(rad);
                tempString = "<Felaktigt ytmaterial>";
                for (Ytmaterial y : ys) {
                    if (!y.getId().equals(rad.getYtmaterialID())) continue;
                    tempString = y.getDescription();
                }
                paragraph.add(tempString);
                PdfPCell cell = new PdfPCell(paragraph);
                cell.setGrayFill(0.8f);
                cell.setColspan(5);
                cell.setBorder(0);
                cell.setPadding(5.0f);
                table.addCell(cell);
                int n = 0;
                for (BehandlingsTyp typ : BehandlingsTyp.values()) {
                    int i;
                    if (n % 2 == 0) {
                        table.getDefaultCell().setGrayFill(1.0f);
                    } else {
                        table.getDefaultCell().setGrayFill(0.95f);
                    }
                    Behandling tempBeh = data.getBehandling(typ, rad);
                    for (i = 0; i < n; ++i) {
                        table.addCell("");
                    }
                    table.addCell(tempBeh.getId());
                    for (i = 2 - n; i > 0; --i) {
                        table.addCell("");
                    }
                    ++n;
                    table.addCell(tempBeh.getDescription());
                    paragraph = new Paragraph();
                    for (Map.Entry<String, Double> entry : tempBeh.getAckordspunkter().entrySet()) {
                        paragraph.add(entry.getKey() + "x" + entry.getValue() + " ");
                    }
                    table.addCell(paragraph);
                }
            }
            document.add(table);
            document.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addContent(Document doc, Projekt proj, File outputFile, boolean printFolders) {
        try {
            HashSet<String> koder = new HashSet<String>();
            PdfPTable table = new PdfPTable(5);
            table.setWidthPercentage(100.0f);
            table.setWidths(new int[]{1, 1, 2, 11, 3});
            table.getDefaultCell().setBorderWidth(0.0f);
            table.getDefaultCell().setPadding(5.0f);
            List<RadStruct> vrs = proj.getRader().getPrintableRader();
            for (RadStruct rad : vrs) {
                Paragraph paragraph;
                proj.getRadHanterare();
                String amaKod = RadHanterare.getAmaKod(rad);
                if (koder.contains(amaKod)) continue;
                koder.add(amaKod);
                if (rad.getBehKod() != null) {
                    paragraph = new Paragraph();
                    CustomAMA customAmaStruct = proj.getCustomAMA(rad.getBehKod());
                    paragraph.add(customAmaStruct.getName());
                    paragraph.add(" | ");
                    paragraph.add(customAmaStruct.getBeskrivning());
                    PdfPCell cell = new PdfPCell(paragraph);
                    cell.setGrayFill(0.8f);
                    cell.setColspan(5);
                    cell.setBorder(0);
                    cell.setPadding(5.0f);
                    table.addCell(cell);
                    continue;
                }
                paragraph = new Paragraph();
                Database data = proj.getDatabaseInstance();
                paragraph.add(RadHanterare.getAmaKod(rad));
                paragraph.add(" | ");
                Collection<Underlag> us = data.getUnderlag(rad);
                String tempString = "<Felaktigt underlag>";
                for (Underlag u : us) {
                    if (!u.getId().equals(rad.getUnderlagID())) continue;
                    tempString = u.getDescription();
                }
                paragraph.add(tempString);
                paragraph.add(" \\ ");
                Collection<Ytmaterial> ys = data.getYtmaterial(rad);
                tempString = "<Felaktigt ytmaterial>";
                for (Ytmaterial y : ys) {
                    if (!y.getId().equals(rad.getYtmaterialID())) continue;
                    tempString = y.getDescription();
                }
                paragraph.add(tempString);
                PdfPCell cell = new PdfPCell(paragraph);
                cell.setGrayFill(0.8f);
                cell.setColspan(5);
                cell.setBorder(0);
                cell.setPadding(5.0f);
                table.addCell(cell);
                int n = 0;
                for (BehandlingsTyp typ : BehandlingsTyp.values()) {
                    int i;
                    if (n % 2 == 0) {
                        table.getDefaultCell().setGrayFill(1.0f);
                    } else {
                        table.getDefaultCell().setGrayFill(0.95f);
                    }
                    Behandling tempBeh = data.getBehandling(typ, rad);
                    for (i = 0; i < n; ++i) {
                        table.addCell("");
                    }
                    table.addCell(tempBeh.getId());
                    for (i = 2 - n; i > 0; --i) {
                        table.addCell("");
                    }
                    ++n;
                    table.addCell(tempBeh.getDescription());
                    paragraph = new Paragraph();
                    for (Map.Entry<String, Double> entry : tempBeh.getAckordspunkter().entrySet()) {
                        paragraph.add(entry.getKey() + "x" + entry.getValue() + " ");
                    }
                    table.addCell(paragraph);
                }
            }
            doc.add(table);
        }
        catch (DocumentException e) {
            Logger.getLogger(this.getClass().getCanonicalName()).severe(e.toString());
        }
    }
}

