/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui.undo;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;
import se.sjobeck.datastructures.RumNod;
import se.sjobeck.datastructures.kalkylering.RadStruct;

public class DeleteRows
extends AbstractUndoableEdit {
    List<RadStruct> deletedRows;
    RumNod nod;

    public DeleteRows(RumNod nod, RadStruct[] rowsToDelete) {
        this.nod = nod;
        this.deletedRows = new LinkedList<RadStruct>();
        this.deletedRows.addAll(Arrays.asList(rowsToDelete));
    }

    @Override
    public boolean addEdit(UndoableEdit anEdit) {
        if (anEdit instanceof DeleteRows) {
            DeleteRows other = (DeleteRows)anEdit;
            if (other.nod == this.nod) {
                this.deletedRows.addAll(other.deletedRows);
                other.die();
                return true;
            }
        }
        return false;
    }

    @Override
    public String getUndoPresentationName() {
        if (this.deletedRows.size() > 1) {
            return "\u00c5ngra borttagning av " + this.deletedRows.size() + " rader";
        }
        return "\u00c5ngra borttagning";
    }

    @Override
    public String getRedoPresentationName() {
        if (this.deletedRows.size() > 1) {
            return "G\u00f6r om borttagning av " + this.deletedRows.size() + " rader";
        }
        return "G\u00f6r om borttagning";
    }

    @Override
    public void undo() {
        super.undo();
        ((Vector)this.nod.getRader()).addAll(this.deletedRows);
    }

    @Override
    public void redo() {
        super.redo();
        ((Vector)this.nod.getRader()).removeAll(this.deletedRows);
    }
}

