/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui.outlookbar;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SingleSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import se.sjobeck.util.WashOutFilter;

public class JOutlookBar
extends JPanel
implements ActionListener,
ChangeListener {
    private ImageIcon closeIcon = new ImageIcon(JOutlookBar.class.getResource("/se/sjobeck/images/dialog-cancel.png"));
    private ImageIcon fadedCloseIcon = new ImageIcon(WashOutFilter.createWashedOutImage(this.closeIcon.getImage()));
    private JPanel topPanel = new JPanel(new GridLayout(1, 1));
    private JPanel bottomPanel = new JPanel(new GridLayout(1, 1));
    private List<BarInfo> bars = new LinkedList<BarInfo>();
    private JComponent visibleComponent = null;
    private SingleSelectionModel selectionModel = new DefaultSingleSelectionModel();

    public JOutlookBar() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.topPanel, "North");
        this.add((Component)this.bottomPanel, "South");
        this.selectionModel.addChangeListener(this);
    }

    public void addSelectionListener(ChangeListener listener) {
        this.selectionModel.addChangeListener(listener);
    }

    public void removeSelectionListener(ChangeListener listener) {
        this.selectionModel.removeChangeListener(listener);
    }

    public void addBar(String name, JComponent component) {
        this.addBar(name, null, component, null);
    }

    public void addBar(String name, JComponent component, Runnable closeAction) {
        this.addBar(name, null, component, closeAction);
    }

    public void addBar(String name, Icon icon, JComponent component) {
        this.addBar(name, icon, component, null);
    }

    public void addBar(String name, Icon icon, JComponent component, final Runnable closeAction) {
        final BarInfo barInfo = new BarInfo(name, icon, component);
        barInfo.getButton().addActionListener(this);
        if (closeAction != null) {
            JButton closeBtn = this.buildCloseButton();
            barInfo.getButton().setLayout(new BorderLayout());
            barInfo.getButton().add((Component)closeBtn, "East");
            closeBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    closeAction.run();
                    JOutlookBar.this.removeBar(barInfo);
                }
            });
        }
        this.bars.add(barInfo);
        if (this.selectionModel.getSelectedIndex() == -1) {
            this.selectionModel.setSelectedIndex(this.bars.size() - 1);
        } else {
            this.render();
        }
    }

    private JButton buildCloseButton() {
        JButton closeBtn = new JButton();
        closeBtn.setBorderPainted(true);
        closeBtn.setContentAreaFilled(false);
        closeBtn.setRolloverEnabled(true);
        closeBtn.setMargin(new Insets(0, 0, 0, 0));
        closeBtn.setIcon(this.fadedCloseIcon);
        closeBtn.setRolloverIcon(this.closeIcon);
        return closeBtn;
    }

    private void removeBar(BarInfo which) {
        int visibleBar = this.selectionModel.getSelectedIndex();
        if (this.bars.indexOf(which) == visibleBar && visibleBar != 0) {
            --visibleBar;
        }
        this.bars.remove(which);
        if (visibleBar >= this.bars.size()) {
            visibleBar = this.bars.size() - 1;
        }
        if (visibleBar != this.selectionModel.getSelectedIndex()) {
            this.selectionModel.setSelectedIndex(visibleBar);
        } else {
            this.render();
        }
    }

    public void removeBar(int index) {
        this.removeBar(this.bars.get(index));
    }

    public int getVisibleBar() {
        return this.selectionModel.getSelectedIndex();
    }

    public JComponent getVisibleComponent() {
        return this.bars.get(this.selectionModel.getSelectedIndex()).getComponent();
    }

    public void setVisibleBar(int visibleBar) {
        this.selectionModel.setSelectedIndex(visibleBar);
    }

    public void render() {
        int totalBars = this.bars.size();
        int topBars = this.selectionModel.getSelectedIndex() + 1;
        int bottomBars = totalBars - topBars;
        Iterator<BarInfo> itr = this.bars.iterator();
        this.topPanel.removeAll();
        GridLayout topLayout = (GridLayout)this.topPanel.getLayout();
        topLayout.setRows(topBars);
        BarInfo barInfo = null;
        for (int i = 0; i < topBars; ++i) {
            barInfo = itr.next();
            this.topPanel.add(barInfo.getButton());
        }
        if (this.visibleComponent != null) {
            this.remove(this.visibleComponent);
        }
        this.visibleComponent = barInfo.getComponent();
        this.add((Component)this.visibleComponent, "Center");
        this.bottomPanel.removeAll();
        GridLayout bottomLayout = (GridLayout)this.bottomPanel.getLayout();
        bottomLayout.setRows(bottomBars);
        for (int i = 0; i < bottomBars; ++i) {
            barInfo = itr.next();
            this.bottomPanel.add(barInfo.getButton());
        }
        this.revalidate();
        this.repaint();
    }

    public int getBarCount() {
        return this.bars.size();
    }

    public String getVisibleBarName() {
        return this.getBarName(this.selectionModel.getSelectedIndex());
    }

    public String getBarName(int index) {
        return this.bars.get(index).getName();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int currentBar = 0;
        for (BarInfo b : this.bars) {
            if (b.getButton() == e.getSource()) {
                this.selectionModel.setSelectedIndex(currentBar);
                b.getButton().setSelected(true);
                return;
            }
            ++currentBar;
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        for (int i = this.bars.size() - 1; i >= 0; --i) {
            this.bars.get(i).getButton().setSelected(i == this.selectionModel.getSelectedIndex());
        }
        this.render();
    }

    class BarInfo {
        private JToggleButton button;
        private JComponent component;

        public BarInfo(String name, JComponent component) {
            this(name, null, component);
        }

        public BarInfo(String name, Icon icon, JComponent component) {
            this.component = component;
            this.button = new JToggleButton(name, icon){

                @Override
                public void paintComponent(Graphics g) {
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                    super.paintComponent(g);
                }
            };
            this.button.setFocusPainted(false);
            this.button.setBorder(BorderFactory.createEtchedBorder());
            if (icon != null) {
                this.button.setFont(this.button.getFont().deriveFont(14.0f));
                ImageIcon grayIcon = new ImageIcon(WashOutFilter.createWashedOutImage(((ImageIcon)icon).getImage()));
                this.button.setIcon(grayIcon);
                this.button.setSelectedIcon(icon);
                this.button.setRolloverEnabled(true);
                this.button.setRolloverIcon(icon);
            }
        }

        public JToggleButton getButton() {
            return this.button;
        }

        public JComponent getComponent() {
            return this.component;
        }

        public String getName() {
            return this.button.getText();
        }
    }
}

