/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import java.util.logging.Logger;
import javax.swing.ListModel;
import se.sjobeck.datastructures.ProjectManager;
import se.sjobeck.datastructures.kalkylering.Produkt;
import se.sjobeck.datastructures.kalkylering.RadStruct;
import se.sjobeck.gui.GenericListModel;
import se.sjobeck.gui.PopupListEditor;

public class YtproduktEditor
extends PopupListEditor {
    private GenericListModel<Produkt> listModel;
    private ProjectManager projectManager;
    private transient Produkt selected = null;

    public YtproduktEditor(ProjectManager pm) {
        super(true);
        this.projectManager = pm;
        this.listModel = new GenericListModel();
    }

    @Override
    public ListModel getListModel(RadStruct r) {
        this.listModel.setListData(this.projectManager.getCurrentProject().getDatabaseInstance().getYtprodukter(r, this.projectManager.getCurrentProject().getFabrikat()));
        for (Produkt p : this.listModel.getList()) {
            if (!p.getProduktKod().equals(r.getProduktKod())) continue;
            this.selected = p;
        }
        return this.listModel;
    }

    @Override
    public Object getValue(RadStruct r) {
        Logger.getLogger("se.sjobeck.gui.TapetEditor").fine("selected: '" + this.selected + "'");
        return this.selected;
    }

    @Override
    public Object getCellEditorValue() {
        for (Produkt p : this.listModel.getList()) {
            if (!this.textField.getText().equals(p.getNamn())) continue;
            return p.getProduktKod();
        }
        return null;
    }

    @Override
    public void willShowDialog() {
    }
}

