/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import se.sjobeck.datastructures.EditableRadTable;
import se.sjobeck.datastructures.ProjectManager;
import se.sjobeck.datastructures.TillaggFactory;
import se.sjobeck.datastructures.TlgStruct;
import se.sjobeck.datastructures.kalkylering.RadStruct;
import se.sjobeck.gui.HidingTlgTab;
import se.sjobeck.gui.PopupEditorPanel;
import se.sjobeck.gui.PopupRenderer;
import se.sjobeck.gui.StopEditingEventListener;

public class TillaggPanel
extends JPanel
implements PopupEditorPanel {
    private HidingTlgTab tlgTab;
    private StopEditingEventListener stopper;
    private RadStruct rad;
    private TableCellEditor editor;
    private ProjectManager manager;
    private MouseAdapter buildListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            TillaggPanel.this.buildTlgString();
        }
    };
    private JButton cancelEditing;
    private JButton stopEditing;
    private JTextField textfield;

    @Override
    public Component getComponent() {
        return this;
    }

    public TillaggPanel(ProjectManager manager) {
        this.manager = manager;
        this.initComponents();
        this.tlgTab = new HidingTlgTab();
        this.add((Component)this.tlgTab, new AbsoluteConstraints(2, 2, 396, 225));
        this.stopper = new StopEditingEventListener();
        for (JList list : this.tlgTab.lists) {
            list.addMouseListener(this.buildListener);
            list.addMouseListener(this.stopper);
            list.addKeyListener(this.stopper);
        }
        this.tlgTab.allaValda.addMouseListener(this.buildListener);
        this.tlgTab.allaValda.addMouseListener(this.stopper);
        this.tlgTab.addKeyListener(this.stopper);
    }

    private void initComponents() {
        this.textfield = new JTextField();
        this.cancelEditing = new JButton();
        this.stopEditing = new JButton();
        this.textfield.setEditable(false);
        this.textfield.setText("jTextField1");
        this.setLayout(new AbsoluteLayout());
        this.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.setPreferredSize(new Dimension(400, 255));
        this.cancelEditing.setIcon(new ImageIcon(this.getClass().getResource("/se/sjobeck/images/dialog-cancel.png")));
        this.cancelEditing.setDefaultCapable(false);
        this.cancelEditing.setMargin(new Insets(2, 2, 2, 2));
        this.cancelEditing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TillaggPanel.this.cancelEditingActionPerformed(evt);
            }
        });
        this.add((Component)this.cancelEditing, new AbsoluteConstraints(318, 233, 40, 20));
        this.stopEditing.setIcon(new ImageIcon(this.getClass().getResource("/se/sjobeck/images/dialog-ok.png")));
        this.stopEditing.setMargin(new Insets(2, 2, 2, 2));
        this.stopEditing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TillaggPanel.this.stopEditingActionPerformed(evt);
            }
        });
        this.add((Component)this.stopEditing, new AbsoluteConstraints(358, 233, 40, 20));
    }

    private void cancelEditingActionPerformed(ActionEvent evt) {
        this.editor.cancelCellEditing();
    }

    private void stopEditingActionPerformed(ActionEvent evt) {
        this.editor.stopCellEditing();
    }

    private void buildTlgString() {
        TlgStruct[] list = this.tlgTab.getTlg();
        String ret = "";
        for (int i = 0; i < list.length; ++i) {
            ret = ret + list[i].getAckpunkt() + (i < list.length - 1 ? ", " : "");
        }
        this.textfield.setText(ret);
    }

    @Override
    public Object getValue(RadStruct r) {
        return EditableRadTable.formatTlgList(r.getTillagg());
    }

    @Override
    public void init(RadStruct rad, JTextField text, TableCellEditor editor) {
        this.stopper.setCellEditor(editor);
        this.textfield = text;
        this.editor = editor;
        this.rad = rad;
    }

    @Override
    public void uninit() {
        PopupRenderer.pop.setVisible(false);
    }

    @Override
    public boolean stopCellEditing() {
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        return this.textfield.getText();
    }

    @Override
    public void willShowDialog() {
        TlgStruct[] ts = TillaggFactory.parseTillagg(this.textfield.getText(), this.rad, this.manager.getCurrentProject());
        this.tlgTab.configure(this.rad, ts, this.manager.getCurrentProject());
    }
}

