/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.EventObject;
import java.util.logging.Logger;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;

public class SelectingEditor
extends DefaultCellEditor {
    SelectingEditor() {
        this(new JTextField());
    }

    SelectingEditor(JTextField t) {
        this(t, false);
    }

    SelectingEditor(JTextField t, boolean commitOnFocusLost) {
        super(t);
        if (commitOnFocusLost) {
            this.editorComponent.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (!e.isTemporary()) {
                        SelectingEditor.this.stopCellEditing();
                    }
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
        } else {
            this.editorComponent.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (!e.isTemporary()) {
                        SelectingEditor.this.cancelCellEditing();
                    }
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
        }
    }

    @Override
    public boolean shouldSelectCell(EventObject ev) {
        try {
            JTable t = (JTable)ev.getSource();
            return !t.isRowSelected(t.getEditingRow());
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        JTextComponent textField = (JTextComponent)this.editorComponent;
        if (value == null) {
            Logger.getLogger("se.sjobeck.gui.SelectingEditor").finest("new value is null, clearing text field");
            textField.setText(null);
        } else {
            Logger.getLogger("se.sjobeck.gui.SelectingEditor").finest("new value is '" + value + "'");
            textField.setText(value.toString());
        }
        textField.selectAll();
        Logger.getLogger("se.sjobeck.gui.SelectingEditor").finest("Text field value: '" + textField.getText() + "'");
        return this.editorComponent;
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        Component c = super.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);
        ((JTextField)c).selectAll();
        return c;
    }
}

